package com.ejianc.business.zdsmaterial.util;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.*;

@Component
public class PushFileUtil<T> {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${eachLink.host}")
    private String host;

    /**
     * 根据第三方系统文件下载地址，上传到本地系统
     * @param url   下载地址
     * @param sourceId  业务单据Id
     * @param billType  单据类型编码
     * @param sourceType    业务类型
     * @param authority 上下文信息
     * @return
     */
    public String uploadFileByUrl(String url, String sourceId, String billType, String sourceType, String authority){
        String downloadFileStr = null;
        try {
            logger.info("根据附件地址:{}", url);
            if(StringUtils.isEmpty(url)){
                logger.error("sourceId-{}的url为空！", sourceId);
                return null;
            }
            final HttpResponse response = HttpUtil.createGet(url).executeAsync();
//            logger.info("根据附件地址：{} 下载附件返回信息:{}", url, JSONObject.toJSONString(response.body()));
            Map<String, InputStream> resp = new HashMap();
            String fileName = response.header("Content-Disposition").split(";")[1].split("=")[1];
            fileName = URLDecoder.decode(fileName, "UTF-8");
            resp.put(fileName, new ByteArrayInputStream(response.bodyBytes()));
            logger.info("根据附件地址：{} 下载附件成功:{}", url, fileName);
            Map<String, Map<String, InputStream>> files = new HashMap<>();

            resp.keySet().stream().forEach(fileKey -> {
                Map<String, InputStream> file = new HashMap<>(1);
                file.put(fileKey, resp.get(fileKey));
                files.put(fileKey, file);
            });
            //文件上传
            List<AttachmentVO> attachmentVOS = FileUtil.getInstance().upFile(sourceType, sourceId, billType, files, authority);
            if (CollectionUtils.isNotEmpty(attachmentVOS)){
                AttachmentVO vo = attachmentVOS.get(0);
                return vo.getFilePath();
            }
        } catch (Exception e) {
            logger.error("根据附件地址下载附件失败:{}", e);
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 基于附件下载地址上传
     * @param fileList
     * @param billType
     * @return
     */
    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType) {
        return uploadFileFormNet(fileList, billType, IdWorker.getId(), null);
    }

    /**
     * 基于附件下载地址上传
     * @param fileList
     * @param billType
     * @param sourceId
     * @param sourceType
     * @return
     */
    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType, Long sourceId, String sourceType) {
        fileList.removeAll(Collections.singleton(null));
        if(CollectionUtils.isEmpty(fileList)){
            return new ArrayList<>();
        }
        List<Long> attachIds = new ArrayList<>();
        for(AttachmentVO file : fileList){
            UploadFileForNetParam param = new UploadFileForNetParam();
            param.setTenantId(InvocationInfoProxy.getTenantid());
            param.setBillType(billType);
            param.setSourceId(sourceId);
            param.setSourceType(StringUtils.isNotBlank(sourceType) ? sourceType : file.getSourceType());
            String url = host + "/filepreview/" + file.getFilePath();
            param.setFilePathList(Collections.singletonList(url));
            Long id = IdWorker.getId();
            param.setNewFileIds(Collections.singletonList(id));
            CommonResponse<String> resp = attachmentApi.uploadFileFormNet(param);
            if(!resp.isSuccess()){
                logger.error("参数-{},附件上传异常-{}", JSONObject.toJSONString(param), resp.getMsg());
            }
            attachIds.add(id);
        }
        return attachIds;
    }

    /**
     * 基于附件下载地址上传
     * @param billType
     * @param sourceId
     * @param sourceType
     * @param fileId
     * @return
     */
    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, Long fileId) {
        if(null == sourceId){
            sourceId = IdWorker.getId();
        }
//        String filePath = this.getFilePath(fileId);
//        return this.uploadFileFormNet(billType, sourceId, sourceType, filePath);
        return this.uploadFileFormNet(billType, sourceId, sourceType, this.getattachById(fileId));
    }

    /**
     * 基于附件下载地址上传
     * @param billType
     * @param sourceId
     * @param sourceType
     * @param attach
     * @return
     */
    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, AttachmentVO attach) {
        if(null == attach){
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = host + "/filepreview/" + attach.getFilePath();
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        param.setNewFileNames(Collections.singletonList(attach.getFileName()));
        CommonResponse<String> resp = attachmentApi.uploadFileFormNet(param);
        if(!resp.isSuccess()){
            logger.error("参数-{},附件上传异常-{}", JSONObject.toJSONString(param), resp.getMsg());
        }
        logger.info("参数-{},附件上传结果-{}", JSONObject.toJSONString(param), resp.getData());
        return id;
    }

    /**
     * 基于附件下载地址上传
     * @param billType
     * @param sourceId
     * @param sourceType
     * @param filePath
     * @return
     */
    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, String filePath) {
        if(StringUtils.isEmpty(filePath)){
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = host + "/filepreview/" + filePath;
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        CommonResponse<String> resp = attachmentApi.uploadFileFormNet(param);
        if(!resp.isSuccess()){
            logger.error("参数-{},附件上传异常-{}", JSONObject.toJSONString(param), resp.getMsg());
        }
        logger.info("参数-{},附件上传结果-{}", JSONObject.toJSONString(param), resp.getData());
        return id;
    }

    /**
     * 查询附件地址
     * @param attachid
     * @return
     */
    public String getFilePath(Long attachid){
        AttachmentVO result = this.getattachById(attachid);
        return result.getFilePath();
    }

    /**
     * 根据attachid查询附件
     * @param attachid
     * @return
     */
    public AttachmentVO getattachById(Long attachid) {
        String url = host + "/ejc-file-web/attachment/no_auth/getattachById";
        Map<String, Object> params = new HashMap<>();
        params.put("attachid", attachid);
        try {
            String responseStr = HttpTookit.getAndHeader(url, params);
            logger.info("attachid-{},附件查询结果-{}", attachid, responseStr);
            CommonResponse<AttachmentVO> resp = JSON.parseObject(responseStr, new TypeReference<CommonResponse<AttachmentVO>>(){});
            if(!resp.isSuccess()){
                throw new BusinessException(resp.getMsg());
            }
            if(null == resp.getData()){
                return new AttachmentVO();
            }
            return resp.getData();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("attachid-{},附件查询异常-{}", attachid, e.getMessage());
        }
        return new AttachmentVO();
    }

    /**
     * 根据sourceId和sourceType查询附件
     * @param sourceId
     * @param sourceType
     * @return
     */
    public List<AttachmentVO> queryListBySourceId(Long sourceId, String sourceType) {
        String url = host + "/ejc-file-web/no_auth/api/attachref/queryListBySourceId";
        Map<String, Object> params = new HashMap<>();
        params.put("sourceId", sourceId);
        params.put("sourceType", sourceType);
        try {
            String responseStr = HttpTookit.getAndHeader(url, params);
            logger.info("sourceId-{},sourceType-{},附件查询结果-{}", sourceId, sourceType, responseStr);
            CommonResponse<List<AttachmentVO>> resp = JSON.parseObject(responseStr, new TypeReference<CommonResponse<List<AttachmentVO>>>(){});
            if(!resp.isSuccess()){
                throw new BusinessException(resp.getMsg());
            }
            return resp.getData();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("sourceId-{},sourceType-{},附件查询异常-{}", sourceId, sourceType, e.getMessage());
        }
        return new ArrayList<>();
    }

    /**
     * 获取附件id
     * @param sourceId
     * @param billType
     * @param sourceType
     * @param fileId
     * @return
     */
    public Long getFileId(Long sourceId, String billType, String sourceType, Long fileId) {
        // 查询单据附件信息并下载
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(sourceId, billType, sourceType, null);
        if (!fileResp.isSuccess() || CollectionUtils.isEmpty(fileResp.getData())) {
            logger.error("获取billType-{},sourceId-{},sourceType-{}对应附件信息失败, {}", billType, sourceId, sourceType, fileResp.getMsg());
            Long newId = this.uploadFileFormNet(billType, sourceId, sourceType, fileId);
            return newId;
        }
        List<AttachmentVO> fileList = fileResp.getData();
        return fileList.get(0).getId();
    }

    /**
     * 创建String，默认值是空串
     * @param object 需要转换的String
     * @return 转换结果
     */
    public static String createString(Object object){
        if (object == null) return "";
        return String.valueOf(object);
    }

    public static String clearBracket(String content) {
        if(StringUtils.isEmpty(content)){
            return content;
        }
        String pattern = "\\([^)]*\\)";//括号内
        content = content.replaceAll(pattern, "");
        return content;
    }

}
