package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.business.zdsmaterial.erp.vo.MessageInfoVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;


@RestController
@RequestMapping(value = "/api/zdsMessageInfo")
public class MessageApi {

    @Autowired
    private IMessageInfoService service;

    @PostMapping(value = "/sendToDoMessage")
    CommonResponse<List<String>> sendToDoMessage(@RequestBody MessageInfoVO vo) {
        if (StringUtils.isAnyBlank(vo.getUserId(),vo.getBillTypeCode(), vo.getTitle(),vo.getFormUrl()
                ,vo.getProcessState(),vo.getProcessStateCode(),vo.getTaskName()) || null==vo.getBillId()){
            throw new BusinessException("必填数据为空");
        }
        service.sendTodo(Arrays.asList(vo.getUserId().split(",")),vo.getBillId().toString(),vo.getBillTypeCode(), vo.getTitle(), vo.getStartUserId(),vo.getFormUrl()
                ,vo.getMaUrl(),vo.getProcessState(),vo.getProcessStateCode(),vo.getTaskName(),vo.getIdea(),vo.getIdeaCode());
        return CommonResponse.success("操作成功！");
    }

}
