package com.ejianc.business.zdsmaterial.plan.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资总控计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("controlPlan")
public class ControlPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IControlPlanService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialConjectureService materialConjectureService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ControlPlanVO> saveOrUpdate(@RequestBody ControlPlanVO saveOrUpdateVO) {
//        //字表规格型号不能为空验证
//        if(CollectionUtil.isNotEmpty(saveOrUpdateVO.getDetailList())) {
//            List<ControlPlanDetailVO> details = saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && StringUtils.isBlank(item.getPropertyValue())).collect(Collectors.toList());
//            if(CollectionUtil.isNotEmpty(details)) {
//                return CommonResponse.error("操作失败，编码为["+details.stream().map(ControlPlanDetailVO::getMaterialCode).collect(Collectors.joining(","))+"]的物料档案未设置规格型号！");
//            }
//        }

        ControlPlanVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ControlPlanVO> queryDetail(Long id) {
    	ControlPlanEntity entity = service.selectById(id);
    	ControlPlanVO vo = BeanMapper.map(entity, ControlPlanVO.class);

        //查询是否存在待识别的物料信息
        List<MaterialConjectureVO> identifyList =  materialConjectureService.getAllByBillId(id);
        vo.setIdentifyList(identifyList);

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ControlPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.deleteByIds(vos.stream().map(ControlPlanVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ControlPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        // 变更/新增
        if(param.getParams().containsKey("projectId")){
            param.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_CHANGE));
        } else {
            param.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_NEW));
        }
        IPage<ControlPlanEntity> page = service.queryPage(param,false);
        IPage<ControlPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // 变更/新增
        if(param.getParams().containsKey("projectId")){
            param.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_CHANGE));
        } else {
            param.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_NEW));
        }
        List<ControlPlanEntity> list = service.queryList(param);
        List<ControlPlanVO> records = BeanMapper.mapList(list, ControlPlanVO.class);
        records.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ControlPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refControlPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ControlPlanVO>> refControlPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ControlPlanEntity> page = service.queryPage(param,false);
        IPage<ControlPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description validateParentTypeId 校验二级分类
     * saveOrUpdateVO id如果有则必输、projectId必输、子表
     */
    @RequestMapping(value = "/validateParentTypeId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, MaterialCategoryEntity>> validateParentTypeId(@RequestBody ControlPlanVO saveOrUpdateVO) {
        Map<Long, MaterialCategoryEntity> map = service.validateParentTypeId(saveOrUpdateVO, true);
        return CommonResponse.success("校验二级分类成功！", map);
    }

    /**
     * @Description getParentMaterialType 获取二级分类
     * materialTypeId 物料末级分类主键
     */
    @RequestMapping(value = "/getParentMaterialType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, MaterialCategoryEntity>> getParentMaterialType(@RequestBody List<Long> materialTypeIds) {
        Map<Long, MaterialCategoryEntity> map = service.getParentMaterialTypeMap(materialTypeIds);
        return CommonResponse.success("获取二级分类成功！", map);
    }
}
