package com.ejianc.business.zdsmaterial.accept.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资验收
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_accept")
public class AcceptEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="site_acceptor_id")
    private Long siteAcceptorId; // 现场验收人id
    @TableField(value="site_acceptor_name")
    private String siteAcceptorName; // 现场验收人name
    @TableField(value="site_acceptor_code")
    private String siteAcceptorCode; // 现场验收人编码
    @TableField(value="pickup_date")
    private Date pickupDate; // 验收日期
    @TableField(value="delivery_bill_code")
    private String deliveryBillCode; // 发货单编码
    @TableField(value="delivery_bill_id")
    private Long deliveryBillId; // 发货单id
    @TableField(value="order_bill_code")
    private String orderBillCode; // 订单编码
    @TableField(value="delivery_bill_code_string")
    private String deliveryBillCodeString; // 来源发货单编码
    @TableField(value="order_bill_id")
    private Long orderBillId; // 订单id /报销单id
    @TableField(value="final_accept_flag")
    private Integer finalAcceptFlag; // 基于发货单的全部验收（最终验收标识）：0-否，1-是 [如果发货单数量与验收数量匹配，则自动全部验收]，自制验收时为0
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型：0:来源发货单;1:自制; 2 其他
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="supplier_link_name")
    private String supplierLinkName; // 供应商联系人
    @TableField(value="supplier_link_phone")
    private String supplierLinkPhone; // 供应商联系人手机号
    @TableField(value="car_code")
    private String carCode; // 车牌号
    @TableField(value="accept_type")
    private Integer acceptType; // 验收方式 0:正常验收;1:直入直出; 
    @TableField(value="bill_type")
    private Integer billType; // 业务类型：0-采购验收；1:甲供材入库(选档案库); 2:临建入库(选档案库)
    @TableField(value="new_mat_flag")
    private Integer newMatFlag; // 是否有新增材料编码：0-否，1-是,2-新增材料推送档案库失败
    @TableField(value="has_new_property_val")
    private Integer hasNewPropertyVal; // 是否有新增属性：0-否，1-是
    @TableField(value="store_id")
    private Long storeId; // 仓库id
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="store_type")
    private Integer storeType; // 仓库类型：1-主材库；2-临建材料，3-甲供材
    @TableField(value="part_used")
    private String partUsed; // 使用部位
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="accept_content")
    private String acceptContent; // 验收内容
    @TableField(value="accept_memo")
    private String acceptMemo; // 验收说明
    @TableField(value="original_file_ids")
    private String originalFileIds; // 原始单据图片ids
    @TableField(value="scene_file_ids")
    private String sceneFileIds; // 现场图片ids
    @TableField(value="pick_contract_id")
    private Long pickContractId; // 领料合同id
    @TableField(value="pick_contract_name")
    private String pickContractName; // 领料合同
    @TableField(value="pick_contract_code")
    private String pickContractCode; // 领料合同编码
    @TableField(value="subcontractor_id")
    private Long subcontractorId; // 分包商id
    @TableField(value="subcontractor_name")
    private String subcontractorName; // 分包商
    @TableField(value="subcontractor_code")
    private String subcontractorCode; // 分包商编码
    @TableField(value="subcontractor_user_id")
    private Long subcontractorUserId; // 分包领料人
    @TableField(value="subcontractor_user_name")
    private String subcontractorUserName; // 分包领料人名称
    @TableField(value="subcontractor_user_phone")
    private Long subcontractorUserPhone; // 分包领料人手机号
    @TableField(value="order_bill_name")
    private String orderBillName; // 订单名称
    @TableField(value="accept_tax_mny")
    private BigDecimal acceptTaxMny;//验收金额
    @TableField(value="close_delivery")
    private Integer closeDelivery; // 0 不关闭 ；1 关闭
    @TableField(value="create_user_name")
    private String createUserName;// 编制者名称
    @TableField(value="material_names")
    private String materialNames; // 验收材料字段拼接
    @TableField(value = "site_acceptor_link_phone")
    private String siteAcceptorLinkPhone; //现场验收人电话
    //项目方签字信息
    @TableField(value="signature_user_id")
    private Long signatureUserId;//签字人id
    @TableField(value="signature_id")
    private Long signatureId;//签字人id
    @TableField(value="signature_user_name")
    private String signatureUserName;//签字人名称
    @TableField(value="signature_user_phone")
    private String signatureUserPhone;//签字人手机号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="signature_date")
    private Date signatureDate ;//签字人签字时间
    @TableField(value="signature_status")
    private Integer signatureStatus; // 签字状态 0:未签字;1:已签字;
    //物资分包商签字信息
    @TableField(value="material_signature_user_id")
    private Long materialSignatureUserId;//签字人id
    @TableField(value="material_signature_id")
    private Long materialSignatureId;//签字id
    @TableField(value="material_signature_user_name")
    private String materialSignatureUserName;//签字人名称
    @TableField(value="material_signature_user_phone")
    private String materialSignatureUserPhone;//签字人手机号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="material_signature_date")
    private Date materialSignatureDate;//签字人签字时间
    @TableField(value="material_signature_status")
    private Integer materialSignatureStatus; // 签字状态 0:未签字;1:已签字;
    //分包合同分包商签字信息
    @TableField(value="sub_signature_user_id")
    private Long subSignatureUserId;//签字人id
    @TableField(value="sub_signature_id")
    private Long subSignatureId;//签字id
    @TableField(value="sub_signature_user_name")
    private String subSignatureUserName;//签字人名称
    @TableField(value="sub_signature_user_phone")
    private String subSignatureUserPhone;//签字人手机号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="sub_signature_date")
    private Date subSignatureDate;//签字人签字时间
    @TableField(value="sub_signature_status")
    private Integer subSignatureStatus; // 签字状态 0:未签字;1:已签字;


    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String sourceSystemId;
    @JsonFormat(pattern = "yyyy-MM-dd HH-mm-ss", timezone = "GMT+8")
    @TableField(value="exact_time")
    private Date exactTime; // 确认时间

    @TableField(value="effect_date")
    private Date effectDate; // 生效日期
    @TableField(value="approve_user_id")
    private Long approveUserId; // 审批人主键
    @TableField(value="approve_user_name")
    private String approveUserName; // 审批人名称

    @TableField(value = "accept_material_type")
    private String acceptMaterialType;//验收材料类型：1-主材验收，2-零星材料

    @TableField(exist=false)
    @SubEntity(serviceName="acceptDetailService", pidName = "acceptId")//此处有pid="xxx"，默认值pid="pid"
    private List<AcceptDetailEntity> detailList = new ArrayList<>(); // 物资验收-清单

    @TableField
    private String pushStoreFlag; //推送库存标识：0-失败，1-成功

    @TableField
    private String pushSupAcceptFlag; //验收单推送供方状态：0-失败，1-成功

    @TableField
    private String pushSupReturnFlag; //验收单推送供方领料签字状态：0-失败，1-成功

    public String getPushSupAcceptFlag() {
        return pushSupAcceptFlag;
    }

    public void setPushSupAcceptFlag(String pushSupAcceptFlag) {
        this.pushSupAcceptFlag = pushSupAcceptFlag;
    }

    public String getPushSupReturnFlag() {
        return pushSupReturnFlag;
    }

    public void setPushSupReturnFlag(String pushSupReturnFlag) {
        this.pushSupReturnFlag = pushSupReturnFlag;
    }

    public String getPushStoreFlag() {
        return pushStoreFlag;
    }

    public void setPushStoreFlag(String pushStoreFlag) {
        this.pushStoreFlag = pushStoreFlag;
    }

    public String getAcceptMaterialType() {
        return acceptMaterialType;
    }

    public void setAcceptMaterialType(String acceptMaterialType) {
        this.acceptMaterialType = acceptMaterialType;
    }

    public Date getExactTime() {
        return exactTime;
    }

    public void setExactTime(Date exactTime) {
        this.exactTime = exactTime;
    }

    public String getSignatureUserPhone() {
        return signatureUserPhone;
    }

    public void setSignatureUserPhone(String signatureUserPhone) {
        this.signatureUserPhone = signatureUserPhone;
    }

    public String getMaterialSignatureUserPhone() {
        return materialSignatureUserPhone;
    }

    public void setMaterialSignatureUserPhone(String materialSignatureUserPhone) {
        this.materialSignatureUserPhone = materialSignatureUserPhone;
    }


    public Long getSignatureUserId() {
        return signatureUserId;
    }

    public void setSignatureUserId(Long signatureUserId) {
        this.signatureUserId = signatureUserId;
    }

    public String getSignatureUserName() {
        return signatureUserName;
    }

    public void setSignatureUserName(String signatureUserName) {
        this.signatureUserName = signatureUserName;
    }

    public Date getSignatureDate() {
        return signatureDate;
    }

    public void setSignatureDate(Date signatureDate) {
        this.signatureDate = signatureDate;
    }

    public Long getMaterialSignatureUserId() {
        return materialSignatureUserId;
    }

    public void setMaterialSignatureUserId(Long materialSignatureUserId) {
        this.materialSignatureUserId = materialSignatureUserId;
    }

    public String getMaterialSignatureUserName() {
        return materialSignatureUserName;
    }

    public void setMaterialSignatureUserName(String materialSignatureUserName) {
        this.materialSignatureUserName = materialSignatureUserName;
    }

    public Date getMaterialSignatureDate() {
        return materialSignatureDate;
    }

    public void setMaterialSignatureDate(Date materialSignatureDate) {
        this.materialSignatureDate = materialSignatureDate;
    }

    public Integer getMaterialSignatureStatus() {
        return materialSignatureStatus;
    }

    public void setMaterialSignatureStatus(Integer materialSignatureStatus) {
        this.materialSignatureStatus = materialSignatureStatus;
    }

    public Long getSignatureId() {
        return signatureId;
    }

    public void setSignatureId(Long signatureId) {
        this.signatureId = signatureId;
    }

    public Long getMaterialSignatureId() {
        return materialSignatureId;
    }

    public void setMaterialSignatureId(Long materialSignatureId) {
        this.materialSignatureId = materialSignatureId;
    }

    public Long getSubSignatureUserId() {
        return subSignatureUserId;
    }

    public void setSubSignatureUserId(Long subSignatureUserId) {
        this.subSignatureUserId = subSignatureUserId;
    }

    public Long getSubSignatureId() {
        return subSignatureId;
    }

    public void setSubSignatureId(Long subSignatureId) {
        this.subSignatureId = subSignatureId;
    }

    public String getSubSignatureUserName() {
        return subSignatureUserName;
    }

    public void setSubSignatureUserName(String subSignatureUserName) {
        this.subSignatureUserName = subSignatureUserName;
    }

    public String getSubSignatureUserPhone() {
        return subSignatureUserPhone;
    }

    public void setSubSignatureUserPhone(String subSignatureUserPhone) {
        this.subSignatureUserPhone = subSignatureUserPhone;
    }

    public Date getSubSignatureDate() {
        return subSignatureDate;
    }

    public void setSubSignatureDate(Date subSignatureDate) {
        this.subSignatureDate = subSignatureDate;
    }

    public Integer getSubSignatureStatus() {
        return subSignatureStatus;
    }

    public void setSubSignatureStatus(Integer subSignatureStatus) {
        this.subSignatureStatus = subSignatureStatus;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public String getSiteAcceptorLinkPhone() {
        return siteAcceptorLinkPhone;
    }

    public void setSiteAcceptorLinkPhone(String siteAcceptorLinkPhone) {
        this.siteAcceptorLinkPhone = siteAcceptorLinkPhone;
    }

    public String getAcceptContent() {
        return acceptContent;
    }

    public void setAcceptContent(String acceptContent) {
        this.acceptContent = acceptContent;
    }

    public String getDeliveryBillCodeString() {
        return deliveryBillCodeString;
    }

    public void setDeliveryBillCodeString(String deliveryBillCodeString) {
        this.deliveryBillCodeString = deliveryBillCodeString;
    }

    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Integer getCloseDelivery() {
        return closeDelivery;
    }

    public void setCloseDelivery(Integer closeDelivery) {
        this.closeDelivery = closeDelivery;
    }

    public BigDecimal getAcceptTaxMny() {
        return acceptTaxMny;
    }

    public void setAcceptTaxMny(BigDecimal acceptTaxMny) {
        this.acceptTaxMny = acceptTaxMny;
    }

    public String getOrderBillName() {
        return orderBillName;
    }

    public void setOrderBillName(String orderBillName) {
        this.orderBillName = orderBillName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public Long getSiteAcceptorId() {
        return siteAcceptorId;
    }

    public void setSiteAcceptorId(Long siteAcceptorId) {
        this.siteAcceptorId = siteAcceptorId;
    }
    public String getSiteAcceptorName() {
        return siteAcceptorName;
    }

    public void setSiteAcceptorName(String siteAcceptorName) {
        this.siteAcceptorName = siteAcceptorName;
    }
    public String getSiteAcceptorCode() {
        return siteAcceptorCode;
    }

    public void setSiteAcceptorCode(String siteAcceptorCode) {
        this.siteAcceptorCode = siteAcceptorCode;
    }
    public Date getPickupDate() {
        return pickupDate;
    }

    public void setPickupDate(Date pickupDate) {
        this.pickupDate = pickupDate;
    }
    public String getDeliveryBillCode() {
        return deliveryBillCode;
    }

    public void setDeliveryBillCode(String deliveryBillCode) {
        this.deliveryBillCode = deliveryBillCode;
    }
    public Long getDeliveryBillId() {
        return deliveryBillId;
    }

    public void setDeliveryBillId(Long deliveryBillId) {
        this.deliveryBillId = deliveryBillId;
    }
    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    public Long getOrderBillId() {
        return orderBillId;
    }

    public void setOrderBillId(Long orderBillId) {
        this.orderBillId = orderBillId;
    }
    public Integer getFinalAcceptFlag() {
        return finalAcceptFlag;
    }

    public void setFinalAcceptFlag(Integer finalAcceptFlag) {
        this.finalAcceptFlag = finalAcceptFlag;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkPhone() {
        return supplierLinkPhone;
    }

    public void setSupplierLinkPhone(String supplierLinkPhone) {
        this.supplierLinkPhone = supplierLinkPhone;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    public Integer getAcceptType() {
        return acceptType;
    }

    public void setAcceptType(Integer acceptType) {
        this.acceptType = acceptType;
    }
    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }
    public Integer getNewMatFlag() {
        return newMatFlag;
    }

    public void setNewMatFlag(Integer newMatFlag) {
        this.newMatFlag = newMatFlag;
    }
    public Integer getHasNewPropertyVal() {
        return hasNewPropertyVal;
    }

    public void setHasNewPropertyVal(Integer hasNewPropertyVal) {
        this.hasNewPropertyVal = hasNewPropertyVal;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }
    public String getPartUsed() {
        return partUsed;
    }

    public void setPartUsed(String partUsed) {
        this.partUsed = partUsed;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAcceptMemo() {
        return acceptMemo;
    }

    public void setAcceptMemo(String acceptMemo) {
        this.acceptMemo = acceptMemo;
    }
    public String getOriginalFileIds() {
        return originalFileIds;
    }

    public void setOriginalFileIds(String originalFileIds) {
        this.originalFileIds = originalFileIds;
    }
    public String getSceneFileIds() {
        return sceneFileIds;
    }

    public void setSceneFileIds(String sceneFileIds) {
        this.sceneFileIds = sceneFileIds;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public Long getPickContractId() {
        return pickContractId;
    }

    public void setPickContractId(Long pickContractId) {
        this.pickContractId = pickContractId;
    }
    public String getPickContractName() {
        return pickContractName;
    }

    public void setPickContractName(String pickContractName) {
        this.pickContractName = pickContractName;
    }
    public String getPickContractCode() {
        return pickContractCode;
    }

    public void setPickContractCode(String pickContractCode) {
        this.pickContractCode = pickContractCode;
    }
    public Long getSubcontractorId() {
        return subcontractorId;
    }

    public void setSubcontractorId(Long subcontractorId) {
        this.subcontractorId = subcontractorId;
    }
    public String getSubcontractorName() {
        return subcontractorName;
    }

    public void setSubcontractorName(String subcontractorName) {
        this.subcontractorName = subcontractorName;
    }
    public String getSubcontractorCode() {
        return subcontractorCode;
    }

    public void setSubcontractorCode(String subcontractorCode) {
        this.subcontractorCode = subcontractorCode;
    }
    public Long getSubcontractorUserId() {
        return subcontractorUserId;
    }

    public void setSubcontractorUserId(Long subcontractorUserId) {
        this.subcontractorUserId = subcontractorUserId;
    }

    public String getSubcontractorUserName() {
        return subcontractorUserName;
    }

    public void setSubcontractorUserName(String subcontractorUserName) {
        this.subcontractorUserName = subcontractorUserName;
    }

    public Long getSubcontractorUserPhone() {
        return subcontractorUserPhone;
    }

    public void setSubcontractorUserPhone(Long subcontractorUserPhone) {
        this.subcontractorUserPhone = subcontractorUserPhone;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Long getApproveUserId() {
        return approveUserId;
    }

    public void setApproveUserId(Long approveUserId) {
        this.approveUserId = approveUserId;
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName;
    }
    
    public List<AcceptDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AcceptDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
