package com.ejianc.business.zdsmaterial.cloudstore.shelf.service;

import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 物资集市
 * 
 * @author generator
 * 
 */
public interface IGoodsService extends IBaseService<GoodsEntity> {

    Boolean inOutStore(List<GoodsEntity> list);

    Boolean inOutStoreRollback(List<GoodsEntity> list);

    /**
     * 更新物资调拨中数量
     * id、allotNum必输
     * flag：false-减，true-加
     * @param vos
     * @param flag
     * @return
     */
    List<GoodsVO> updateAllotNum(List<GoodsVO> vos, Boolean flag);

    /**
     * 更新物资已调拨数量
     * id、allotedNum必输
     * flag：false-减，true-加
     * @param vos
     * @param flag
     * @return
     */
    List<GoodsVO> updateAllotedNum(List<GoodsVO> vos, Boolean flag);

    /**
     * 查询可下单量
     *
     * @param ids
     * @return
     */
    Map<Long, BigDecimal> getAllotableNum(List<Long> ids);

    List<GoodsEntity> getAllByIds(List<Long> ids);
}
