package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.*;
import com.ejianc.business.zdsmaterial.erp.service.IBrandApplyService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationFlowService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("brandApply")
public class BrandApplyBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBrandApplyService service;

	@Autowired
	SessionManager sessionManager;

	@Autowired
	private IBrandService brandService;

	@Autowired
	private IMatSupplierManagerService matSupplierManagerService;

	@Autowired
	private IMaterialCategoryService materialCategoryService;

	@Autowired
	private IUserApi userApi;

	@Value("${common.env.base-host}")
	private String BASE_HOST;

	@Autowired
	private IBrandRelationService relationService;

	@Autowired
	private IBrandRelationFlowService relationFlowService;

	private final String APPLY_PC_URL = "ejc-zdsmaterial-frontend/#/brandApply/card?id=";

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		BrandApplyEntity e = service.selectById(billId);

		String msg = doValidDate(e);
		if(StringUtils.isNotBlank(msg)) {
			return CommonResponse.error(msg);
		}



		UserContext user = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(user.getUserCode());
		e.setCommitUserName(user.getUserName());
		service.saveOrUpdate(e, false);
		return CommonResponse.success("回调处理成功！");
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};
	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		BrandApplyEntity e = service.selectById(billId);

		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {

			String msg = doValidDate(e);
			if(StringUtils.isNotBlank(msg)) {
				return CommonResponse.error(msg);
			}

			UserContext user = sessionManager.getUserContext();
			e.setCommitDate(new Date());
			e.setCommitUserCode(user.getUserCode());
			e.setCommitUserName(user.getUserName());
		}

		//生成品牌信息
		pushToArrchive(e);

		e.setEffectiveDate(new Date());
		service.saveOrUpdate(e, false);

		return CommonResponse.success();
	}

	@Transactional(rollbackFor = Exception.class)
	public void pushToArrchive(BrandApplyEntity e) {
		List<BrandEntity> saveBrandList = new ArrayList<>();
		List<BrandRelationEntity> saveRelations = new ArrayList<>();

		Set<String> brandNames = e.getDetailList().stream().map(BrandApplyDetailEntity::getBrandName).collect(Collectors.toSet());

		//品牌信息验证
		Map<String, BrandEntity> dbBrands = brandService.getAllByNames(new ArrayList<>(brandNames));
		if(MapUtils.isNotEmpty(dbBrands)) {
			throw new BusinessException("品牌【"+dbBrands.keySet().stream().collect(Collectors.joining("、")) +"】已在库,请勿重复申请！");
		}

		//生成新的品牌信息
		BrandEntity brand = null;
		Map<String, BrandEntity> brandNameMap = new HashMap<>();
		for(BrandApplyDetailEntity bp : e.getDetailList()) {
			if(brandNames.contains(bp.getBrandName())) {
				//生成品牌信息
				brand = generateBrandInfo(bp);

				brandNames.remove(bp.getBrandName());
				saveBrandList.add(brand);
				brandNameMap.put(brand.getBrandName(), brand);
			}

			brand = brandNameMap.get(bp.getBrandName());

			//生成品牌关系
			BrandRelationEntity relation = new BrandRelationEntity();
			relation.setBrandId(brand.getId());
			relation.setBrandName(brand.getBrandName());
			relation.setBrandSid(brand.getSourceId());
			relation.setMaterialTypeCode(bp.getMaterialTypeCode());
			relation.setMaterialTypeId(bp.getMaterialTypeId());
			relation.setMaterialTypeName(bp.getMaterialTypeName());
			relation.setMaterialTypeSid(bp.getMaterialTypeSid());
			relation.setMaterialTypePid(bp.getMaterialTypePid());
			relation.setMaterialTypePname(bp.getMaterialTypePname());
			relation.setMaterialTypePsid(bp.getMaterialTypePsid());
			relation.setId(IdWorker.getId());
			relation.setSourceId(ZDSInterfaceCommonUtil.changeLongToGUID(relation.getId()));
			relation.setBrandEnabled(1);
			relation.setSupplierName(bp.getSupplierName());
			relation.setSupplierId(bp.getSupplierId());
			relation.setSupplierCode(bp.getSupplierCode());
			relation.setRelationEnabled(PlanConstant.INTEGER_NO); //默认不启用
			relation.setDbSupplierFlag(bp.getDbSupplierFlag());
			relation.setPushErpFlag(PlanConstant.INTEGER_NO);
			relation.setSupplierSid(bp.getSupplierSid());
			relation.setBrandSequence(0);
			relation.setBrandLabel(null);
			relation.setDelFlag(PlanConstant.STRING_NO);
			relation.setSourceMainId(e.getId());
			relation.setSourceDetailId(bp.getId());
			relation.setSupplierCharacter(PlanConstant.STRING_NO); //默认生产商
			saveRelations.add(relation);

			//生成品牌流水
			BrandRelationFlowEntity flow = new BrandRelationFlowEntity();
			flow.setBillPcUrl(BASE_HOST + APPLY_PC_URL+e.getId());
			flow.setOperateTime(e.getCreateTime());
			flow.setOperateType(PlanConstant.品牌关系流水_品牌信息);
			flow.setOperateUserCode(e.getApplyUserCode());
			flow.setOperateUserId(e.getApplyUserId());
			flow.setOperateUserName(e.getApplyUserName());
			flow.setRelationId(relation.getId());
			flow.setSourceBillId(e.getId());
			flow.setSourceBillDetailId(bp.getId());
			relation.getDetailList().add(flow);
		}

		//验证品牌关系是否已存在
		if(CollectionUtils.isNotEmpty(saveRelations)) {
			List<BrandRelationEntity> dbRelations = relationService.checkRelation(saveRelations);
			if(CollectionUtils.isNotEmpty(dbRelations)) {
				throw new BusinessException("操作失败，" +
						dbRelations.stream().map(r -> "【物料分类】"+r.getMaterialTypeName()+
								",【物料分类编码】"+r.getMaterialTypeCode()+
								",【品牌】"+r.getBrandName()).collect(Collectors.joining("、"))
						+ "已存在！");
			}
		}

		logger.info("品牌申请id-{}生效，新增品牌-{}条", e.getId(), saveBrandList.size());
		if(CollectionUtils.isNotEmpty(saveBrandList)) {
			brandService.saveOrUpdateBatch(saveBrandList, saveBrandList.size(), false);

			//品牌信息推送ERP
			brandService.pushBrandToErp(new DataPushErpParam(BeanMapper.mapList(saveRelations, BrandRelationVO.class), e.getApplyUserId(), PlanConstant.品牌新增, PlanConstant.BRAND_APPLY_BILL_TYPE));
		}

		logger.info("品牌申请id-{}生效，新增品牌关系-{}条", e.getId(), saveRelations.size());
		if(CollectionUtils.isNotEmpty(saveRelations)) {
			List<BrandRelationFlowEntity> saveFlows= saveRelations.stream().flatMap(item -> item.getDetailList().stream()).collect(Collectors.toList());

			logger.info("本次保存品牌关系流水：{}条", saveFlows.size());
			if(CollectionUtils.isNotEmpty(saveFlows)) {
				relationFlowService.saveOrUpdateBatch(saveFlows, saveFlows.size(), false);
			}

			relationService.saveOrUpdateBatch(saveRelations, saveBrandList.size(), false);

			//品牌关系推送ERP
			relationService.syncRelationToErp(new DataPushErpParam(BeanMapper.mapList(saveRelations, BrandRelationVO.class),
					e.getApplyUserId(), PlanConstant.品牌关系新增, PlanConstant.BRAND_APPLY_BILL_TYPE));
		}
	}

	private BrandEntity generateBrandInfo(BrandApplyDetailEntity bp) {
		BrandEntity brand = new BrandEntity();
		brand.setId(IdWorker.getId());
		brand.setSourceId(ZDSInterfaceCommonUtil.changeLongToGUID(brand.getId()));
		brand.setBrandName(bp.getBrandName());
		brand.setSourceType("2");
		brand.setEnabled(PlanConstant.INTEGER_YES);
		brand.setSequence(0);
		brand.setApproveUserId(bp.getApproveUserId());
		brand.setApproveUserCode(bp.getApproveUserCode());
		brand.setApproveUserName(bp.getApproveUserName());
		brand.setApproveUserSid(bp.getApproveUserSid());
		brand.setApplyDetailId(bp.getId());
		brand.setApplyId(bp.getApplyId());
		brand.setRelationEnabled(PlanConstant.INTEGER_NO);
		return brand;
	}


	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("操作失败，不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	private String doValidDate(BrandApplyEntity e) {
		if(CollectionUtils.isEmpty(e.getDetailList())) {
			return "操作失败，品牌信息为空";
		}

		//取第一项对应的审核人
		String msg = setBrandApproveUser(e);
		BrandApplyDetailEntity brand = e.getDetailList().get(0);
		if(null == brand.getApproveUserId()) {
			return "操作失败，[物料分类名称：" + brand.getMaterialTypeName()
					+ ",品牌：" + brand.getBrandName() + "]无对应审核人！";
		}
		return msg;
	}

	private String setBrandApproveUser(BrandApplyEntity e) {
		//检查并设置审核人信息
		List<Long> materialTypeIds = new ArrayList<>(e.getDetailList().stream().map(BrandApplyDetailEntity::getMaterialTypeId).collect(Collectors.toSet()));
		List<MaterialCategoryVO> categorys = materialCategoryService.getAllByIds(materialTypeIds);
		List<Long> categoryPids = new ArrayList<>(categorys.stream().map(MaterialCategoryVO::getParentId).collect(Collectors.toSet()));
		List<MatSupplierManagerEntity> dbList = matSupplierManagerService.getAllByCategoryIds(categorys.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList()));
		if(CollectionUtils.isEmpty(dbList)) {
			return "操作失败，品牌对应分类未设置审核人！";
		}
		List<MaterialCategoryVO> categtoryParents = materialCategoryService.getAllByIds(categoryPids);
		Map<Long, MaterialCategoryVO> categtoryParentsMap = categtoryParents.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
		Map<Long, MaterialCategoryVO> categtoryMap = categorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

		Map<Long, MatSupplierManagerEntity> managerMap = new HashMap<>();
		dbList.stream().forEach(item -> {
			managerMap.put(item.getCategoryId(), item);
		});
		MatSupplierManagerEntity approveUser = null;
		StringBuilder sp = new StringBuilder();
		for(BrandApplyDetailEntity brand : e.getDetailList()) {
			approveUser = managerMap.get(brand.getMaterialTypeId());
			if(null != approveUser) {
				brand.setApproveUserCode(approveUser.getManagerCode());
				brand.setApproveUserId(approveUser.getManagerId());
			} else {
				sp.append("[物料分类名称]：").append(brand.getMaterialTypeName())
						.append(", [分类编码]：").append(brand.getMaterialTypeCode())
						.append(", [品牌]：").append(brand.getBrandName()).append("、");
			}
			brand.setMaterialTypePid(categtoryMap.get(brand.getMaterialTypeId()).getParentId());
			brand.setMaterialTypePsid(categtoryParentsMap.get(categtoryMap.get(brand.getMaterialTypeId()).getParentId()).getSourceId());
			if(StringUtils.isBlank(brand.getMaterialTypePname())) {
				brand.setMaterialTypePsid(categtoryParentsMap.get(categtoryMap.get(brand.getMaterialTypeId()).getParentId()).getName());
			}
		}

//		if(sp.length() > 0) {
//			return sp.substring(0, sp.length()-1) + "无对应审核人！";
//		}

		Set<String> userIdSet = e.getDetailList().stream()
				.filter(item -> null != item.getApproveUserId()).map(item -> item.getApproveUserId().toString()).collect(Collectors.toSet());
		CommonResponse<List<UserVO>> userResp = userApi.queryListByIds(userIdSet.toArray(new String[userIdSet.size()]));
		if(!userResp.isSuccess() || null == userResp.getData()) {
			logger.error("查询品牌分类审核人ids-{}信息失败, {}", JSONObject.toJSONString(userIdSet), JSONObject.toJSONString(userResp));
			return "操作失败，获取审核人信息失败！";
		}
		Map<Long, UserVO> userMap = userResp.getData().stream().collect(Collectors.toMap(UserVO::getId, Function.identity()));
		e.getDetailList().stream().filter(item -> null != item.getApproveUserId()).forEach(item -> {
			if(userMap.containsKey(item.getApproveUserId())){
				item.setApproveUserSid(userMap.get(item.getApproveUserId()).getSourceId());
				item.setApproveUserName(userMap.get(item.getApproveUserId()).getUserName());
			}
		});

		return null;
	}

//	@Override
//	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
//		JSONArray resp = new JSONArray();
//		BrandApplyEntity e = service.selectById(billId);
//		//取第一项对应的审核人
//		String msg = setBrandApproveUser(e);
//		BrandApplyDetailEntity brand = e.getDetailList().get(0);
//		if(null == brand.getApproveUserId()) {
//			return CommonResponse.error("操作失败，[物料分类名称：" + brand.getMaterialTypeName()
//					+ ",品牌：" + brand.getBrandName() + "]无对应审核人！");
//		}
//
//		JSONObject apprUser = new JSONObject();
//		apprUser.put("userId", brand.getApproveUserId());
//		apprUser.put("userName", brand.getApproveUserName());
//		resp.add(apprUser);
//
//		return CommonResponse.success(resp);
//	}

}
