package com.ejianc.business.zdsmaterial.material.controller;

import com.ejianc.business.zdsmaterial.material.service.IPurchaseAnalysisService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/13 10:39
 */
@RestController
@RequestMapping(value = "/purchaseAnalysisData")
public class PurchaseAnalysisDataController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurchaseAnalysisService service;

    @GetMapping(value = "reloadMaterialData")
    public CommonResponse<String> reloadMaterialData() {
        logger.info("采购分析任务开始执行---------START----------------");

        //1、创建今日查询视图
        service.reloadMaterialData();
        logger.info("采购分析任务执行结束---------END-------NICE---------");
        return CommonResponse.success("任务执行成功！");
    }

}
