package com.ejianc.business.zdsmaterial.material.service;

import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 材料分类
 * 
 * @author generator
 * 
 */
public interface IMaterialCategoryService extends IBaseService<MaterialCategoryEntity> {

    List<MaterialCategoryVO> queryList(Map<String, Object> params);
    List<MaterialCategoryVO> queryListAndRuledFlag(Map<String, Object> params);
    MaterialCategoryEntity selectByCode(String code);

    MaterialCategoryVO saveOrUpdateCategory(MaterialCategoryEntity entity);

    List<MaterialCategoryEntity> queryByCodes(List<String> codes);

    /**
     * 查询指定节点下所有的分类
     *
     * @param categoryId
     * @return
     */
    List<MaterialCategoryVO> queryAllByPid(Long categoryId, Integer enabledStatus);

    void updateEnabledStatus(MaterialCategoryEntity dbEntity);

    List<Long> queryChildrenIdsByPIds(List<Long> ids);

    List<MaterialCategoryEntity> selectByName(String name, Long id);

    String generateBillCode(String code);

    List<MaterialCategoryEntity> queryByCode(String code);

    MaterialCategoryVO queryDetail(Long id);

    Map<Long, List<MaterialCategoryVO>> queryCategoryListByMaterialId(List<Long> ids);

    List<MaterialCategoryVO> queryCategoryListByIds(List<Long> ids);

    List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids);

    /**
     * 根据末级分类ID获取对应跟分类及其下所有分类信息
     *
     * @param categoryId
     * @return
     */
    List<MaterialCategoryEntity> getAllCategoryByLeafNodeId(Long categoryId);

    long countCategory(Map<String, Object> params);

    List<Map> getSyncList(Map<String, Object> params);

    void updateCoordination(MaterialCategoryVO materialCategoryVO);

    List<MaterialCategoryEntity> getAllLeafByPids(List<Long> ids, Integer code);

    void syncToErp(Map<String, Object> queryParams);

    List<MaterialCategoryVO> getAllByIds(List<Long> ids);
    String queryPidCodeByCode(String code);


    List<MaterialCategoryVO> getAllBySourceIds(List<String> sourceIds, Integer propertyFlag);

    List<MaterialCategoryEntity> getParentsByChildId(Long id);

    List<MaterialCategoryEntity> getChildrenByPid(Long id);

    void pushToErp(DataPushErpParam dataPushErpParam);

    List<Map> queryListMap(Map<String, Object> condition);

    List<MaterialCategoryVO> getMaterialSecondCategoryList();
}
