package com.ejianc.business.zdsmaterial.material.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategorySettingsEntity;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategorySettingsVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 采购计划控制方式
 * 
 * @author generator
 * 
 */
public interface IMaterialCategorySettingsService extends IBaseService<MaterialCategorySettingsEntity> {



    CommonResponse<MaterialCategorySettingsVO> saveOrUpdate(@RequestBody MaterialCategorySettingsVO saveOrUpdateVO);


    CommonResponse<JSONObject> queryCategoryList(QueryParam param);

    /**
     * 查询当前物资分类控制区间是否重叠
     * @param vo
     * @return
     */
    CommonResponse<Boolean> betweenMinAndMaxRation(MaterialCategorySettingsVO vo);

    /**
     *  查询对应物料分类对应的控制规则 由本级返回本级 无本级返回上级
     * @param ids 物料分类id
     * @return 返回一个map 物料分类id--List<控制规则>
     */
    Map<Long,List<MaterialCategorySettingsEntity>> returnSettings(List<Long> ids);
}
