package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategoryPropertyMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialPropertyRelationService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料分类属性
 * 
 * @author generator
 * 
 */
@Service("materialCategoryPropertyService")
public class MaterialCategoryPropertyServiceImpl extends BaseServiceImpl<MaterialCategoryPropertyMapper, MaterialCategoryPropertyEntity> implements IMaterialCategoryPropertyService{

    @Autowired
    private IMaterialCategoryPropertySubItemService detailService;

    @Autowired
    private IMaterialPropertyRelationService relationService;

    @Lazy
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Override
    public List<MaterialCategoryPropertyVO> getAllByCategoryId(Long categoryId, Integer enabled) {
        List<MaterialCategoryPropertyVO> resp = new ArrayList<>();
        QueryWrapper<MaterialCategoryPropertyEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("category_id", categoryId);
        if(null != enabled) {
            query.eq("enabled", enabled);
        }
        query.orderByAsc("sequence");

        List<MaterialCategoryPropertyEntity> eList = super.list(query);
        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, MaterialCategoryPropertyVO.class);
        }

        return resp;
    }

    @Override
    public List<MaterialCategoryPropertyVO> getAllPropertiesAndValue(Long categoryId, Integer enabled, Boolean includeUnValid) {
        List<MaterialCategoryPropertyVO> properties = getAllByCategoryId(categoryId, enabled);
        List<MaterialCategoryPropertySubItemVO> values = detailService.getAllByCategoryId(categoryId, includeUnValid);
        Map<String, List<MaterialCategoryPropertySubItemVO>> propertyValueMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(values)) {
            propertyValueMap.putAll(values.stream().collect(Collectors.groupingBy(item -> item.getPropertyId().toString())));
        }

        properties.stream().filter(property -> propertyValueMap.containsKey(property.getId().toString())).forEach(property -> {
            property.setItemList(propertyValueMap.get(property.getId().toString()));
        });

        return properties;
    }
    /**
     * 含默认单位信息
     * @param categoryId
     * @param enabled
     * @param includeUnValid
     * @return
     */
    @Override
    public List<MaterialCategoryPropertyVO> getAllPropertiesAndValueHaveUnit(Long categoryId, Integer enabled, Boolean includeUnValid) {
        List<MaterialCategoryPropertyVO> properties = this.getAllPropertiesAndValue(categoryId, enabled, includeUnValid);
        if (null != categoryId) {
            List<MaterialCategoryEntity> categoryEntityList = materialCategoryService.getParentsByChildId(categoryId);
            //根据内码逆续排列
            categoryEntityList = categoryEntityList.stream().filter(item -> null != item.getMainUnitId())
                    .sorted(Comparator.comparing(MaterialCategoryEntity::getInnerCode).reversed()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(categoryEntityList)) {
                MaterialCategoryPropertyVO materialCategoryPropertyVO = new MaterialCategoryPropertyVO();
                materialCategoryPropertyVO.setId(1l);
                materialCategoryPropertyVO.setCategoryId(categoryId);
                materialCategoryPropertyVO.setCode(categoryEntityList.get(0).getMainUnitId().toString());
                materialCategoryPropertyVO.setName(categoryEntityList.get(0).getMainUnitName());
                properties.add(materialCategoryPropertyVO);
            }
        }
        return properties;
    }

    @Override
    public String checkQuote(List<Long> propertyIds) {
        List<MaterialPropertyRelationVO> relations = relationService.getAllByPropertyIds(propertyIds);
        if(CollectionUtils.isNotEmpty(relations)) {
            Set<Long> quotePropertyIds = relations.stream().map(MaterialPropertyRelationVO::getPropertyId).collect(Collectors.toSet());
            QueryWrapper<MaterialCategoryPropertyEntity> query = new QueryWrapper<>();
            query.select("name");
            query.in("id", quotePropertyIds);
            List<Object> names = super.listObjs(query);

            return "属性【" + names.stream().map(item -> item.toString()).collect(Collectors.joining(",")) + "】被引用";
        }
        return null;
    }

    @Override
    public List<MaterialCategoryPropertyVO> queryByIds(List<Long> ids) {
        List<MaterialCategoryPropertyVO> resp = new ArrayList<>();

        QueryWrapper<MaterialCategoryPropertyEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.orderByAsc("sequence");
        List<MaterialCategoryPropertyEntity> eList = super.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, MaterialCategoryPropertyVO.class);
        }

        return resp;
    }

    @Override
    public Map<Long, List<MaterialCategoryPropertyVO>> getAllByCategoryIds(List<Long> categoryIds) {
        Map<Long, List<MaterialCategoryPropertyVO>> result = new HashMap<>();
        QueryWrapper<MaterialCategoryPropertyEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.orderByAsc("sequence");
        List<MaterialCategoryPropertyEntity> eList = super.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            result.putAll(BeanMapper.mapList(eList, MaterialCategoryPropertyVO.class).stream().collect(Collectors.groupingBy(MaterialCategoryPropertyVO::getCategoryId, Collectors.toList())));
        }

        return result;
    }
    @Override
    public Map<Long, List<MaterialCategoryPropertyVO>> getAllByCategoryIds(List<Long> categoryIds, Integer enabled) {
        Map<Long, List<MaterialCategoryPropertyVO>> result = new HashMap<>();
        QueryWrapper<MaterialCategoryPropertyEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("enabled", enabled);
        query.orderByAsc("sequence");
        List<MaterialCategoryPropertyEntity> eList = super.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            result.putAll(BeanMapper.mapList(eList, MaterialCategoryPropertyVO.class).stream()
                    .collect(Collectors.groupingBy(MaterialCategoryPropertyVO::getCategoryId, Collectors.toList())));
        }

        return result;
    }
}
