package com.ejianc.business.zdsmaterial.pick.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.mapper.ProSubPickerMapper;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubPickerVO;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包领料设置子表-领料人
 * 
 * @author generator
 * 
 */
@Service("proSubPickerService")
public class ProSubPickerServiceImpl extends BaseServiceImpl<ProSubPickerMapper, ProSubPickerEntity> implements IProSubPickerService {
    @Autowired
    private ISubSupplierApi supplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private final String REQ_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateUser";
    private final String REQ_DEL_URL = "/ejc-idm-web/openapi/api/user/removeUserAccRole";

    @Value("${eachLink.host}")
    private String host;

    @Value("${eachLink.appId}")
    private String appId;

    @Value("${eachLink.secret}")
    private String secret;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void resultDelList(List<ProSubPickerEntity> delPickerList){
        List<ProSubPickerEntity> resultList = new ArrayList<>();
        QueryWrapper<ProSubPickerEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("supplier_id", delPickerList.get(0).getSupplierId());
        queryWrapper.notIn("id", delPickerList.stream().map(ProSubPickerEntity::getId).toArray());

        List<ProSubPickerEntity> list = super.list(queryWrapper);
        if (list.size()>0){
            Map<Long, ProSubPickerEntity> collect  = list.stream().collect(Collectors.toMap(e -> e.getSupUserId(), e -> e, (v1,v2) -> v1));
            CommonResponse<SupplierVO> supplierCommonResponse = supplierApi.getOneById(delPickerList.get(0).getSupplierId());
            logger.info("查询分包供应商:{}",JSONObject.toJSONString(supplierCommonResponse));

            if (!supplierCommonResponse.isSuccess()) {
                throw new BusinessException("查询分包供应商失败!");
            }
            SupplierVO supplierVo = supplierCommonResponse.getData();
            Long tenant = supplierVo.getTenant();
            for (ProSubPickerEntity entity:delPickerList){
                if (!collect.containsKey(entity.getSupUserId())){
                    delRoleByPicker(entity,tenant);
                }
            }
        }
    }

    @Override
    public CommonResponse<ProSubPickerVO> enablePickerSupAcc(Long id) {
        ProSubPickerEntity e = super.selectById(id);

        if (null != e.getCoordination() && PlanConstant.STRING_NO.equals(e.getCoordination())) {
            CommonResponse<SupplierVO> supplierCommonResponse = supplierApi.getOneById(e.getSupplierId());
            logger.info("查询分包供应商:{}",JSONObject.toJSONString(supplierCommonResponse));

            if (!supplierCommonResponse.isSuccess()) {
                throw new BusinessException("查询分包供应商失败!");
            }
            SupplierVO supplierVo = supplierCommonResponse.getData();
            if (null ==supplierVo.getCoordination()||!PlanConstant.STRING_YES.equals(supplierVo.getCoordination())) {
                supplierApi.accCoordination(supplierVo);
            }
            ProSubPickerVO supAccount = createSupAccount(e, supplierVo.getTenant());
            return CommonResponse.success("添加成功！", supAccount);
        }
        return CommonResponse.success("添加成功！", BeanMapper.map(e, ProSubPickerVO.class));
    }

    @Override
    public CommonResponse<ProSubPickerVO> querySupByPhone(ProSubPickerVO proSubPickerVO) {
        //根据账号查询是否存在人员
        QueryWrapper<ProSubPickerEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("supplier_emp_phone", proSubPickerVO.getSupplierEmpPhone());
//        queryWrapper.eq("supplier_id", proSubPickerVO.getSupplierEmpPhone());
        List<ProSubPickerEntity> list = super.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.success("查询成功", null);
        }
        ProSubPickerEntity entity = list.get(0);
        proSubPickerVO.setSupplierEmpName(entity.getSupplierEmpName());
        proSubPickerVO.setSupplierEmpCard(entity.getSupplierEmpCard());
        proSubPickerVO.setSupplierEmpPhone(entity.getSupplierEmpPhone());
        proSubPickerVO.setPickerMemo(entity.getPickerMemo());
        proSubPickerVO.setSupplierEmpFileId(entity.getSupplierEmpFileId());
        proSubPickerVO.setSupUserId(entity.getSupUserId());
        proSubPickerVO.setSupTenantId(entity.getSupTenantId());
        proSubPickerVO.setCoordination(entity.getCoordination());
        return CommonResponse.success("查询成功", proSubPickerVO);
    }

    @Override
    public CommonResponse<ProSubPickerVO> accCoordination(ProSubPickerVO proSubPickerVO) {

        QueryWrapper<ProSubPickerEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("supplier_emp_phone", proSubPickerVO.getSupplierEmpPhone());
        queryWrapper.eq("supplier_id", proSubPickerVO.getSupplierId());
        queryWrapper.eq("contract_id", proSubPickerVO.getContractId());
        List<ProSubPickerEntity> list = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("当前人员在当前合同下已经存在了！");
        }

        if (null != proSubPickerVO.getCoordination() && PlanConstant.STRING_NO.equals(proSubPickerVO.getCoordination())) {
            CommonResponse<SupplierVO> supplierCommonResponse = supplierApi.getOneById(proSubPickerVO.getSupplierId());
            logger.info("查询分包供应商:{}",JSONObject.toJSONString(supplierCommonResponse));

            if (!supplierCommonResponse.isSuccess()) {
                throw new BusinessException("查询分包供应商失败!");
            }
            SupplierVO supplierVo = supplierCommonResponse.getData();
            if (null ==supplierVo.getCoordination()||!PlanConstant.STRING_YES.equals(supplierVo.getCoordination())) {
                supplierApi.accCoordination(supplierVo);
            }
            ProSubPickerVO supAccount = createSupAccount(BeanMapper.map(proSubPickerVO, ProSubPickerEntity.class), supplierVo.getTenant());
            return CommonResponse.success("添加成功！", supAccount);
        }
        return CommonResponse.success("添加成功！", proSubPickerVO);
    }

    public ProSubPickerVO createSupAccount(ProSubPickerEntity entity, Long supTenantId) {
        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("linkMobile", entity.getSupplierEmpPhone());
        reqParam.put("linkName", entity.getSupplierEmpName());
        reqParam.put("linkSupType", "sub");
        reqParam.put("supplierAccRole", "分包领料人");
        reqParam.put("supplierTenantId", supTenantId.toString());

        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithUniversal(REQ_URL,
                RequestMethod.POST, JSONObject.toJSONString(reqParam), appId, secret, host);
        if(!syncReqResp.isSuccess()) {
            logger.error("分包领料设置领料人手机号-{}生成协同账户失败，参数：{}, 结果：{}", entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(syncReqResp));
            throw new BusinessException("分包领料设置领料人生成协同账户失败！");

        }
        CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
        if (!resp.isSuccess()) {
            logger.error("分包领料设置领料人手机号-{}生成协同账户失败，参数：{}, 结果：{}", entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(resp));
            throw new BusinessException("生成供方协同账户信息失败！");
        }
        entity.setCoordination(PlanConstant.STRING_YES);
        entity.setSupUserId(resp.getData().getLong("userId"));
        entity.setSupTenantId(resp.getData().getLong("tenantId"));
        entity.setEnabledState(PlanConstant.STRING_YES);
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ProSubPickerVO.class);
    }



    public void delRoleByPicker(ProSubPickerEntity entity, Long supTenantId) {
        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("userId", entity.getSupUserId().toString());
        reqParam.put("tenantId", supTenantId.toString());
        reqParam.put("accRole", "分包领料人");
        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithUniversal(REQ_DEL_URL,
                RequestMethod.POST, JSONObject.toJSONString(reqParam), appId, secret, host);
        if(!syncReqResp.isSuccess()) {
            logger.error("分包领料设置领料人删除手机号-{}生成协同账户失败，参数：{}, 结果：{}", entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(syncReqResp));
            throw new BusinessException("分包领料设置领料人删除生成协同账户失败！");

        }
        CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
        if (!resp.isSuccess()) {
            logger.error("分包领料设置领料人删除手机号-{}生成协同账户失败，参数：{}, 结果：{}", entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(resp));
            throw new BusinessException("生成供方协同账户信息失败！");
        }
    }
}
