package com.ejianc.business.zdsmaterial.cloudstore.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.mapper.GoodsMapper;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.business.zdsstore.api.IIdleManageApi;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资集市
 * 
 * @author generator
 * 
 */
@Service("goodsService")
public class GoodsServiceImpl extends BaseServiceImpl<GoodsMapper, GoodsEntity> implements IGoodsService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIdleManageApi idleManageApi;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public Boolean inOutStore(List<GoodsEntity> list) {
        ArrayList<IdleFlowVO> flowVOS = new ArrayList<>();
        for(GoodsEntity t : list){
            IdleFlowVO flowVO = new IdleFlowVO();
            flowVO.setBillCode(t.getMaterialCode());
            flowVO.setBillDate(new Date());
            flowVO.setStoreId(t.getStoreId());
            flowVO.setStoreName(t.getStoreName());
            flowVO.setProjectId(t.getProjectId());
            flowVO.setProjectName(t.getProjectName());
            flowVO.setOrgId(t.getOrgId());
            flowVO.setOrgName(t.getOrgName());
            flowVO.setParentOrgId(t.getParentOrgId());
            flowVO.setParentOrgName(t.getParentOrgName());
            flowVO.setParentOrgCode(t.getParentOrgCode());
            flowVO.setMaterialCategoryId(t.getMaterialTypeId());
            flowVO.setMaterialCategoryName(t.getMaterialTypeName());
            flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialCode(t.getMaterialCode());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getPropertyValue());
            flowVO.setBrandId(t.getBrandId());
            flowVO.setBrandName(t.getBrandName());
            flowVO.setProductCode(t.getProductCode());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnitName());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setNum(t.getNum());

            flowVO.setSourceId(t.getId());
            flowVO.setRowState(t.getRowState());
//            flowVO.setSourceBillTypeCode(PlanConstant.DISPOSE_BILL_TYPE);
            flowVO.setSourceBillTypeName("闲置物资");
            flowVO.setSourceBillRemark(t.getMemo());
            flowVOS.add(flowVO);
        }
        logger.info("调用库存参数：————"+JSONObject.toJSONString(flowVOS));
        CommonResponse<String> response = idleManageApi.inOutStore(flowVOS);
        if(!response.isSuccess()) {
            throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
        }
        return true;
    }

    @Override
    public Boolean inOutStoreRollback(List<GoodsEntity> list) {
        for(GoodsEntity t : list){
            CommonResponse<String> response = idleManageApi.inOutStoreRollback(t.getId());
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        }
        return true;
    }

    @Override
    public List<GoodsVO> updateAllotNum(List<GoodsVO> vos, Boolean flag) {
        List<Long> ids = vos.stream().map(GoodsVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(ids)){
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x->x.getId(), x->x, (v1, v2)->v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<GoodsEntity> list = super.queryList(param);
        for(GoodsEntity entity : list){
            BigDecimal num = map.get(entity.getId()).getAllotNum();
            if(flag){
                entity.setAllotNum(ComputeUtil.safeAdd(entity.getAllotNum(), num));
            } else {
                entity.setAllotNum(ComputeUtil.safeSub(entity.getAllotNum(), num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub(entity.getNum(), entity.getAllotedNum(), entity.getAllotNum()));
            if(ComputeUtil.isLessThan(entity.getSurplusNum(), BigDecimal.ZERO)){
                throw new BusinessException("剩余可调拨数量不能小于0!");
            }
            // 售罄下架
            if(ComputeUtil.isEmpty(entity.getSurplusNum())){
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);//下架类型0-手动下架，1-售罄下架，2-到期下架
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            // 调拨中数量删除则恢复上架
            if(PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) &&
                    ComputeUtil.isGreaterThan(entity.getSurplusNum(), BigDecimal.ZERO)){
                entity.setStatus(PlanConstant.GOODS_STATUS_ON);
            }
        }
        super.saveOrUpdateBatch(list);
        return BeanMapper.mapList(list, GoodsVO.class);
    }

    @Override
    public List<GoodsVO> updateAllotedNum(List<GoodsVO> vos, Boolean flag) {
        List<Long> ids = vos.stream().map(GoodsVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(ids)){
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x->x.getId(), x->x, (v1, v2)->v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<GoodsEntity> list = super.queryList(param);
        for(GoodsEntity entity : list){
            BigDecimal num = map.get(entity.getId()).getAllotedNum();
            if(flag){
                entity.setAllotedNum(ComputeUtil.safeAdd(entity.getAllotedNum(), num));
            } else {
                entity.setAllotedNum(ComputeUtil.safeSub(entity.getAllotedNum(), num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub(entity.getNum(), entity.getAllotedNum(), entity.getAllotNum()));
            if(ComputeUtil.isLessThan(entity.getSurplusNum(), BigDecimal.ZERO)){
                throw new BusinessException("剩余可调拨数量不能小于0!");
            }
            // 售罄下架
            if(ComputeUtil.isEmpty(entity.getSurplusNum())){
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);//下架类型0-手动下架，1-售罄下架，2-到期下架
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            // 已调拨数量删除则恢复上架
            if(PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) &&
                    ComputeUtil.isGreaterThan(entity.getSurplusNum(), BigDecimal.ZERO)){
                entity.setStatus(PlanConstant.GOODS_STATUS_ON);
            }
        }
        super.saveOrUpdateBatch(list);
        return BeanMapper.mapList(list, GoodsVO.class);
    }

    @Override
    public Map<Long, BigDecimal> getAllotableNum(List<Long> ids) {
        Map<Long, BigDecimal> resp = new HashMap<>();
        QueryWrapper<GoodsEntity> query = new QueryWrapper<>();
        query.select("id", "surplus_num");
        query.in("id", ids);

        List<Map<String,Object>> rs = super.listMaps(query);
        rs.stream().forEach(item -> {
            resp.put(Long.valueOf(item.get("id").toString()), new BigDecimal(item.get("surplus_num").toString()));
        });

        return resp;
    }

    @Override
    public List<GoodsEntity> getAllByIds(List<Long> ids) {
        QueryWrapper<GoodsEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("id", ids);

        return super.list(query);
    }
}
