package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.FeedbackDetailFileEntity;
import com.ejianc.business.zdsmaterial.erp.service.IFeedbackDetailFileService;
import com.ejianc.business.zdsmaterial.erp.vo.FeedbackDetailFileVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;

/**
 * 供方意见反馈-文件子表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("feedbackDetailFile")
public class FeedbackDetailFileController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFeedbackDetailFileService service;

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refFeedbackDetailFileData", method = RequestMethod.GET)
    public CommonResponse<IPage<FeedbackDetailFileVO>> refFeedbackDetailFileData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FeedbackDetailFileEntity> page = service.queryPage(param,false);
        IPage<FeedbackDetailFileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FeedbackDetailFileVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
