package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.BusinessContractEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.BusinessContractMapper;
import com.ejianc.business.zdsmaterial.erp.service.IBusinessContractService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 商务合同实体
 * 
 * @author generator
 * 
 */
@Service("businessContractService")
public class BusinessContractServiceImpl extends BaseServiceImpl<BusinessContractMapper, BusinessContractEntity> implements IBusinessContractService{
    @Autowired
    private BusinessContractMapper mapper;
    @Override
    public List<BusinessContractEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper<BusinessContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("source_id", sourceIds);
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        List<BusinessContractEntity> list = super.list(queryWrapper);
        return list;
    }

    @Override
    public BusinessContractEntity getBySourceId(String sourceIds) {
        QueryWrapper<BusinessContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_id", sourceIds);
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        List<BusinessContractEntity> list = super.list(queryWrapper);
        BusinessContractEntity businessContractEntity = null;
        if(CollectionUtils.isNotEmpty(list)){
            businessContractEntity = list.get(0);
        }
        return businessContractEntity;
    }

    @Override
    public List<BusinessContractEntity> getAllContractsBySourceId(String contractId) {
        QueryWrapper<BusinessContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        queryWrapper.and(q -> q.eq("source_id", contractId).or().eq("parent_contract_sid", contractId));
        return super.list(queryWrapper);
    }

}
