package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceContentEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialBasePriceContentMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * 基准价格导入子表
 * 
 * @author generator
 * 
 */
@Service("materialBasePriceContentService")
public class MaterialBasePriceContentServiceImpl extends BaseServiceImpl<MaterialBasePriceContentMapper, MaterialBasePriceContentEntity> implements IMaterialBasePriceContentService {

    @Autowired
    private MaterialBasePriceContentMapper materialBasePriceContentMapper;
    @Override
    public List<MaterialBasePriceContentEntity> select(List<Long> ids) {
        return materialBasePriceContentMapper.select(ids);
    }

    @Override
    public List<MaterialBasePriceContentEntity> selectData(QueryParam param, IPage<MaterialBasePriceContentVO> page,List<Long> ids) {
        return materialBasePriceContentMapper.selectData(changeToQueryWrapper(param),page,ids);
    }

    @Override
    public List<MaterialBasePriceContentVO> getLatestPrice(QueryParam param) {
        List<MaterialBasePriceContentVO> resp = new ArrayList<>();
        List<MaterialBasePriceContentEntity> list = materialBasePriceContentMapper.getLatestPrice(changeToQueryWrapper(param));
        if(CollectionUtils.isNotEmpty(list)) {
            return BeanMapper.mapList(list, MaterialBasePriceContentVO.class);
        }
        return resp;
    }
}
