package com.ejianc.business.zdsmaterial.pricelib.processor;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 直取价格导入中的基准价或历史价（合同价）
 *  其中若同时存在基准价和历史价时，优先取基准价
 *
 * @Author: caojie
 * @CreateTime:2025-11-20 11:29
 * @Version: 1.0
 */
@Component
public class CalcByConPriceAndBasePrice implements BaseCalcProcessor {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean calcBeforeCheck(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {

        MaterialCategoryVO categoryVO = priceLibVO.getCategoryVO();
        String categoryName = "";
        if(null != categoryVO) {
            categoryName = categoryVO.getName();
        }

        if(null == priceLibVO.getBaseMaterialPrice() && null == priceLibVO.getContractPrice()) {
            logger.error("【{}】公式：CalcByConPriceAndBasePrice 计算终止，基准价和合同价都为空, {}", categoryName, JSONObject.toJSONString(priceLibVO));
            priceLibVO.setCalcContent("未计算：基准价和合同价都为空");
            return false;
        }

        return true;
    }

    @Override
    public BigDecimal calc(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        priceLibVO.setCalcContent(calcFormula.getCalcDisplayContent());
        if(null != priceLibVO.getContractPrice()) {
            priceLibVO.setAdjustedPrice(priceLibVO.getContractPrice());
            priceLibVO.setAdjustedFirstPrice(priceLibVO.getContractPrice());
        }
        if(null != priceLibVO.getBaseMaterialPrice()) {
            priceLibVO.setAdjustedPrice(priceLibVO.getBaseMaterialPrice());
            priceLibVO.setAdjustedFirstPrice(priceLibVO.getBaseMaterialPrice());
        }
        priceLibVO.setCalcMny(ComputeUtil.safeMultiply(priceLibVO.getAdjustedPrice(), priceLibVO.getSourceNum()));

        return priceLibVO.getAdjustedPrice();
    }

}
