package com.ejianc.business.zdsmaterial.sub.fee.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.controller.SubContractController;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.erp.vo.SubContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyDetailVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包费用申请清单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subFeeApplyDetail")
public class SubFeeApplyDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubFeeApplyDetailService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISubContractService contractService;

    @Autowired
    private ISubContractDetailService contractDetailService;

    @Autowired
    private SubContractController contractController;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubFeeApplyDetailVO> saveOrUpdate(@RequestBody SubFeeApplyDetailVO saveOrUpdateVO) {
    	SubFeeApplyDetailEntity entity = BeanMapper.map(saveOrUpdateVO, SubFeeApplyDetailEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
    	service.saveOrUpdate(entity, false);
    	SubFeeApplyDetailVO vo = BeanMapper.map(entity, SubFeeApplyDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubFeeApplyDetailVO> queryDetail(Long id) {
    	SubFeeApplyDetailEntity entity = service.selectById(id);
    	SubFeeApplyDetailVO vo = BeanMapper.map(entity, SubFeeApplyDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubFeeApplyDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubFeeApplyDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SubFeeApplyDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubFeeApplyDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SubFeeApplyDetailEntity> page = service.queryPage(param,false);
        IPage<SubFeeApplyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubFeeApplyDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubFeeApplyDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubFeeApplyDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSubFeeApplyDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubFeeApplyDetailVO>> refSubFeeApplyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubFeeApplyDetailEntity> page = service.queryPage(param,false);
        IPage<SubFeeApplyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubFeeApplyDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<SubFeeApplyDetailVO> successList = new ArrayList<>();
        List<SubFeeApplyDetailVO> errorList = new ArrayList<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("分类数据超过10000条，请分批上传！");
            }
            SubFeeApplyDetailVO vo = null;
            for(int i = 1;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new SubFeeApplyDetailVO();
                vo.setId(IdWorker.getId());
                vo.setInfoCode(datas.get(0));
                vo.setNum(ComputeUtil.toBigDecimal(datas.get(12)));
                if(StringUtils.isBlank(datas.get(0))){
                    vo.setErrorMsg("清单编码不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(12))){
                    vo.setErrorMsg("本期完工量不能为空！");
                    errorList.add(vo);
                    continue;
                }
                vo.setRowState("add");
                successList.add(vo);
            }
        }
        List<String> infoCodes = successList.stream().map(x->x.getInfoCode()).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(infoCodes)){
            JSONObject condition = new JSONObject();
            condition.put("contractId", request.getParameter("contractId"));
            CommonResponse<IPage<SubContractDetailVO>> resp = contractController.refSubContractDetailData(
                    0, -1, JSONObject.toJSONString(condition), null, null);
            List<SubContractDetailVO> list = resp.getData().getRecords();
            Map<String, SubContractDetailVO> map = list.stream().collect(Collectors.toMap(x->x.getDetailCode(), x->x));
            for(SubFeeApplyDetailVO vo : successList){
                if(!map.containsKey(vo.getInfoCode())){
                    continue;
                }
                SubContractDetailVO detail = map.get(vo.getInfoCode());
                // 合同清单转换为分包费用申请子表清单
                this.transferDetailVO(vo, detail);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 合同清单转换为分包费用申请子表清单
     * @param vo
     * @param detail
     */
    private void transferDetailVO(SubFeeApplyDetailVO vo, SubContractDetailVO detail) {
        vo.setInfoId(detail.getId());
        vo.setContractId(detail.getContractId());
        vo.setSourceInfoId(detail.getSourceDetailId());
        vo.setSourceContractId(detail.getSourceContractId());
        vo.setContractType(String.valueOf(detail.getSourceType() - 1));
        vo.setProjectContent(detail.getProjectContent());
        vo.setPropertyValue(detail.getPropertyValue());
        vo.setUnitId(detail.getDetailUnitId());
        vo.setUnitName(detail.getDetailUnitName());
        vo.setBrandId(String.valueOf(detail.getBrandId()));
        vo.setBrandName(detail.getBrandName());
        vo.setContractNum(detail.getDetailNum());
        vo.setTaxRate(detail.getDetailTaxRate());
        vo.setMaterialPrice(detail.getMaterialPrice());
        vo.setMaterialTaxPrice(detail.getMaterialTaxPrice());
        vo.setHumanPrice(detail.getHumanPrice());
        vo.setHumanTaxPrice(detail.getHumanTaxPrice());
        vo.setComparePrice(detail.getComparePrice());
        vo.setCompareTaxPrice(detail.getCompareTaxPrice());
        vo.setSortId(detail.getSortId());
        vo.setCostCodingId(detail.getCostCodingId());
        vo.setCostCodingName(detail.getCostCodingName());
        vo.setSourceId(detail.getContractId());
        vo.setSourceDetailId(detail.getId());
        vo.setMny(ComputeUtil.safeMultiply(vo.getComparePrice(), vo.getNum()));
        vo.setTaxMny(ComputeUtil.safeMultiply(vo.getCompareTaxPrice(), vo.getNum()));
        vo.setLastNum(detail.getLastNum());
        vo.setLastTaxMny(detail.getLastTaxMny());
        vo.setSumNum(com.ejianc.framework.core.util.ComputeUtil.safeAdd(detail.getLastNum(), vo.getNum()));
        vo.setSumTaxMny(com.ejianc.framework.core.util.ComputeUtil.safeAdd(detail.getLastTaxMny(), vo.getTaxMny()));
    }
}
