package com.ejianc.business.zdsmaterial.sub.subvisa.bean;

import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包签章变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_sub_visa_signature_change")
public class SignatureChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="set_name")
    private String setName; // 指令单名称
    @TableField(value="set_id")
    private Long setId; // 指令单id
    @TableField(value="set_code")
    private String setCode; // 指令单编码
    @TableField(value="report_tax_mny")
    private BigDecimal reportTaxMny; // 报审金额
    @TableField(value="report_mny")
    private BigDecimal reportMny; // 报审金额（无税）
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_sid")
    private String projectSid; // 项目来源id
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="sub_contract_id")
    private Long subContractId; // 合同id
    @TableField(value="sub_contract_name")
    private String subContractName; // 合同名称
    @TableField(value="sub_contract_code")
    private String subContractCode; // 合同编码
    @TableField(value="sub_contract_sid")
    private String subContractSid; // 合同来源id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人主键
    @TableField(value="employee_name")
    private String employeeName; // 经办人-创建人
    @TableField(value="employee_code")
    private String employeeCode; // 经办人编码
    @TableField(value="employee_sid")
    private String employeeSid; // 经办人来源id
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="supplier_sid")
    private String supplierSid; // 供应商来源
    @TableField(value="packet_change_flag")
    private Integer packetChangeFlag; // 有无上包变更 1:是;0:否
    @TableField(value="instruction_set_type_ids")
    private String instructionSetTypeIds; // 指令单类型
    @TableField(value="instruction_set_type_names")
    private String instructionSetTypeNames; // 指令单类型名称
    @TableField(value="receive_status")
    private Integer receiveStatus; // 接受状态： 0:待提交 1：待审核；2：已审核；3：已驳回；4：审核中
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型：  0：来源指令单；1：直接新增
    @TableField(value="additional_recording_flag")
    private Integer additionalRecordingFlag; // 是否补录 1:补录;0:正常
    @TableField(value="memo")
    private String memo; // 指令单说明
    @TableField(value="change_memo")
    private String changeMemo; // 变更说明

    @TableField(value="party_b_contact_id")
    private Long partyBContactId;//乙方联系人
    @TableField(value="party_b_contact_name")
    private String partyBContactName;//乙方联系人
    @TableField(value="party_b_manager_id")
    private Long partyBManagerId; // 乙方项目经理
    @TableField(value="party_b_manager_name")
    private String partyBManagerName; // 乙方项目经理
    @TableField(exist=false)
    @SubEntity(serviceName="signatureChangeDetailService",pidName = "signatureId")
    private List<SignatureChangeDetailEntity> detailList = new ArrayList<>(); // 分包签章变更-事项清单
    @TableField(exist=false)
    @SubEntity(serviceName="signatureChangeSetDetailService",pidName = "signatureId")
    private List<SignatureChangeSetDetailEntity> setDetailList = new ArrayList<>(); // 分包签章变更-指令-事项清单
    @TableField(value="engineer_id")
    private Long engineerId; // 主责工程师
    @TableField(value="engineer_name")
    private String engineerName; // 主责工程师名称
    @TableField(value="mat_worker_id")
    private Long matWorkerId; // 采购工程师
    @TableField(value="mat_worker_name")
    private String matWorkerName; // 采购工程师名称
    @TableField(value="business_worker_id")
    private Long businessWorkerId; // 商务工程师
    @TableField(value="business_worker_name")
    private String businessWorkerName; // 商务工程师名称
    @TableField(value="audit_tax_mny")
    private BigDecimal auditTaxMny;//审核金额
    @TableField(value="end_tax_mny")
    private BigDecimal endTaxMny;//最终金额

    public BigDecimal getAuditTaxMny() {
        return auditTaxMny;
    }

    public void setAuditTaxMny(BigDecimal auditTaxMny) {
        this.auditTaxMny = auditTaxMny;
    }

    public BigDecimal getEndTaxMny() {
        return endTaxMny;
    }

    public void setEndTaxMny(BigDecimal endTaxMny) {
        this.endTaxMny = endTaxMny;
    }

    public Long getBusinessWorkerId() {
        return businessWorkerId;
    }

    public void setBusinessWorkerId(Long businessWorkerId) {
        this.businessWorkerId = businessWorkerId;
    }

    public String getBusinessWorkerName() {
        return businessWorkerName;
    }

    public void setBusinessWorkerName(String businessWorkerName) {
        this.businessWorkerName = businessWorkerName;
    }

    public Long getEngineerId() {
        return engineerId;
    }

    public void setEngineerId(Long engineerId) {
        this.engineerId = engineerId;
    }

    public String getEngineerName() {
        return engineerName;
    }

    public void setEngineerName(String engineerName) {
        this.engineerName = engineerName;
    }

    public Long getMatWorkerId() {
        return matWorkerId;
    }

    public void setMatWorkerId(Long matWorkerId) {
        this.matWorkerId = matWorkerId;
    }

    public String getMatWorkerName() {
        return matWorkerName;
    }

    public void setMatWorkerName(String matWorkerName) {
        this.matWorkerName = matWorkerName;
    }
    public Long getPartyBContactId() {
        return partyBContactId;
    }

    public void setPartyBContactId(Long partyBContactId) {
        this.partyBContactId = partyBContactId;
    }

    public String getPartyBContactName() {
        return partyBContactName;
    }

    public void setPartyBContactName(String partyBContactName) {
        this.partyBContactName = partyBContactName;
    }

    public Long getPartyBManagerId() {
        return partyBManagerId;
    }

    public void setPartyBManagerId(Long partyBManagerId) {
        this.partyBManagerId = partyBManagerId;
    }

    public String getPartyBManagerName() {
        return partyBManagerName;
    }

    public void setPartyBManagerName(String partyBManagerName) {
        this.partyBManagerName = partyBManagerName;
    }

    public String getChangeMemo() {
        return changeMemo;
    }

    public void setChangeMemo(String changeMemo) {
        this.changeMemo = changeMemo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSetName() {
        return setName;
    }

    public void setSetName(String setName) {
        this.setName = setName;
    }
    public Long getSetId() {
        return setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }
    public String getSetCode() {
        return setCode;
    }

    public void setSetCode(String setCode) {
        this.setCode = setCode;
    }
    public BigDecimal getReportTaxMny() {
        return reportTaxMny;
    }

    public void setReportTaxMny(BigDecimal reportTaxMny) {
        this.reportTaxMny = reportTaxMny;
    }
    public BigDecimal getReportMny() {
        return reportMny;
    }

    public void setReportMny(BigDecimal reportMny) {
        this.reportMny = reportMny;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectSid() {
        return projectSid;
    }

    public void setProjectSid(String projectSid) {
        this.projectSid = projectSid;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSubContractId() {
        return subContractId;
    }

    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    public String getSubContractCode() {
        return subContractCode;
    }

    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }
    public String getSubContractSid() {
        return subContractSid;
    }

    public void setSubContractSid(String subContractSid) {
        this.subContractSid = subContractSid;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeeSid() {
        return employeeSid;
    }

    public void setEmployeeSid(String employeeSid) {
        this.employeeSid = employeeSid;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierSid() {
        return supplierSid;
    }

    public void setSupplierSid(String supplierSid) {
        this.supplierSid = supplierSid;
    }
    public Integer getPacketChangeFlag() {
        return packetChangeFlag;
    }

    public void setPacketChangeFlag(Integer packetChangeFlag) {
        this.packetChangeFlag = packetChangeFlag;
    }
    public String getInstructionSetTypeIds() {
        return instructionSetTypeIds;
    }

    public void setInstructionSetTypeIds(String instructionSetTypeIds) {
        this.instructionSetTypeIds = instructionSetTypeIds;
    }
    public String getInstructionSetTypeNames() {
        return instructionSetTypeNames;
    }

    public void setInstructionSetTypeNames(String instructionSetTypeNames) {
        this.instructionSetTypeNames = instructionSetTypeNames;
    }
    public Integer getReceiveStatus() {
        return receiveStatus;
    }

    public void setReceiveStatus(Integer receiveStatus) {
        this.receiveStatus = receiveStatus;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public Integer getAdditionalRecordingFlag() {
        return additionalRecordingFlag;
    }

    public void setAdditionalRecordingFlag(Integer additionalRecordingFlag) {
        this.additionalRecordingFlag = additionalRecordingFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<SignatureChangeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SignatureChangeDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<SignatureChangeSetDetailEntity> getSetDetailList() {
        return setDetailList;
    }

    public void setSetDetailList(List<SignatureChangeSetDetailEntity> setDetailList) {
        this.setDetailList = setDetailList;
    }
}
