package com.ejianc.business.zdsmaterial.sub.subvisa.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.InstructionSetVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeService;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.SignatureChangeVO;

/**
 * 分包签章变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("signatureChange")
public class SignatureChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SIGNCH-CODE";//此处需要根据实际修改

    @Autowired
    private ISignatureChangeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IInstructionSetService instructionSetService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SignatureChangeVO> saveOrUpdate(@RequestBody SignatureChangeVO saveOrUpdateVO) {
    	SignatureChangeEntity entity = BeanMapper.map(saveOrUpdateVO, SignatureChangeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	if (entity.getSetId()!=null){
            QueryWrapper<SignatureChangeEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode()));
            if (entity.getId() != null){
                queryWrapper.ne("id",entity.getId());
            }
            queryWrapper.eq("set_id",entity.getSetId());
            queryWrapper.eq("receive_status",InstructionStatusEnum.待审核.getStatus());
            List<SignatureChangeEntity> list = service.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(list)){
                return CommonResponse.error("单曲指令单,编号：{"+entity.getSetCode()+"}已被引用！");
            }

        }

    	service.saveOrUpdate(entity, false);
    	SignatureChangeVO vo = BeanMapper.map(entity, SignatureChangeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SignatureChangeVO> queryDetail(Long id) {
    	SignatureChangeEntity entity = service.selectById(id);
    	SignatureChangeVO vo = BeanMapper.map(entity, SignatureChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SignatureChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SignatureChangeVO vo : vos) {
                SignatureChangeEntity signatureChangeEntity = service.selectById(vo.getId());
                if (!signatureChangeEntity.getReceiveStatus().equals(InstructionStatusEnum.已驳回.getStatus())){
                    return CommonResponse.error("删除失败,待审核的单据无法删除！");
                }
            }
        }
        service.removeByIds(vos.stream().map(SignatureChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SignatureChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 指令单编号、指令单名称、项目编码、项目名称、合同编号、合同名称、供应商、经办人 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("setName");
        fuzzyFields.add("setCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")){
            if (param.getParams().get("queryCoverage").getValue().equals("1")){
                param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, UserContext.getUserContext().getUserCode()));
            }else {
                /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
                UserContext userContextCache =sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                }else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
                }
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        }else {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<SignatureChangeEntity> page = service.queryPage(param,false);
        IPage<SignatureChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SignatureChangeVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 指令单编号、指令单名称、项目编码、项目名称、合同编号、合同名称、供应商、经办人 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("setName");
        fuzzyFields.add("setCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<SignatureChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<SignatureChangeVO> instructionSetVOS = BeanMapper.mapList(list, SignatureChangeVO.class);
        instructionSetVOS.forEach(i -> {
            if (null==i.getReceiveStatus()){
                i.setReceiveStatusStr(null);
            }else if (i.getReceiveStatus().equals(InstructionStatusEnum.待审核.getStatus())){
                i.setReceiveStatusStr(InstructionStatusEnum.待审核.getStatusName());
            }else if (i.getReceiveStatus().equals(InstructionStatusEnum.已审核.getStatus())){
                i.setReceiveStatusStr(InstructionStatusEnum.已审核.getStatusName());
            }else if (i.getReceiveStatus().equals(InstructionStatusEnum.已驳回.getStatus())){
                i.setReceiveStatusStr(InstructionStatusEnum.已驳回.getStatusName());
            }else if (i.getReceiveStatus().equals(InstructionStatusEnum.审核中.getStatus())){
                i.setReceiveStatusStr(InstructionStatusEnum.审核中.getStatusName());
            }else {
                i.setReceiveStatusStr(null);
            }
            i.setBillStateStr(BillStateEnum.getEnumByStateCode(i.getBillState()).getDescription());

        });
        beans.put("records", instructionSetVOS);
        ExcelExport.getInstance().export("SignatureChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSignatureChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SignatureChangeVO>> refSignatureChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SignatureChangeEntity> page = service.queryPage(param,false);
        IPage<SignatureChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SignatureChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 接口推送接口
     * 接受 推送 确认 驳回
     * @param request
     * @return
     */
    @PostMapping(value = "syncBill")
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        return service.syncBill(request);
    }

    /**
     * @Description pushStatus  作废接口
     */
    @RequestMapping(value = "/pushStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SignatureChangeVO> pushStatus(@RequestBody SignatureChangeVO saveOrUpdateVO) {
        return  service.pushStatus(saveOrUpdateVO);
    }


}
