package com.ejianc.business.zdsmaterial.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * 消息发送工具类
 */
public class SendMsgUtils {
    /** 日志 */
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** 消息类型 msgType:notice */
    private static final String MSG_TYPE_NOTICE = "notice";

    /**
     * 发送系统消息（只发送系统消息，消息类型默认为 notice）
     *
     * @param userList       消息接收用户
     * @param subject        消息标题
     * @param content        消息内容
     * @param pushMessageApi 发送消息API
     */
    public void sendSysMsg(List<String> userList, String subject, String content, IPushMessageApi pushMessageApi) {
        List<String> messageTypeList = new ArrayList<>();
        //系统消息
        messageTypeList.add("sys");
        this.sendMsg(messageTypeList, userList, MSG_TYPE_NOTICE, subject, content, null, null, null, pushMessageApi);
    }

    public void sendSysMsg(List<String> userList, String subject, String content, IPushMessageApi pushMessageApi, String pcUrl, String mobileUrl) {
        List<String> messageTypeList = new ArrayList<>();
        //系统消息
        messageTypeList.add("sys");
        this.sendMsg(messageTypeList, userList, MSG_TYPE_NOTICE, subject, content, null, null, null, pushMessageApi, pcUrl, mobileUrl);
    }

    /**
     * 根据msgType发送消息
     *
     * @param messageTypeList 消息类型
     * @param userList        消息接收用户
     * @param subject         消息标题
     * @param content         消息内容
     * @param pushMessageApi  发送消息API
     */
    public void sendMsgByMsgType(List<String> messageTypeList, List<String> userList, String subject, String content,
                                 IPushMessageApi pushMessageApi) {
        this.sendMsg(messageTypeList, userList, MSG_TYPE_NOTICE, subject, content, null, null, null, pushMessageApi);
    }

    public void sendMsg(List<String> messageTypeList, List<String> userList, String msgType, String subject,
                        String content, String cgddAgentid, String cgddSecret, String wxUrl,
                        IPushMessageApi pushMessageApi, String pcUrl, String mobileUrl) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageTypeList.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageTypeList.contains("dingding")){
            channel.add(PushMsgParameter.CHANNEL_TYPE_DINGDING);
        }
        if (messageTypeList.contains("email")){
            channel.add(PushMsgParameter.CHANNEL_TYPE_EMAIL);
        }
        String[] receivers = userList.toArray(new String[0]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if(StringUtils.isNotBlank(pcUrl)) {
            parameter.setPcUrl(pcUrl);
        }
        if(StringUtils.isNotBlank(mobileUrl)) {
            parameter.setMobileUrl(mobileUrl);
        }

        if (messageTypeList.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", cgddAgentid);
            weixineeParams.put("secret", cgddSecret);
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", "消息提醒");
            weixineeParams.put("description", subject);
            weixineeParams.put("url", wxUrl);
            weixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);
        }
        if (messageTypeList.contains("dingding")) {
            JSONObject dingdingParams = new JSONObject();
            dingdingParams.put("title", subject);
//            String ddcontent = subject + (",通知时间:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            String ddcontent = subject;
            dingdingParams.put("content", ddcontent);
//            dingdingParams.put("maurl", maurl);
//            dingdingParams.put("pcurl", pcurl);
            parameter.setDingdingParams(dingdingParams);
        }
        try {
            logger.info("消息发送参数---------------->{}", JSON.toJSONString(parameter));
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            logger.info("消息发送结果---------------->{}", JSONObject.toJSONString(result));
            if (result.isSuccess()) {
                logger.info("消息发送成功---------------->" + result.getMsg());
            }
            else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    /**
     * 发送消息
     *
     * @param messageTypeList 消息发送类型
     * @param userList        消息接收用户
     * @param msgType         消息类型
     * @param subject         消息标题
     * @param content         消息内容
     * @param cgddAgentid     cgddAgentid（微信消息使用）
     * @param cgddSecret      cgddSecret （微信消息使用）
     * @param url             微信消息URL（微信消息使用）
     * @param pushMessageApi  发送消息API
     */
    public void sendMsg(List<String> messageTypeList, List<String> userList, String msgType, String subject,
                        String content, String cgddAgentid, String cgddSecret, String url,
                        IPushMessageApi pushMessageApi) {
        sendMsg(messageTypeList,userList,msgType,subject,content,cgddAgentid,cgddSecret,url,pushMessageApi, null, null);
    }

}
