/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.mapper.ControlPlanMapper;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="controlPlanService")
public class ControlPlanServiceImpl
extends BaseServiceImpl<ControlPlanMapper, ControlPlanEntity>
implements IControlPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_MATERIAL_CONTROL_PLAN";
    private static final String CHANGE_BILL_CODE = "ZDS_MATERIAL_CONTROL_PLAN_CHANGE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IControlPlanDetailService detailService;
    @Autowired
    private IControlPlanSumService sumService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMaterialConjectureService materialConjectureService;

    @Override
    public ControlPlanVO saveOrUpdate(ControlPlanVO saveOrUpdateVO) {
        ArrayList<Long> materialTypeIds;
        CommonResponse commonResponse;
        if (null == saveOrUpdateVO.getExeOrgId() && (commonResponse = this.orgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess() && null != commonResponse.getData()) {
            Long exeOrgId;
            String[] split = ((OrgVO)commonResponse.getData()).getInnerCode().split("\\|");
            Long l = exeOrgId = split.length > 1 ? Long.valueOf(split[1]) : null;
            if (null != exeOrgId) {
                OrgVO orgVO = (OrgVO)this.orgApi.getOneById(exeOrgId).getData();
                saveOrUpdateVO.setExeOrgId(exeOrgId);
                saveOrUpdateVO.setExeOrgCode(orgVO.getCode());
                saveOrUpdateVO.setExeOrgName(orgVO.getName());
            }
        }
        List detailList = saveOrUpdateVO.getDetailList();
        this.dealParentTypeId(detailList);
        if (PlanConstant.BILL_TYPE_NEW.equals(saveOrUpdateVO.getBillType())) {
            this.validateParentTypeId(saveOrUpdateVO, false);
        } else {
            this.validateChange(saveOrUpdateVO);
        }
        this.validateSame(detailList, saveOrUpdateVO.getProjectId());
        ControlPlanEntity entity = (ControlPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            String ruleCode = BILL_CODE;
            if (PlanConstant.BILL_TYPE_CHANGE.equals(saveOrUpdateVO.getBillType())) {
                ruleCode = CHANGE_BILL_CODE;
            }
            if (!(billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)ruleCode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        }
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        if (entity.getCreateUserId() == null) {
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        entity.getDetailList().stream().filter(item -> null == item.getMaterialId()).forEach(item -> item.setMaterialId(IdWorker.getId()));
        List emptyTypeCodeList = entity.getDetailList().stream().filter(item -> StringUtils.isBlank((CharSequence)item.getMaterialTypeCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(emptyTypeCodeList) && CollectionUtils.isNotEmpty(materialTypeIds = new ArrayList<Long>(emptyTypeCodeList.stream().map(ControlPlanDetailEntity::getMaterialTypeId).collect(Collectors.toSet())))) {
            HashMap<Long, String> categoryCodeMap = new HashMap<Long, String>();
            List<MaterialCategoryVO> materialCategorys = this.materialCategoryService.getAllByIds(materialTypeIds);
            categoryCodeMap.putAll(materialCategorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getCode())));
            emptyTypeCodeList.stream().filter(item -> categoryCodeMap.containsKey(item.getMaterialTypeId())).forEach(item -> item.setMaterialTypeCode((String)categoryCodeMap.get(item.getMaterialTypeId())));
        }
        super.saveOrUpdate((Object)entity, false);
        if (PlanConstant.BILL_TYPE_CHANGE.equals(entity.getBillType())) {
            QueryParam param = new QueryParam();
            param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
            ControlPlanSumEntity sum = (ControlPlanSumEntity)((Object)this.sumService.queryList(param).get(0));
            sum.setChangeStatus(PlanConstant.CHANGE_ING);
            sum.setChangeId(entity.getId());
            sum.setChangeTime(entity.getCreateTime());
            this.sumService.saveOrUpdate((Object)sum);
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getCurIdentifyId())) {
            this.materialConjectureService.fillBillInfo(Collections.singleton(entity.getCurIdentifyId()), entity.getId(), entity.getBillCode(), "EJCBT202311000004");
        }
        return (ControlPlanVO)BeanMapper.map((Object)((Object)entity), ControlPlanVO.class);
    }

    @Override
    public boolean deleteByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return true;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(queryParam);
        List projectIds = list.stream().map(ControlPlanEntity::getProjectId).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("in", projectIds));
        List sumList = this.sumService.queryList(param);
        Map<Long, ControlPlanSumEntity> sumMap = sumList.stream().collect(Collectors.toMap(ControlPlanSumEntity::getProjectId, x -> x));
        param.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_CHANGE));
        param.getParams().put("id", new Parameter("not_in", ids));
        List lastList = super.queryList(param);
        Map<Long, ControlPlanEntity> lastMap = lastList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x, (v1, v2) -> v1.getCreateTime().getTime() > v2.getCreateTime().getTime() ? v1 : v2));
        ArrayList saveList = new ArrayList();
        list.stream().filter(x -> PlanConstant.BILL_TYPE_CHANGE.equals(x.getBillType())).forEach(entity -> {
            ControlPlanSumEntity sum = (ControlPlanSumEntity)((Object)((Object)sumMap.get(entity.getProjectId())));
            ControlPlanEntity last = new ControlPlanEntity();
            if (lastMap.containsKey(entity.getProjectId())) {
                last = (ControlPlanEntity)((Object)((Object)lastMap.get(entity.getProjectId())));
            }
            sum.setChangeStatus(last.getId() != null ? PlanConstant.CHANGE_OVER : PlanConstant.CHANGE_NO);
            sum.setChangeId(last.getId());
            sum.setChangeTime(last.getCreateTime());
            saveList.add(sum);
        });
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.sumService.saveOrUpdateBatch(saveList);
        }
        super.removeByIds(ids, true);
        return true;
    }

    private void validateSame(List<ControlPlanDetailVO> detailList, Long projectId) {
        List checkList = detailList.stream().filter(x -> !"del".equals(x.getRowState())).filter(x -> PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).collect(Collectors.toList());
        Map<String, List<ControlPlanDetailVO>> map = checkList.stream().collect(Collectors.groupingBy(x -> x.getMaterialName() + x.getUnitId() + x.getPropertyValue()));
        List codeList = map.entrySet().stream().filter(x -> ((List)x.getValue()).size() > 1).map(x -> (List)x.getValue()).flatMap(Collection::stream).map(ControlPlanDetailVO::getMaterialCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(codeList)) {
            throw new BusinessException("\u3010" + StringUtils.join(codeList, (String)",") + "\u3011\u7269\u6599\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List dataList = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        List planIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, List<ControlPlanDetailVO>> typeMap = checkList.stream().collect(Collectors.groupingBy(ControlPlanDetailVO::getMaterialTypeId));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"plan_id", planIds);
        List ids = detailList.stream().map(BaseVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        query.notIn(CollectionUtils.isNotEmpty(ids), (Object)"id", ids);
        query.and(q -> {
            for (Long materialTypeId : typeMap.keySet()) {
                q.or(qs -> (QueryWrapper)((QueryWrapper)qs.eq((Object)"material_type_id", (Object)materialTypeId)).and(qss -> {
                    for (ControlPlanDetailVO m : (List)typeMap.get(materialTypeId)) {
                        qss.or(qssi -> (QueryWrapper)((QueryWrapper)((QueryWrapper)qssi.eq((Object)"material_name", (Object)m.getMaterialName())).eq((Object)"property_value", (Object)m.getPropertyValue())).eq((Object)"unit_id", (Object)m.getUnitId()));
                    }
                    return qss;
                }));
            }
            return q;
        });
        List list = this.detailService.list((Wrapper)query);
        Map<String, ControlPlanDetailEntity> matchMap = list.parallelStream().collect(Collectors.toMap(x -> x.getMaterialName() + x.getUnitId() + x.getPropertyValue(), x -> x, (v1, v2) -> v1));
        List codes = detailList.stream().filter(x -> matchMap.containsKey(x.getMaterialName() + x.getUnitId() + x.getPropertyValue())).map(ControlPlanDetailVO::getMaterialCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(codes)) {
            throw new BusinessException("\u3010" + StringUtils.join(codes, (String)",") + "\u3011\u7269\u6599\u5df2\u6dfb\u52a0\u603b\u63a7\u8ba1\u5212\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
        }
    }

    private void validateChange(ControlPlanVO saveOrUpdateVO) {
        List dataList;
        List detailList = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectId()));
        queryParam.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_CHANGE));
        queryParam.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (saveOrUpdateVO.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        }
        if (CollectionUtils.isEmpty((Collection)(dataList = super.queryList(queryParam)))) {
            return;
        }
        List planIds = dataList.stream().map(x -> x.getId()).collect(Collectors.toList());
        List ids = detailList.stream().map(BaseVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"plan_id", planIds);
        query.notIn(CollectionUtils.isNotEmpty(ids), (Object)"id", ids);
        query.and(q -> {
            for (ControlPlanDetailVO m : detailList) {
                q.or(qs -> (QueryWrapper)((QueryWrapper)((QueryWrapper)qs.eq((Object)"material_name", (Object)m.getMaterialName())).eq((Object)"property_value", (Object)m.getPropertyValue())).eq((Object)"unit_id", (Object)m.getUnitId()));
            }
            return q;
        });
        List list = this.detailService.list((Wrapper)query);
        List codeList = list.stream().map(ControlPlanDetailEntity::getMaterialCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(codeList)) {
            throw new BusinessException("\u3010" + StringUtils.join(codeList, (String)",") + "\u3011\u7269\u6599\u5728\u8be5\u9879\u76ee\u4e0b\u5b58\u5728\u672a\u751f\u6548\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
    }

    @Override
    public Map<Long, MaterialCategoryEntity> validateParentTypeId(ControlPlanVO saveOrUpdateVO, Boolean flag) {
        Map<Long, List<ControlPlanDetailVO>> typeMap;
        List<ControlPlanDetailVO> detailList = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        HashMap<Long, MaterialCategoryEntity> parentMap = new HashMap();
        if (flag.booleanValue()) {
            parentMap = this.dealParentTypeId(detailList);
        }
        if (CollectionUtils.isEmpty((typeMap = detailList.stream().filter(x -> PlanConstant.ROW_TYPE_NEW.equals(x.getRowType()) && x.getParentMaterialTypeId() != null).collect(Collectors.groupingBy(x -> x.getParentMaterialTypeId()))).keySet())) {
            this.logger.info("\u5b50\u8868\u4e8c\u7ea7\u5206\u7c7b\u4e3b\u952e\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u6821\u9a8c\uff01");
            return parentMap;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectId()));
        List dataList = super.queryList(queryParam);
        List ids = dataList.stream().map(BaseEntity::getId).filter(x -> !x.equals(saveOrUpdateVO.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            this.logger.info("\u9879\u76ee\u4e0b\u4e0d\u5b58\u5728\u7f16\u5236\u6216\u53d8\u66f4\uff0c\u4e0d\u9700\u8981\u6821\u9a8c\uff01");
            return parentMap;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("parentMaterialTypeId", new Parameter("in", new ArrayList<Long>(typeMap.keySet())));
        param.getParams().put("planId", new Parameter("in", ids));
        List list = this.detailService.queryList(param);
        List typeIds = list.stream().map(ControlPlanDetailEntity::getParentMaterialTypeId).distinct().collect(Collectors.toList());
        List codeList = typeMap.entrySet().stream().filter(x -> typeIds.contains(x.getKey())).map(x -> (List)x.getValue()).flatMap(Collection::stream).map(ControlPlanDetailVO::getMaterialCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(codeList)) {
            throw new BusinessException("\u3010" + StringUtils.join(codeList, (String)",") + "\u3011\u7269\u6599\u6240\u5c5e\u4e8c\u7ea7\u7269\u6599\u5206\u7c7b\u5728\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u8ba1\u5212\u7f16\u5236\u6216\u53d8\u66f4\u65b0\u589e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        this.logger.info("\u6821\u9a8c\u901a\u8fc7!");
        return parentMap;
    }

    @Override
    public Map<Long, MaterialCategoryEntity> getParentMaterialTypeMap(List<Long> materialTypeIds) {
        if (CollectionUtils.isEmpty(materialTypeIds)) {
            return new HashMap<Long, MaterialCategoryEntity>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", materialTypeIds));
        List typeList = this.categoryService.queryList(param);
        Map<Long, Long> typeMap = typeList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getInnerCode().indexOf("|") > 0 ? Long.valueOf(StringUtils.split((String)x.getInnerCode(), (String)"|")[1]) : Long.valueOf(x.getInnerCode())));
        List parentIds = typeMap.values().stream().distinct().collect(Collectors.toList());
        param.getParams().put("id", new Parameter("in", parentIds));
        List parentList = this.categoryService.queryList(param);
        Map<Long, MaterialCategoryEntity> parentMap = parentList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        HashMap<Long, MaterialCategoryEntity> result = new HashMap<Long, MaterialCategoryEntity>();
        for (Long materialTypeId : typeMap.keySet()) {
            MaterialCategoryEntity parent = new MaterialCategoryEntity();
            if (parentMap.containsKey(typeMap.get(materialTypeId))) {
                parent = parentMap.get(typeMap.get(materialTypeId));
            }
            result.put(materialTypeId, parent);
        }
        return result;
    }

    @Override
    public List<ControlPlanEntity> getAllByOrgId(List<Long> orgIds) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"org_id", orgIds);
        return super.list((Wrapper)query);
    }

    private Map<Long, MaterialCategoryEntity> dealParentTypeId(List<ControlPlanDetailVO> detailList) {
        List<Long> typeIds = detailList.stream().filter(item -> !"del".equals(item.getRowState())).map(ControlPlanDetailVO::getMaterialTypeId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(typeIds)) {
            return new HashMap<Long, MaterialCategoryEntity>();
        }
        Map<Long, MaterialCategoryEntity> parentMap = this.getParentMaterialTypeMap(typeIds);
        detailList.forEach(x -> {
            MaterialCategoryEntity parent = new MaterialCategoryEntity();
            if (parentMap.containsKey(x.getMaterialTypeId())) {
                parent = (MaterialCategoryEntity)((Object)((Object)parentMap.get(x.getMaterialTypeId())));
            }
            x.setParentMaterialTypeId(parent.getId());
            x.setParentMaterialTypeCode(parent.getCode());
            x.setParentMaterialTypeName(parent.getName());
        });
        return parentMap;
    }
}

