package com.ejianc.business.zdsmaterial.out.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.out.vo.DisposeDetailVO;
import com.ejianc.business.zdsmaterial.out.vo.DisposeVO;
import com.ejianc.business.zdsmaterial.util.PageUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 处置申请
 *
 * @author generator
 */
@Controller
@RequestMapping("dispose")
public class DisposeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDisposeService service;

    @Autowired
    private IDisposeDetailService detailService;

//    @Autowired
//    private ICheckApi checkApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DisposeVO> saveOrUpdate(@RequestBody DisposeVO saveOrUpdateVO) {
        DisposeVO vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DisposeVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DisposeVO> vos) {
        List<Long> ids = vos.stream().map(DisposeVO::getId).collect(Collectors.toList());
        service.del(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("secOrgName");
        fuzzyFields.add("materialTypeNames");
        fuzzyFields.add("projectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<DisposeEntity> page = service.queryPage(param, false);
        IPage<DisposeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DisposeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("secOrgName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if (!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        List<DisposeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<DisposeVO> voList = BeanMapper.mapList(list, DisposeVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setDisposeTypeName(PlanConstant.DISPOSE_TYPE.get(e.getDisposeType()));
            e.setRecMnyFlagStr(PlanConstant.STRING_YES.equals(e.getRecMnyFlag()) ? "已收款" : "未收款");
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("Dispose-export.xlsx", beans, response);
    }

    /**
     * @param orgId
     * @Description queryParentOrg 查询上级组织
     */
    @RequestMapping(value = "/queryParentOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgVO> queryParentOrg(Long orgId) {
        CommonResponse<OrgVO> orgVO = iOrgApi.detailById(iOrgApi.detailById(orgId).getData().getParentId());
        return CommonResponse.success(orgVO.getData());
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDisposeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DisposeDetailVO>> refDisposeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<DisposeDetailVO> list = detailService.getMaterialDetail(wrapper);
        List<Long> materialListId = list.stream().map(DisposeDetailVO::getId).collect(Collectors.toList());
        List<DisposeDetailVO> refList = new ArrayList<>();
        if (!materialListId.isEmpty()) {
            String ids = StringUtils.join(materialListId, ",");
//            List<InviteDetailVO> dList = inviteMapper.getByMaterialId(ids, wrapper);
//            Map<Long, InviteDetailVO> maps = dList.stream().collect(Collectors.toMap(InviteDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
            for (DisposeDetailVO detailVO : list) {
//                if (!maps.containsKey(detailVO.getMaterialId())) {
//                    detailVO.setSurplusNum(detailVO.getSumNum());//剩余可处置数量
//                    refList.add(detailVO);
//                    continue;
//                }
//                detailVO.setSurplusNum(ComputeUtil.safeSub(detailVO.getSumNum(), maps.get(detailVO.getMaterialId()).getTenderNum()));
                if (detailVO.getSurplusNum().compareTo(BigDecimal.ZERO) > 0) {
                    refList.add(detailVO);
                }
            }
        }
        IPage<DisposeDetailVO> pageData = new Page<>();
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        pageData.setTotal(refList.size());
        refList = PageUtil.listToPage(refList, pageNumber, pageSize);
        pageData.setRecords(refList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 在场材料参照
     * @Return void
     */
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DisposeDetailVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
//        CommonResponse<List<MaterialInRefVO>> checkData =  checkApi.queryInMaterial(projectId);
//        if (!checkData.isSuccess()){
//            throw new BusinessException(checkData.getMsg());
//        }
//        List<MaterialInRefVO> checkList = checkData.getData();//累计进场
//        List<Long> materialListId = checkList.stream().map(MaterialInRefVO::getMaterialId).collect(Collectors.toList());
//        if (StringUtils.isNotBlank(searchText)){
//            checkList = checkList.stream()
//                    .filter(p -> p.getMaterialName().contains(searchText)
//                            || p.getMaterialCode().contains(searchText) )
//                    .collect(Collectors.toList());
//        }
//        List<DisposeDetailVO> checkVos = BeanMapper.mapList(checkList,DisposeDetailVO.class);
//        Map<Long,DisposeDetailVO> checkMap = checkVos.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        List<DisposeDetailVO> list = new ArrayList<>();
//        if (!materialListId.isEmpty()) {
//            QueryWrapper wrapper = changeToQueryWrapper(param);
//            String ids = StringUtils.join(materialListId, ",");
//            list = detailService.getDisposeDetail(ids, wrapper);//查询处置申请
//        }
        Map<Long, DisposeDetailVO> maps = list.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
        List<DisposeDetailVO> refList = new ArrayList<>();
        DisposeDetailVO ref;
//        for (MaterialInRefVO detailVO : checkList) {
//            ref = checkMap.get(detailVO.getMaterialId());
//            ref.setId(detailVO.getMaterialId());
//            ref.setSumNum(detailVO.getRentNum());
//            ref.setUnitName(detailVO.getUnit());
//            if (!maps.containsKey(detailVO.getMaterialId())) {
//                ref.setSurplusNum(detailVO.getRentNum());//剩余可申请数量
//                ref.setSumLossRate(BigDecimal.ZERO);
//                ref.setSumLossNum(BigDecimal.ZERO);
//                refList.add(ref);
//                continue;
//            }
//            ref.setSurplusNum(ComputeUtil.safeSub(detailVO.getRentNum(), maps.get(detailVO.getMaterialId()).getSumNum()));//剩余可申请数量
//            ref.setSumLossRate(maps.get(detailVO.getMaterialId()).getSumLossRate());//总损耗率
//            ref.setSumLossNum(maps.get(detailVO.getMaterialId()).getSumNum());
//            if (ref.getSurplusNum().compareTo(BigDecimal.ZERO) > 0) {
//                refList.add(ref);
//            }
//        }
        IPage<DisposeDetailVO> pageData = new Page<>();
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        pageData.setTotal(refList.size());
        refList = PageUtil.listToPage(refList, pageNumber, pageSize);
        pageData.setRecords(refList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param vo
     * @Description queryCheckNum 查询在场材料
     */
    @RequestMapping(value = "/queryCheckNum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long, DisposeDetailVO>> queryCheckNum(@RequestBody DisposeDetailVO vo) {
        //累计进场
        Map<Long, DisposeDetailVO> maps = new HashMap<>();
//        CommonResponse<List<MaterialInRefVO>> checkData =  checkApi.queryInMaterial(vo.getId());
//        if (!checkData.isSuccess()){
//            throw new BusinessException(checkData.getMsg());
//        }
//        List<MaterialInRefVO> checkList = checkData.getData();
//        List<DisposeDetailVO> checkVos = BeanMapper.mapList(checkList,DisposeDetailVO.class);
//        Map<Long, DisposeDetailVO> checkMap = checkVos.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
//        DisposeDetailVO dvo;
//        for (MaterialInRefVO refVO : checkList) {
//            dvo = checkMap.get(refVO.getMaterialId());
//            dvo.setId(refVO.getMaterialId());
//            dvo.setSumNum(refVO.getRentNum());
//            dvo.setUnitName(refVO.getUnit());
//        }
        String ids = StringUtils.join(vo.getIds(), ",");
//        if (checkList.isEmpty()) {
//            return CommonResponse.success(maps);
//        }
        List<DisposeDetailVO> list = detailService.getDisposeDetails(ids,vo.getId());//查询处置申请
        Map<Long, DisposeDetailVO> map = list.stream().collect(Collectors.toMap(DisposeDetailVO::getMaterialId, Function.identity(), (k1, k2) -> k2));
//        for (Long id : vo.getIds()) {
//            if (!checkMap.containsKey(id)) {
//               maps.put(id, map.get(id));
//               continue;
//            }
//            dvo = checkMap.get(id);
//            if (map.containsKey(id)) {
//                dvo.setSurplusNum(ComputeUtil.safeSub(dvo.getSumNum(), map.get(id).getSumLossNum()));//剩余可申请数量
//                dvo.setSumLossRate(map.get(id).getSumLossRate());//总损耗率
//                dvo.setSumLossNum(map.get(id).getSumLossNum());
//            }else {
//                dvo.setSurplusNum(dvo.getSumNum());//剩余可申请数量
//                dvo.setSumLossRate(BigDecimal.ZERO);//总损耗率
//                dvo.setSumLossNum(BigDecimal.ZERO);
//            }
//            maps.put(id, dvo);
//        }
        return CommonResponse.success(maps);
    }
}
