package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceSubConditionDetailEntity;
import com.ejianc.business.zdsmaterial.pricelib.mapper.MaterialPriceSubConditionDetailMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceSubConditionDetailService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: caojie
 * @CreateTime:2025-07-02 16:58
 * @Version: 1.0
 */
@Service(value = "materialPriceSubConditionDetailService")
public class MaterialPriceSubConditionDetailImpl extends BaseServiceImpl<MaterialPriceSubConditionDetailMapper, MaterialPriceSubConditionDetailEntity> implements IMaterialPriceSubConditionDetailService {
    @Override
    public Map<Long, List<MaterialPriceSubConditionDetailVO>> getAllByConditionIds(List<Long> pids) {

        QueryWrapper<MaterialPriceSubConditionDetailEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("pid", pids);

        List<MaterialPriceSubConditionDetailEntity> list = super.list(query);

        if(CollectionUtils.isNotEmpty(list)) {
            List<MaterialPriceSubConditionDetailVO> vos = BeanMapper.mapList(list, MaterialPriceSubConditionDetailVO.class);
            return vos.stream().collect(Collectors.groupingBy(MaterialPriceSubConditionDetailVO::getPid));
        }

        return new HashMap<>();
    }
}
