/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.engine.impl;

import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

abstract class BasePricingEngine
implements PricingEngine {
    BasePricingEngine() {
    }

    @Override
    public MaterialPriceCalcSubConditionVO findMatchingCondition(PriceLibVO p, List<MaterialPriceCalcSubConditionVO> conditions) {
        if (CollectionUtils.isEmpty(conditions)) {
            p.setCalcContent("\u672a\u8ba1\u7b97:\u3010\u8ba1\u7b97\u89c4\u5219\u6761\u4ef6\u3011\u4e3a\u7a7a");
            return null;
        }
        return conditions.stream().filter(c -> CollectionUtils.isNotEmpty((Collection)c.getDetailList()) && this.matches(p, c.getDetailList())).max(Comparator.comparingInt(MaterialPriceCalcSubConditionVO::getSequence)).orElse(null);
    }

    @Override
    public boolean matches(PriceLibVO p, List<MaterialPriceSubConditionDetailVO> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return false;
        }
        IMaterialCategoryPropertySubItemService itemService = null;
        IMaterialCategoryPropertyService propertyService = null;
        HashMap<Long, MaterialCategoryPropertySubItemVO> itemMap = new HashMap<Long, MaterialCategoryPropertySubItemVO>();
        HashMap<Long, MaterialCategoryPropertyVO> propertyMap = new HashMap<Long, MaterialCategoryPropertyVO>();
        Set eleTypes = detailList.stream().map(MaterialPriceSubConditionDetailVO::getElemType).collect(Collectors.toSet());
        if (eleTypes.contains("propertyItemDoc")) {
            itemService = (IMaterialCategoryPropertySubItemService)ContextUtil.getBean((String)"materialCategoryPropertySubItemService", IMaterialCategoryPropertySubItemService.class);
            propertyService = (IMaterialCategoryPropertyService)ContextUtil.getBean((String)"materialCategoryPropertyService", IMaterialCategoryPropertyService.class);
            List<MaterialCategoryPropertySubItemVO> itemVOS = itemService.getAllByCategoryId(p.getMaterialTypeId());
            itemMap.putAll(itemVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            List<MaterialCategoryPropertyVO> propertyVOS = propertyService.getAllByCategoryId(p.getMaterialTypeId(), 1);
            propertyMap.putAll(propertyVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        return detailList.stream().allMatch(c -> {
            boolean matchFlag = false;
            switch (c.getElemType()) {
                case "brandDoc": {
                    switch (c.getCondType()) {
                        case "0": {
                            matchFlag = StringUtils.equals((CharSequence)p.getBrand(), (CharSequence)c.getElemName());
                            break;
                        }
                        case "1": 
                        case "2": 
                        case "5": {
                            matchFlag = !StringUtils.equals((CharSequence)p.getBrand(), (CharSequence)c.getElemName());
                            break;
                        }
                        case "3": 
                        case "4": 
                        case "6": {
                            matchFlag = p.getBrand().indexOf(c.getElemName()) >= 0;
                        }
                    }
                    break;
                }
                case "categoryDoc": {
                    switch (c.getCondType()) {
                        case "0": {
                            matchFlag = null != p.getMaterialTypeId() && StringUtils.isNotBlank((CharSequence)c.getElemDocId()) && StringUtils.equals((CharSequence)p.getMaterialTypeId().toString(), (CharSequence)c.getElemDocId());
                            break;
                        }
                        case "1": 
                        case "2": 
                        case "3": 
                        case "4": 
                        case "5": 
                        case "6": {
                            matchFlag = null == p.getMaterialTypeId() || !StringUtils.isNotBlank((CharSequence)c.getElemDocId()) || !StringUtils.equals((CharSequence)p.getMaterialTypeId().toString(), (CharSequence)c.getElemDocId());
                        }
                    }
                    break;
                }
                case "propertyDoc": {
                    break;
                }
                case "propertyItemDoc": {
                    MaterialCategoryPropertySubItemVO tmpItem = (MaterialCategoryPropertySubItemVO)itemMap.get(Long.valueOf(c.getElemDocId()));
                    if (null == tmpItem) {
                        return false;
                    }
                    MaterialCategoryPropertyVO tmpProperty = (MaterialCategoryPropertyVO)propertyMap.get(tmpItem.getPropertyId());
                    String materialSpec = p.getSpec();
                    String materialItemName = null;
                    for (String propertyItemStr : materialSpec.split("\uff1b")) {
                        if (!tmpProperty.getName().equals(propertyItemStr.split("\uff1a")[0])) continue;
                        materialItemName = propertyItemStr.split("\uff1a")[1];
                        break;
                    }
                    switch (c.getCondType()) {
                        case "0": {
                            matchFlag = StringUtils.equals(materialItemName, (CharSequence)c.getElemName());
                            break;
                        }
                        case "1": 
                        case "2": 
                        case "5": {
                            matchFlag = !StringUtils.equals(materialItemName, (CharSequence)c.getElemName());
                            break;
                        }
                        case "3": 
                        case "4": 
                        case "6": {
                            matchFlag = StringUtils.isNotBlank(materialItemName) && materialItemName.indexOf(c.getElemName()) >= 0;
                        }
                    }
                    break;
                }
                case "material": {
                    switch (c.getCondType()) {
                        case "0": {
                            matchFlag = StringUtils.equals((CharSequence)p.getBaseMaterialName(), (CharSequence)c.getElemName());
                            break;
                        }
                        case "1": 
                        case "2": 
                        case "5": {
                            matchFlag = !StringUtils.equals((CharSequence)p.getBaseMaterialName(), (CharSequence)c.getElemName());
                            break;
                        }
                        case "3": 
                        case "4": 
                        case "6": {
                            matchFlag = StringUtils.isNotBlank((CharSequence)p.getBaseMaterialName()) && p.getBaseMaterialName().indexOf(c.getElemName()) >= 0;
                        }
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return matchFlag;
        });
    }
}

