package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ContractManagerEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ContractManagerMapper;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractManagerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 合同负责人实体
 * 
 * @author generator
 * 
 */
@Service("contractManagerService")
public class ContractManagerServiceImpl extends BaseServiceImpl<ContractManagerMapper, ContractManagerEntity> implements IContractManagerService{

    @Override
    public Long getContractOperator(Long contractId, String contractType) {
        QueryWrapper<ContractManagerEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        if(StringUtil.isNotBlank(contractType)) {
            query.eq("contract_type", contractType);
        }

        ContractManagerEntity dbEntity = super.getOne(query);
        if(null != dbEntity) {
            return dbEntity.getOperatorId();
        }
        return null;
    }

    @Override
    public Map<Long, ContractManagerVO> getByContractIds(Set<Long> contractIds, String contractType) {
        Map<Long, ContractManagerVO> resp = new HashMap<>();
        QueryWrapper<ContractManagerEntity> query = new QueryWrapper<>();
        query.in("contract_id", contractIds);
        if(StringUtil.isNotBlank(contractType)) {
            query.eq("contract_type", contractType);
        }

        List<ContractManagerEntity> dbEntityList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbEntityList)) {
            List<ContractManagerVO> vos = BeanMapper.mapList(dbEntityList, ContractManagerVO.class);
            resp.putAll(vos.stream().collect(Collectors.toMap(ContractManagerVO::getContractId, item -> item)));
        }

        return resp;
    }
}
