package com.ejianc.business.zdsmaterial.material.service;

import com.ejianc.business.zdsmaterial.material.bean.MaterialPropertyRelationEntity;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialRelationAiVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 材料属性关系
 * 
 * @author generator
 * 
 */
public interface IMaterialPropertyRelationService extends IBaseService<MaterialPropertyRelationEntity> {

    /**
     * 根据物资Id删除对应的所有关系数据
     *
     * @param materialIds
     */
    void deleteByMaterialIds(List<Long> materialIds);

    /**
     * 查询物资明细对应的 属性关系列表
     *
     * @param ids
     * @return
     */
    List<MaterialPropertyRelationVO> getAllByMaterialIds(List<Long> ids);

    List<Long> matchedMaterialIdsByPropertyVal(Map<String, Object> propertyFilterParam);

    /**
     * 根据属性查找所有的关系列表
     *
     * @param propertyIds
     * @return
     */
    List<MaterialPropertyRelationVO> getAllByPropertyIds(List<Long> propertyIds);

    /**
     * 根据属性Id查询所有的关系列表
     *
     * @param propertyValueIds
     * @return
     */
    List<MaterialPropertyRelationVO> getAllByPropertyValueIds(List<Long> propertyValueIds);

    String checkMaterialPropertyValue(Long id);

    List<MaterialPropertyRelationVO> getAllByCategoryId(Long categoryId);

    /**
     * 判断指定范围内的物资有哪些含有新增的属性值
     *
     * @param materialids
     * @return
     */
    List<Long> validMaterialHasNewPropertyItem(List<Long> materialids);
    List<Long> validMaterialHasNewPropertyItem(List<Long> materialids, List<Long> categoryIds);

    List<MaterialRelationAiVO> getAiRelationsByMaterialIds(List<Long> materialIds);
}
