package com.ejianc.business.zdsmaterial.material.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyFileDetailEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatFeeApplyFileDetailMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyFileDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资费用申请-附件
 * 
 * @author generator
 * 
 */
@Service("matFeeApplyFileDetailService")
public class MatFeeApplyFileDetailServiceImpl extends BaseServiceImpl<MatFeeApplyFileDetailMapper, MatFeeApplyFileDetailEntity> implements IMatFeeApplyFileDetailService {

    @Override
    public Map<Long, List<MatFeeApplyFileDetailEntity>> getAllBySettleIds(List<Long> pIds) {
        Map<Long, List<MatFeeApplyFileDetailEntity>> resp = new HashMap<>();

        QueryWrapper<MatFeeApplyFileDetailEntity> query = new QueryWrapper<>();
        query.in("apply_id", pIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MatFeeApplyFileDetailEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = dbList.stream().collect(Collectors.groupingBy(MatFeeApplyFileDetailEntity::getApplyId));
        }

        return resp;
    }
}
