package com.ejianc.business.zdsmaterial.out.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.zdsmaterial.out.bean.DisposeDetailEntity;
import com.ejianc.business.zdsmaterial.out.vo.DisposeDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 处置申请明细表
 * 
 * @author generator
 * 
 */
@Mapper
public interface DisposeDetailMapper extends BaseCrudMapper<DisposeDetailEntity> {
    @Select("select * from (SELECT SUM(d.num) as sumNum,p.project_id,p.tenant_id,\n" +
            "\t\t\t\t\t d.dispose_id,\n" +
            "\t\t\t\t\t d.material_id as id,\n" +
            "\t\t\t\t\t d.material_id,\n" +
            "\t\t\t\t\t d.material_source_id,\n" +
            "\t\t\t\t\t d.material_name,\n" +
            "\t\t\t\t\t d.material_type_id,\n" +
            "\t\t\t\t\t d.material_type_name,\n" +
            "\t\t\t\t\t d.material_code,\n" +
            "\t\t\t\t\t d.unit_id,\n" +
            "\t\t\t\t\t d.unit_name,\n" +
            "\t\t\t\t\t d.spec\n" +
            "\t\t\t  from ejc_zdsmaterial.out_dispose_detail d\n" +
            "\t\t\t\t\t   LEFT JOIN ejc_material_dispose p on p.id = d.dispose_id\n" +
            "\t\t\t  WHERE p.dr = 0\n" +
            "\t\t\t\tand d.dr = 0\n" +
            "\t\t\t\tand p.bill_state in (1, 3)\n" +
            "\t\t\t  GROUP BY d.material_id, p.project_id\n" +
            "\t\t\t  order by d.create_time desc) a\n" +
            "\t\t\t${ew.customSqlSegment}")
    List<DisposeDetailVO> getMaterialDetail(@Param(Constants.WRAPPER) QueryWrapper queryWrapper);
    @Select("select *\n" +
            "\t\tfrom (SELECT SUM(d.num)    as sumNum,\n" +
            "\t\t SUM(d.loss_rate) as sumLossRate,\n" +
            "\t\t\t\t\t p.project_id,\n" +
            "\t\t\t\t\t d.dispose_id,\n" +
            "\t\t\t\t\t p.tenant_id,\n" +
            "\t\t\t\t\t d.material_id as id,\n" +
            "\t\t\t\t\t d.material_id,\n" +
            "\t\t\t\t\t d.material_source_id,\n" +
            "\t\t\t\t\t d.material_name,\n" +
            "\t\t\t\t\t d.material_type_id,\n" +
            "\t\t\t\t\t d.material_type_name,\n" +
            "\t\t\t\t\t d.material_code,\n" +
            "\t\t\t\t\t d.unit_id,\n" +
            "\t\t\t\t\t d.unit_name,\n" +
            "\t\t\t\t\t d.spec\n" +
            "\t\t\t  from ejc_material_dispose_detail d\n" +
            "\t\t\t\t\t   LEFT JOIN ejc_material_dispose p on p.id = d.dispose_id\n" +
            "\t\t\t  WHERE p.dr = 0\n" +
            "\t\t\t\tand d.dr = 0 and d.material_id in (${ids})\n" +
            "\t\t\t  GROUP BY d.material_id, p.project_id\n" +
            "\t\t\t  order by d.create_time desc) a\n" +
            "\t\t\t${ew.customSqlSegment}")
    List<DisposeDetailVO> getDisposeDetail(@Param("ids") String ids, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    @Select("select *\n" +
            "\t\tfrom (SELECT SUM(d.num)    as sumLossNum,\n" +
            "\t\t SUM(d.loss_rate) as sumLossRate,\n" +
            "\t\t\t\t\t p.project_id,\n" +
            "\t\t\t\t\t d.dispose_id,\n" +
            "\t\t\t\t\t p.tenant_id,\n" +
            "\t\t\t\t\t d.material_id as id,\n" +
            "\t\t\t\t\t d.material_id,\n" +
            "\t\t\t\t\t d.material_source_id,\n" +
            "\t\t\t\t\t d.material_name,\n" +
            "\t\t\t\t\t d.material_type_id,\n" +
            "\t\t\t\t\t d.material_type_name,\n" +
            "\t\t\t\t\t d.material_code,\n" +
            "\t\t\t\t\t d.unit_id,\n" +
            "\t\t\t\t\t d.unit_name,\n" +
            "\t\t\t\t\t d.spec\n" +
            "\t\t\t  from ejc_material_dispose_detail d\n" +
            "\t\t\t\t\t   LEFT JOIN ejc_material_dispose p on p.id = d.dispose_id\n" +
            "\t\t\t  WHERE p.dr = 0\n" +
            "\t\t\t\tand d.dr = 0 and d.material_id in (${ids})\n" +
            "\t\t\t  GROUP BY d.material_id, p.project_id\n" +
            "\t\t\t  order by d.create_time desc) a where a.project_id = #{id}")
    List<DisposeDetailVO> getDisposeDetails(@Param("ids") String ids, @Param("id") Long id);
}
