package com.ejianc.business.zdsmaterial.pick.service.impl;

import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptDetailService;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreEntity;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreService;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreSubService;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubContractorEntity;
import com.ejianc.business.zdsmaterial.pick.bean.SubsetMaterialEntity;
import com.ejianc.business.zdsmaterial.pick.mapper.SubsetMaterialMapper;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubContractorService;
import com.ejianc.business.zdsmaterial.pick.service.ISubsetMaterialService;
import com.ejianc.business.zdsmaterial.pick.vo.SubsetMaterialVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包领料登记
 * 
 * @author generator
 * 
 */
@Service("subsetMaterialService")
public class SubsetMaterialServiceImpl extends BaseServiceImpl<SubsetMaterialMapper, SubsetMaterialEntity> implements ISubsetMaterialService{

    @Autowired
    private IControlPlanSumDetailService planDetailService;

    @Autowired
    private IOutStoreService outService;

    @Autowired
    private IOutStoreSubService outSubService;

    @Autowired
    private IAcceptService acceptService;

    @Autowired
    private IAcceptDetailService acceptDetailService;

    @Autowired
    private IProSubContractorService contractorService;

    @Autowired
    private IProPickSettingService settingService;

    @Override
    public void setPlanAndOutNum(List<SubsetMaterialVO> vos, Long contractId) {
        if(CollectionUtils.isEmpty(vos)) return;
        List<Long> planDetailIds = vos.stream().map(SubsetMaterialVO::getPlanDetailId).distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> planNumMap = this.getPlanNumMap(planDetailIds);
        List<Long> materialIds = vos.stream().map(SubsetMaterialVO::getMaterialId).distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> outNumMap = this.getOutNumMap(contractId, materialIds);
        for(SubsetMaterialVO vo : vos){
            if(planNumMap.containsKey(vo.getPlanDetailId())){
                vo.setPlanNum(planNumMap.get(vo.getPlanDetailId()));
            }
            if(outNumMap.containsKey(vo.getMaterialId())){
                vo.setOutNum(outNumMap.get(vo.getMaterialId()));
            }
        }
    }

    @Override
    public Map<Long, BigDecimal> getNumMap(Long projectId, Long contractId, List<Long> materialIds) {
        QueryParam queryParam = new QueryParam();
        if(CollectionUtils.isEmpty(materialIds)){
            return new HashMap<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<ProPickSettingEntity> setList = settingService.queryList(param);
        if(CollectionUtils.isEmpty(setList)){
            return new HashMap<>();
        }
        QueryParam cparam = new QueryParam();
        cparam.getParams().put("settingId", new Parameter(QueryParam.EQ, setList.get(0).getId()));
        if(null != contractId) {
            cparam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            List<ProSubContractorEntity> contList = contractorService.queryList(cparam);
            if(CollectionUtils.isEmpty(contList)){
                return new HashMap<>();
            }
            queryParam.getParams().put("contractorId", new Parameter(QueryParam.EQ, contList.get(0).getId()));
        }

        queryParam.getParams().put("materialId", new Parameter(QueryParam.IN, materialIds));
        List<SubsetMaterialEntity> list = super.queryList(queryParam);
        Map<Long, BigDecimal> map = list.stream().collect(Collectors.toMap(x->x.getMaterialId(), x-> null == x.getNum() ? x.getNum() : BigDecimal.ZERO, (v1, v2)->v2));

        // 限额数量 - 已出库数量
        Map<Long, BigDecimal> outNumMap = this.getOutNumMap(contractId, materialIds);
        for(Long key : map.keySet()){
            if(outNumMap.containsKey(key)){
                map.put(key, ComputeUtil.safeSub(map.get(key), outNumMap.get(key)));
            }
        }
        return map;
    }

    /**
     * 根据总控计划汇总明细主键查询总控数量
     * @param ids
     * @return
     */
    private Map<Long, BigDecimal> getPlanNumMap(List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return new HashMap<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<ControlPlanSumDetailEntity> list = planDetailService.queryList(param);
        Map<Long, BigDecimal> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getNum()));
        return map;
    }

    /**
     * 根据合同+物料主键查询直入直出、领料出库已出库数量
     * @param contractId
     * @param materialIds
     * @return
     */
    private Map<Long, BigDecimal> getOutNumMap(Long contractId, List<Long> materialIds) {
        Map<Long, BigDecimal> map = new HashMap<>();
        if(CollectionUtils.isEmpty(materialIds)){
            return map;
        }
        // 汇总领料出库数量
        this.sumOutStoreNumMap(contractId, materialIds, map);
        // 汇总直入直出出库数量
        this.sumCheckNumMap(contractId, materialIds, map);
        return map;
    }

    /**
     * 汇总领料出库数量
     * @param contractId
     * @param materialIds
     * @param map
     */
    private void sumOutStoreNumMap(Long contractId, List<Long> materialIds, Map<Long, BigDecimal> map) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getParams().put("subContractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("confirmState", new Parameter(QueryParam.EQ, 1));
        List<OutStoreEntity> dataList = outService.queryList(queryParam);
        if(CollectionUtils.isEmpty(dataList)) {
            return;
        }
        List<Long> ids = dataList.stream().map(OutStoreEntity::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("outStoreId", new Parameter(QueryParam.IN, ids));
        param.getParams().put("materialId", new Parameter(QueryParam.IN, materialIds));
        List<OutStoreSubEntity> list = outSubService.queryList(param);
        for(OutStoreSubEntity vo : list){
            BigDecimal num = BigDecimal.ZERO;
            if(map.containsKey(vo.getMaterialId())){
                num = map.get(vo.getMaterialId());
            }
            num = ComputeUtil.safeAdd(num, vo.getNum());
            map.put(vo.getMaterialId(), num);
        }
    }

    /**
     * 汇总直入直出出库数量
     * @param contractId
     * @param materialIds
     * @param map
     */
    private void sumCheckNumMap(Long contractId, List<Long> materialIds, Map<Long, BigDecimal> map) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("acceptType", new Parameter(QueryParam.EQ, 1));
        List<AcceptEntity> dataList = acceptService.queryList(queryParam);
        if(CollectionUtils.isEmpty(dataList)) {
            return;
        }
        List<Long> ids = dataList.stream().map(AcceptEntity::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("acceptId", new Parameter(QueryParam.IN, ids));
        param.getParams().put("materialId", new Parameter(QueryParam.IN, materialIds));
        List<AcceptDetailEntity> list = acceptDetailService.queryList(param);
        for(AcceptDetailEntity vo : list){
            BigDecimal num = BigDecimal.ZERO;
            if(map.containsKey(vo.getMaterialId())){
                num = map.get(vo.getMaterialId());
            }
            num = ComputeUtil.safeAdd(num, vo.getDetailNum());
            map.put(vo.getMaterialId(), num);
        }
    }
}
