package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/8/16 14:48
 */
@RestController
@RequestMapping(value = "/api/zdsOrder")
public class OrderApi {

    @Autowired
    private IOrderService service;

    @PostMapping(value = "/syncToSupCenterBySupplierId")
    CommonResponse<List<String>> syncToSupCenterBySupplierId(@RequestBody Long supplierId) {
        List<String> result = new ArrayList<>();
        List<Long> orderIds = service.getCanSyncOrderIdsBySupplierId(supplierId);
        if(CollectionUtils.isNotEmpty(orderIds)) {
            OrderEntity order = null;
            for(Long orderId : orderIds) {
                order = service.selectById(orderId);
                result.add(service.pushToSupBusiness(BeanMapper.map(order, OrderVO.class)));
            }
        }

        return CommonResponse.success(result);
    }

}
