package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.WorkSpecializeEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.WorkSpecializeMapper;
import com.ejianc.business.zdsmaterial.erp.service.IWorkSpecializeService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("workSpecializeService")
public class WorkSpecializeServiceImpl extends BaseServiceImpl<WorkSpecializeMapper, WorkSpecializeEntity> implements IWorkSpecializeService {
    @Override
    public List<WorkSpecializeEntity> getAllBySourceIds(ArrayList<String> sourceIds) {
        QueryWrapper<WorkSpecializeEntity> query = new QueryWrapper<>();
        query.in("bill_code", sourceIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        return super.list(query);
    }
}
