/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.apply.service.impl;

import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.AllotApplyDetailEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.AllotApplyEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IAllotApplyService;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotApply")
public class AllotApplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAllotApplyService service;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IAllotOrderService orderService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        AllotApplyEntity entity = (AllotApplyEntity)((Object)this.service.selectById(billId));
        if (entity.getDetailList().size() > 0 || CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<AllotApplyDetailEntity> detailList = entity.getDetailList();
            List<Long> collect = detailList.stream().map(e -> e.getSourceId()).collect(Collectors.toList());
            Map<Long, BigDecimal> allotableNum = this.goodsService.getAllotableNum(collect);
            for (AllotApplyDetailEntity detail : detailList) {
                if (!allotableNum.containsKey(detail.getSourceId())) continue;
                BigDecimal decimal = allotableNum.get(detail.getSourceId());
                if (!ComputeUtil.isGreaterThan((BigDecimal)detail.getAllotNum(), (BigDecimal)decimal)) continue;
                return CommonResponse.error((String)("\u7269\u8d44\uff1a" + detail.getMaterialName() + "\u8c03\u62e8\u91cf\u5927\u4e8e\u4e0a\u67b6\u6570\u91cf!"));
            }
            UserContext user = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(user.getUserCode());
            entity.setCommitUserId(user.getUserId());
            entity.setCommitUserName(user.getUserName());
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u7269\u8d44\u660e\u7ec6\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AllotApplyEntity entity = (AllotApplyEntity)((Object)this.service.selectById(billId));
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setEffectDate(new Date());
        }
        if (null == entity) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38,\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u8c03\u62e8\u7533\u8bf7");
        }
        this.service.upShopCart(entity);
        List<AllotApplyDetailEntity> detailList = entity.getDetailList();
        List<Long> collect = detailList.stream().map(e -> e.getSourceId()).collect(Collectors.toList());
        Map<Long, BigDecimal> allotableNum = this.goodsService.getAllotableNum(collect);
        for (AllotApplyDetailEntity detail : detailList) {
            if (!allotableNum.containsKey(detail.getSourceId())) continue;
            BigDecimal decimal = allotableNum.get(detail.getSourceId());
            if (!ComputeUtil.isGreaterThan((BigDecimal)detail.getAllotNum(), (BigDecimal)decimal)) continue;
            return CommonResponse.error((String)("\u7269\u8d44\uff1a" + detail.getMaterialName() + "\u8c03\u62e8\u91cf\u5927\u4e8e\u4e0a\u67b6\u6570\u91cf!"));
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            ArrayList<GoodsVO> goodsVOList = new ArrayList<GoodsVO>();
            for (AllotApplyDetailEntity detail : detailList) {
                GoodsVO goodsVO = new GoodsVO();
                goodsVO.setId(detail.getSourceId());
                goodsVO.setAllotNum(detail.getAllotNum());
                goodsVOList.add(goodsVO);
            }
            this.goodsService.updateAllotNum(goodsVOList, true);
        }
        this.service.upShopCart(entity);
        this.orderService.saveNewOrderByApply((AllotApplyVO)BeanMapper.map((Object)((Object)entity), AllotApplyVO.class));
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8c03\u62e8\u7533\u8bf7\u65e0\u6cd5\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

