/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.config;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IOperationLogService;
import com.ejianc.business.zdsmaterial.cloudstore.config.OperationLog;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderOperationRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OperationLogAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="execution(* com.ejianc.business.zdsmaterial.cloudstore..*(..)))")
    public void logPointcut() {
    }

    @Before(value="logPointcut()")
    public void beforeLogger(JoinPoint joinPoint) {
        Method signature = ((MethodSignature)joinPoint.getSignature()).getMethod();
        OperationLog operationLog = signature.getAnnotation(OperationLog.class);
        IOperationLogService operationLogService = null;
        if (operationLog != null) {
            String params = JSONObject.toJSONString((Object)joinPoint.getArgs());
            this.logger.info("--------\u8bf7\u6c42\u524d\u7f6e\u65e5\u5fd7\u8f93\u51fa\u5f00\u59cb--------");
            this.logger.info("\u8bf7\u6c42\u53c2\u6570\u5217\u8868: {}", (Object)params);
            this.logger.info("\u64cd\u4f5c\u4ebaID: {}", (Object)InvocationInfoProxy.getUserid());
            String handlerName = operationLog.handlerName();
            try {
                operationLogService = (IOperationLogService)ContextUtil.getBean((String)handlerName, IOperationLogService.class);
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u5904\u7406\u7c7b\uff1a{}\u5b9e\u4f8b\u5f02\u5e38", (Object)handlerName, (Object)e);
            }
            AllotOrderOperationRecordVO operationRecord = AllotOrderOperationRecordVO.getInstance();
            operationRecord.setOprUserId(InvocationInfoProxy.getUserid());
            operationRecord.setEvent(operationLog.events());
            operationRecord.setOprUserCode(InvocationInfoProxy.getUsercode());
            this.logger.info("\u64cd\u4f5c\u8bb0\u5f55\uff1a\u8bf7\u6c42\u53c2\u6570\uff1a{}, \u4e8b\u4ef6\uff1a{}, \u7528\u6237Id\uff1a{}, handlerName\uff1a{}", new Object[]{params, operationRecord.getEvent(), operationRecord.getOprUserId(), handlerName});
            if (null != operationLogService) {
                operationLogService.handleOperationLog(params, operationRecord);
            }
        }
    }
}

