/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.mapper.GoodsMapper;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsstore.api.IIdleManageApi;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsService")
public class GoodsServiceImpl
extends BaseServiceImpl<GoodsMapper, GoodsEntity>
implements IGoodsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIdleManageApi idleManageApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public Boolean inOutStore(List<GoodsEntity> list) {
        ArrayList<IdleFlowVO> flowVOS = new ArrayList<IdleFlowVO>();
        for (GoodsEntity t : list) {
            IdleFlowVO flowVO = new IdleFlowVO();
            flowVO.setBillCode(t.getMaterialCode());
            flowVO.setBillDate(new Date());
            flowVO.setStoreId(t.getStoreId());
            flowVO.setStoreName(t.getStoreName());
            flowVO.setProjectId(t.getProjectId());
            flowVO.setProjectName(t.getProjectName());
            flowVO.setOrgId(t.getOrgId());
            flowVO.setOrgName(t.getOrgName());
            flowVO.setParentOrgId(t.getParentOrgId());
            flowVO.setParentOrgName(t.getParentOrgName());
            flowVO.setParentOrgCode(t.getParentOrgCode());
            flowVO.setMaterialCategoryId(t.getMaterialTypeId());
            flowVO.setMaterialCategoryName(t.getMaterialTypeName());
            flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialCode(t.getMaterialCode());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getPropertyValue());
            flowVO.setBrandId(t.getBrandId());
            flowVO.setBrandName(t.getBrandName());
            flowVO.setProductCode(t.getProductCode());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnitName());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setNum(t.getNum());
            flowVO.setSourceId(t.getId());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillTypeName("\u95f2\u7f6e\u7269\u8d44");
            flowVO.setSourceBillRemark(t.getMemo());
            flowVOS.add(flowVO);
        }
        this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString(flowVOS));
        CommonResponse response = this.idleManageApi.inOutStore(flowVOS);
        if (!response.isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return true;
    }

    @Override
    public Boolean inOutStoreRollback(List<GoodsEntity> list) {
        for (GoodsEntity t : list) {
            CommonResponse response = this.idleManageApi.inOutStoreRollback(t.getId());
            if (response.isSuccess()) continue;
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return true;
    }

    @Override
    public List<GoodsVO> updateAllotNum(List<GoodsVO> vos, Boolean flag) {
        List ids = vos.stream().map(BaseVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x -> x.getId(), x -> x, (v1, v2) -> v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(param);
        for (GoodsEntity entity : list) {
            BigDecimal num = map.get(entity.getId()).getAllotNum();
            if (flag.booleanValue()) {
                entity.setAllotNum(ComputeUtil.safeAdd((BigDecimal)entity.getAllotNum(), (BigDecimal)num));
            } else {
                entity.setAllotNum(ComputeUtil.safeSub((BigDecimal)entity.getAllotNum(), (BigDecimal)num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)entity.getNum(), (BigDecimal[])new BigDecimal[]{entity.getAllotedNum(), entity.getAllotNum()}));
            if (ComputeUtil.isLessThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) {
                throw new BusinessException("\u5269\u4f59\u53ef\u8c03\u62e8\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0!");
            }
            if (ComputeUtil.isEmpty((BigDecimal)entity.getSurplusNum()).booleanValue()) {
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(this.sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            if (!PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) || !ComputeUtil.isGreaterThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) continue;
            entity.setStatus(PlanConstant.GOODS_STATUS_ON);
        }
        super.saveOrUpdateBatch((Collection)list);
        return BeanMapper.mapList((Iterable)list, GoodsVO.class);
    }

    @Override
    public List<GoodsVO> updateAllotedNum(List<GoodsVO> vos, Boolean flag) {
        List ids = vos.stream().map(BaseVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x -> x.getId(), x -> x, (v1, v2) -> v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List list = super.queryList(param);
        for (GoodsEntity entity : list) {
            BigDecimal num = map.get(entity.getId()).getAllotedNum();
            if (flag.booleanValue()) {
                entity.setAllotedNum(ComputeUtil.safeAdd((BigDecimal)entity.getAllotedNum(), (BigDecimal)num));
            } else {
                entity.setAllotedNum(ComputeUtil.safeSub((BigDecimal)entity.getAllotedNum(), (BigDecimal)num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)entity.getNum(), (BigDecimal[])new BigDecimal[]{entity.getAllotedNum(), entity.getAllotNum()}));
            if (ComputeUtil.isLessThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) {
                throw new BusinessException("\u5269\u4f59\u53ef\u8c03\u62e8\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0!");
            }
            if (ComputeUtil.isEmpty((BigDecimal)entity.getSurplusNum()).booleanValue()) {
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(this.sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            if (!PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) || !ComputeUtil.isGreaterThan((BigDecimal)entity.getSurplusNum(), (BigDecimal)BigDecimal.ZERO)) continue;
            entity.setStatus(PlanConstant.GOODS_STATUS_ON);
        }
        super.saveOrUpdateBatch((Collection)list);
        return BeanMapper.mapList((Iterable)list, GoodsVO.class);
    }

    @Override
    public Map<Long, BigDecimal> getAllotableNum(List<Long> ids) {
        HashMap<Long, BigDecimal> resp = new HashMap<Long, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"id", "surplus_num"});
        query.in((Object)"id", ids);
        List rs = super.listMaps((Wrapper)query);
        rs.stream().forEach(item -> resp.put(Long.valueOf(item.get("id").toString()), new BigDecimal(item.get("surplus_num").toString())));
        return resp;
    }

    @Override
    public List<GoodsEntity> getAllByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"id", ids);
        return super.list((Wrapper)query);
    }
}

