/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.ShelfEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.mapper.ShelfMapper;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IShelfService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.ShelfDetailVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.ShelfVO;
import com.ejianc.business.zdsmaterial.util.OrgUtil;
import com.ejianc.business.zdsstore.api.IStoreApi;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.vo.StoreVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shelfService")
public class ShelfServiceImpl
extends BaseServiceImpl<ShelfMapper, ShelfEntity>
implements IShelfService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_MATERIAL_SHELF";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreApi storeApi;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private ShelfMapper mapper;

    @Override
    public ShelfVO saveOrUpdate(ShelfVO saveOrUpdateVO) {
        CommonResponse resp;
        Map<Long, OrgVO> corpMap;
        this.validateStoreNum(saveOrUpdateVO);
        ShelfEntity entity = (ShelfEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ShelfEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OrgVO corp = (corpMap = this.orgUtil.findListByIds(new ArrayList<Long>(Arrays.asList(entity.getOrgId())))).containsKey(entity.getOrgId()) ? corpMap.get(entity.getOrgId()) : new OrgVO();
        entity.setCorpId(corp.getId());
        entity.setCorpCode(corp.getCode());
        entity.setCorpName(corp.getName());
        if (entity.getCreateUserId() == null) {
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        if (!(resp = this.storeApi.queryCloudStoreByOrg(entity.getOrgId())).isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)resp.getData()))) {
            throw new BusinessException("\u672c\u4e0a\u7ec4\u7ec7\u672a\u5efa\u7acb\u5927\u533a\u4e91\u4ed3\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
        }
        Map<Long, StoreVO> map = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> x.getParentOrgId(), x -> x, (v1, v2) -> v2));
        StoreVO cloud = new StoreVO();
        if (map.containsKey(entity.getCorpId())) {
            cloud = map.get(entity.getCorpId());
        } else if (map.containsKey(entity.getParentOrgId())) {
            cloud = map.get(entity.getParentOrgId());
        } else if (map.containsKey(entity.getOrgId())) {
            cloud = map.get(entity.getOrgId());
        }
        entity.setCloudStoreId(cloud.getId());
        entity.setCloudStoreName(cloud.getName());
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public ShelfVO queryDetail(Long id) {
        ShelfEntity entity = (ShelfEntity)((Object)super.selectById((Serializable)id));
        ShelfVO vo = (ShelfVO)BeanMapper.map((Object)((Object)entity), ShelfVO.class);
        if (BillStateEnum.COMMITED_STATE.equals((Object)entity.getBillState()) || BillStateEnum.PASSED_STATE.equals((Object)entity.getBillState())) {
            return vo;
        }
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List detailList = vo.getDetailList();
        for (ShelfDetailVO detail : detailList) {
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if (!storeMap.containsKey(key)) continue;
            detail.setStoreNum(storeMap.get(key).getSurplusNum());
        }
        return vo;
    }

    @Override
    public Boolean validateStoreNum(ShelfVO vo) {
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List detailList = vo.getDetailList();
        for (ShelfDetailVO detail : detailList) {
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if (!storeMap.containsKey(key)) continue;
            detail.setStoreNum(storeMap.get(key).getSurplusNum());
            if (!ComputeUtil.isLessThan((BigDecimal)detail.getStoreNum(), (BigDecimal)detail.getNum())) continue;
            throw new BusinessException("\u3010" + detail.getMaterialCode() + "\u3011\u4e0a\u67b6\u6570\u91cf\u5c0f\u4e8e\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u4e0a\u67b6");
        }
        return true;
    }

    @Override
    public List<JSONObject> getSubExportList(List<Long> shelfIds, List<Long> orgIds) {
        return this.mapper.getSubExportList(shelfIds, orgIds);
    }

    private Map<String, SurplusVO> getStoreMap(ShelfVO vo) {
        Map<Long, List<ShelfDetailVO>> map = vo.getDetailList().stream().filter(x -> x.getStoreId() != null).collect(Collectors.groupingBy(ShelfDetailVO::getStoreId));
        HashMap<String, SurplusVO> storeMap = new HashMap<String, SurplusVO>();
        if (map.values().stream().flatMap(Collection::stream).count() == 0L) {
            return storeMap;
        }
        for (Long storeId : map.keySet()) {
            ArrayList<SurplusVO> vos = new ArrayList<SurplusVO>();
            for (ShelfDetailVO t : map.get(storeId)) {
                SurplusVO surplusVO = new SurplusVO();
                surplusVO.setStoreId(t.getStoreId());
                surplusVO.setMaterialCategoryId(t.getMaterialTypeId());
                surplusVO.setMaterialId(t.getMaterialId());
                surplusVO.setBrandId(t.getBrandId());
                vos.add(surplusVO);
            }
            this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString(vos));
            CommonResponse response = this.storeFlowApi.getNewSurplusNum(vos);
            if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) continue;
            Map<String, SurplusVO> priceMap = ((List)response.getData()).stream().collect(Collectors.toMap(k -> k.getMaterialId() + "-" + k.getBrandId(), k -> k));
            storeMap.putAll(priceMap);
        }
        return storeMap;
    }
}

