/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractManagerEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractManagerVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"contractManager"})
public class ContractManagerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractManagerService service;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${erp.appId}")
    private String appId;
    @Value(value="${erp.secret}")
    private String secret;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private QueueUtils queueUtils;
    private final String MATERIAL_CONTRACT_MANAGER_ERP_REQ_URL = "/cefoc/yql/getMEContractOwnerList";
    private final String SUB_CONTRACT_MANAGER_ERP_REQ_URL = "/cefoc/yql/getSubContractOwnerList";
    private final String ERP_EMPTY_VALUE = "00000000-0000-0000-0000-000000000000";
    @Autowired
    private IContractService matContractService;
    @Autowired
    private ISubContractService subContractService;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final int BATCH_SIZE = 1000;

    @GetMapping(value={"syncErpMaterialContractManager"})
    public CommonResponse<String> syncErpMaterialContractManager() {
        return this.syncErpContractManager("\u91c7\u8d2d");
    }

    @GetMapping(value={"syncErpSubContractManager"})
    public CommonResponse<String> syncErpSubContractManager() {
        return this.syncErpContractManager("\u5206\u5305");
    }

    private CommonResponse<String> syncErpContractManager(String contractType) {
        this.logger.info("*********************\u4e2d\u7535\u56db-{}\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************", (Object)contractType);
        long startTime = System.nanoTime();
        HashMap param = new HashMap();
        String reqUrl = this.reqHost + ("\u91c7\u8d2d".equals(contractType) ? "/cefoc/yql/getMEContractOwnerList" : "/cefoc/yql/getSubContractOwnerList");
        String reqResp = null;
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
            JSONObject reqJson = null;
            JSONArray pageData = null;
            this.logger.info("\u4e2d\u7535\u56db-{}\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65,\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}", (Object)contractType, (Object)JSONObject.toJSONString(param));
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    this.logger.info("\u4e2d\u7535\u56db{}\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u540c\u6b65, {}\u6761\u6570\u636e", (Object)contractType, (Object)pageData.size());
                    this.handleErpPage(pageData, "\u91c7\u8d2d".equals(contractType) ? "1" : "2");
                } else {
                    this.logger.info("\u4e2d\u7535\u56db{}\u5408\u540c\u8d1f\u8d23\u4eba\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u6761\u6570\u636e\uff01", (Object)contractType, (Object)pageData.size());
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db{}\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f \u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{contractType, reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                this.queueUtils.sendMq("el_sync_erp_data_job_" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1", reqResp, null)));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db{}\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{contractType, reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u5f02\u5e38, ", (Throwable)e);
            this.queueUtils.sendMq("el_sync_erp_data_job_" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1", reqResp, e.getMessage())));
            return CommonResponse.error((String)("\u540c\u6b65\u4e2d\u7535\u56db" + contractType + "\u5408\u540c\u8d1f\u8d23\u4eba\u5f02\u5e38"));
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration);
        this.logger.info("==============\u4e2d\u7535\u56db-{}\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u4efb\u52a1\u8017\u65f6 {} \u79d2", (Object)contractType, (Object)seconds);
        this.logger.info("*********************\u4e2d\u7535\u56db-{}\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************", (Object)contractType);
        this.queueUtils.sendMq("el_sync_erp_data_job_" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1")));
        return CommonResponse.success((String)("\u4e2d\u7535\u56db" + contractType + "\u5408\u540c\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u5b8c\u6210\uff01"));
    }

    private void handleErpPage(JSONArray data, String contractType) {
        JSONObject tmp = null;
        ContractManagerEntity tmpManager = null;
        HashMap<Long, ContractManagerEntity> managerMap = new HashMap<Long, ContractManagerEntity>();
        ArrayList<ContractManagerEntity> processList = new ArrayList<ContractManagerEntity>();
        ArrayList<ContractManagerEntity> saveList = new ArrayList<ContractManagerEntity>();
        ArrayList<ContractManagerEntity> updateList = new ArrayList<ContractManagerEntity>();
        String contractPrefix = "1".equals(contractType) ? "ME" : "Sub";
        HashSet<String> empSourceIds = new HashSet<String>();
        HashSet<String> contractSourceIds = new HashSet<String>();
        List dbManagers = null;
        boolean idx = false;
        for (Object obj : data) {
            CommonResponse empResp;
            BaseEntity tmpContract;
            Map contractMap;
            List<BaseEntity> contracts;
            tmp = (JSONObject)obj;
            if ((StringUtils.isBlank((CharSequence)tmp.getString(contractPrefix + "Contract_Operator_Sid")) || "00000000-0000-0000-0000-000000000000".equals(tmp.getString(contractPrefix + "Contract_Operator_Sid"))) && (StringUtils.isBlank((CharSequence)tmp.getString(contractPrefix + "Contract_Settler_Sid")) || "00000000-0000-0000-0000-000000000000".equals(tmp.getString(contractPrefix + "Contract_Settler_Sid")))) {
                this.logger.info("{}\u5408\u540cSID-{} \u5c65\u7ea6\u4eba\u548c\u7ed3\u7b97\u65e5\u4eba\u90fd\u4e3a\u7a7a\uff0c\u8df3\u8fc7~", (Object)("1".equals(contractType) ? "\u91c7\u8d2d" : "\u5206\u5305"));
                continue;
            }
            tmpManager = new ContractManagerEntity();
            tmpManager.setContractSid(tmp.getString(contractPrefix + "ContractInfo_Sid"));
            tmpManager.setContractName(tmp.getString("Contract_Title"));
            tmpManager.setProjectSid(tmp.getString("Account_Project_Sid"));
            tmpManager.setProjectCode(tmp.getString("Account_Project_id"));
            tmpManager.setProjectName(tmp.getString("Project_Name"));
            tmpManager.setOperatorSid(tmp.getString(contractPrefix + "Contract_Operator_Sid"));
            tmpManager.setOperatorName(tmp.getString(contractPrefix + "Contract_Operator"));
            if (StringUtils.isNotBlank((CharSequence)tmpManager.getOperatorSid()) && !"00000000-0000-0000-0000-000000000000".equals(tmpManager.getOperatorSid())) {
                empSourceIds.add(tmpManager.getOperatorSid());
            }
            tmpManager.setSettlerSid(tmp.getString(contractPrefix + "Contract_Settler_Sid"));
            tmpManager.setSettlerName(tmp.getString(contractPrefix + "Contract_Settler"));
            if (StringUtils.isNotBlank((CharSequence)tmpManager.getSettlerSid()) && !"00000000-0000-0000-0000-000000000000".equals(tmpManager.getSettlerSid())) {
                empSourceIds.add(tmpManager.getSettlerSid());
            }
            tmpManager.setContractType(contractType);
            contractSourceIds.add(tmpManager.getContractSid());
            processList.add(tmpManager);
            if (processList.size() % 1000 != 0) continue;
            if ("1".equals(contractType)) {
                contracts = this.matContractService.getBySourceIds(new ArrayList<String>(contractSourceIds));
                dbManagers = (List)this.service.listByIds(contracts.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                contractMap = contracts.stream().collect(Collectors.toMap(ContractEntity::getSourceContractId, Function.identity()));
                tmpContract = null;
                for (ContractManagerEntity con : processList) {
                    tmpContract = (ContractEntity)((Object)contractMap.get(con.getContractSid()));
                    if (null == tmpContract) continue;
                    con.setContractId(tmpContract.getId());
                    con.setProjectId(tmpContract.getProjectId());
                    con.setId(tmpContract.getId());
                }
            } else {
                contracts = this.subContractService.getAllBySourceIds(new ArrayList<String>(contractSourceIds));
                dbManagers = (List)this.service.listByIds(contracts.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                contractMap = contracts.stream().collect(Collectors.toMap(SubContractEntity::getSourceContractId, Function.identity()));
                tmpContract = null;
                for (ContractManagerEntity con : processList) {
                    tmpContract = (SubContractEntity)((Object)contractMap.get(con.getContractSid()));
                    if (null == tmpContract) continue;
                    con.setContractId(tmpContract.getId());
                    con.setProjectId(tmpContract.getProjectId());
                    con.setId(tmpContract.getId());
                }
            }
            if (!(empResp = this.employeeApi.getAllBySourceIds(new ArrayList(empSourceIds))).isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)empResp.getData()))) {
                this.logger.error("\u5408\u540c\u5c65\u7ea6\u4eba\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636e\u4eba\u5458SID-{}\uff0c\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\u6216\u4e3a\u7a7a, {}", (Object)JSONObject.toJSONString(empSourceIds), (Object)JSONObject.toJSONString((Object)empResp));
                throw new BusinessException("\u5408\u540c\u5c65\u7ea6\u4eba\u540c\u6b65\u5931\u8d25\uff0c\u4eba\u5458\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
            }
            Map<String, EmployeeVO> empMap = ((List)empResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
            managerMap.putAll(dbManagers.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            for (ContractManagerEntity con : processList) {
                tmpManager = (ContractManagerEntity)((Object)managerMap.get(con.getId()));
                if (StringUtils.isNotBlank((CharSequence)con.getOperatorSid()) && empMap.containsKey(con.getOperatorSid())) {
                    con.setOperatorId(empMap.get(con.getOperatorSid()).getId());
                    con.setOperatorCode(empMap.get(con.getOperatorSid()).getCode());
                }
                if (StringUtils.isNotBlank((CharSequence)con.getSettlerSid()) && empMap.containsKey(con.getSettlerSid())) {
                    con.setSettlerId(empMap.get(con.getSettlerSid()).getId());
                    con.setSettlerCode(empMap.get(con.getSettlerSid()).getCode());
                }
                if (null != tmpManager) {
                    tmpManager.setOperatorId(con.getOperatorId());
                    tmpManager.setOperatorCode(con.getOperatorCode());
                    tmpManager.setOperatorName(con.getOperatorName());
                    tmpManager.setOperatorSid(con.getOperatorSid());
                    tmpManager.setSettlerCode(con.getSettlerCode());
                    tmpManager.setSettlerId(con.getSettlerId());
                    tmpManager.setSettlerName(con.getSettlerName());
                    tmpManager.setSettlerSid(con.getSettlerSid());
                    updateList.add(tmpManager);
                    continue;
                }
                if (null == con.getContractId()) continue;
                saveList.add(con);
            }
            this.logger.info("{}\u5408\u540c\u5c65\u7ea6\u4eba\u540c\u6b65,\u672c\u6b21\u66f4\u65b0{}\u6761~", (Object)("1".equals(contractType) ? "\u91c7\u8d2d" : "\u5206\u5305"), (Object)updateList.size());
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.service.saveOrUpdateBatch(updateList, updateList.size(), false);
            }
            this.logger.info("{}\u5408\u540c\u5c65\u7ea6\u4eba\u540c\u6b65\uff0c\u672c\u6b21\u4fdd\u5b58{}\u6761", (Object)("1".equals(contractType) ? "\u91c7\u8d2d" : "\u5206\u5305"), (Object)saveList.size());
            if (CollectionUtils.isNotEmpty(saveList)) {
                this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
            }
            processList.clear();
            contractSourceIds.clear();
            empSourceIds.clear();
            saveList.clear();
            updateList.clear();
        }
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractManagerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractManagerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ContractManager-export.xlsx", beans, response);
    }
}

