/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountDetailEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ExpenseAccountDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountDetailService;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="expenseAccountDetailService")
public class ExpenseAccountDetailServiceImpl
extends BaseServiceImpl<ExpenseAccountDetailMapper, ExpenseAccountDetailEntity>
implements IExpenseAccountDetailService {
    private static final String BILL_TYPE_CODE = "EJCBT202312000001";
    private final String OPERATE = "EXPENSE_ACCOUNT_ACCEPT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;

    @Override
    public List<ExpenseAccountDetailEntity> getAllBySourceDetailIds(List<String> sourceDetailIds) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"source_detail_id", sourceDetailIds);
        return super.list((Wrapper)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String handleAcceptNum(Long expenseAccountId, Map<Long, BigDecimal> nums, boolean addFlag) {
        Object msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "EJCBT202312000001::" + expenseAccountId.toString();
        int retryTime = 0;
        try {
            jedis = this.jedisPool.getResource();
            ArrayList<ExpenseAccountDetailEntity> updateList = new ArrayList<ExpenseAccountDetailEntity>();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"EXPENSE_ACCOUNT_ACCEPT", (int)600);
            while (!locked && retryTime <= 3) {
                this.logger.info("\u62a5\u9500\u5355id:{}\u660e\u7ec6\u5165\u5e93\u91cf\u66f4\u65b0\uff0c\u83b7\u53d6\u9501\u5931\u8d25\uff0c{}s\u540e\u91cd\u8bd5", (Object)expenseAccountId, (Object)(++retryTime * 5));
                TimeUnit.SECONDS.sleep(retryTime * 5);
                locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"EXPENSE_ACCOUNT_ACCEPT", (int)600);
            }
            if (!locked) {
                this.releaseLock(jedis, false, key, "EXPENSE_ACCOUNT_ACCEPT");
                String string = "\u96f6\u661f\u6750\u6599\u56de\u5199\u62a5\u9500\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25\uff01";
                return string;
            }
            ArrayList<Long> detailIds = new ArrayList<Long>(nums.keySet());
            List<ExpenseAccountDetailEntity> dbDetailList = this.getAllByIds(detailIds);
            for (ExpenseAccountDetailEntity dbDetail : dbDetailList) {
                if (!nums.containsKey(dbDetail.getId())) continue;
                if (addFlag) {
                    if (dbDetail.getPurchaseNum().compareTo(ComputeUtil.safeAdd(dbDetail.getAcceptedNum(), nums.get(dbDetail.getId()))) < 0) {
                        String string = "\u64cd\u4f5c\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u3010" + dbDetail.getMaterialCode() + "\u3011\uff0c\u540d\u79f0\u4e3a\u3010" + dbDetail.getMaterialName() + "\u3011\u7684\u6750\u6599\u672c\u6b21\u53ef\u9a8c\u6536\u91cf\u4e3a\u3010" + ComputeUtil.safeSub(dbDetail.getPurchaseNum(), dbDetail.getAcceptedNum()).stripTrailingZeros().toPlainString() + "\u3011\uff0c\u5c0f\u4e8e\u672c\u6b21\u9a8c\u6536\u91cf\u3010" + nums.get(dbDetail.getId()).stripTrailingZeros().toPlainString() + "\u3011";
                        return string;
                    }
                    dbDetail.setAcceptedNum(ComputeUtil.safeAdd(dbDetail.getAcceptedNum(), nums.get(dbDetail.getId())));
                } else {
                    dbDetail.setAcceptedNum(ComputeUtil.safeSub(dbDetail.getAcceptedNum(), nums.get(dbDetail.getId())));
                }
                updateList.add(dbDetail);
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                super.saveOrUpdateBatch(updateList, updateList.size(), false);
            }
            Iterator<ExpenseAccountDetailEntity> iterator = null;
            return iterator;
        }
        catch (Exception e) {
            this.logger.error("\u96f6\u661f\u6750\u6599\u56de\u5199\u62a5\u9500\u5355:{}\u5f02\u5e38\uff0c", (Object)expenseAccountId, (Object)e);
        }
        finally {
            this.releaseLock(jedis, false, key, "EXPENSE_ACCOUNT_ACCEPT");
        }
        return null;
    }

    @Override
    public String validateAcceptNum(Map<Long, BigDecimal> nums) {
        List<ExpenseAccountDetailEntity> dbDetailList = this.getAllByIds(new ArrayList<Long>(nums.keySet()));
        for (ExpenseAccountDetailEntity dbDetail : dbDetailList) {
            if (!nums.containsKey(dbDetail.getId()) || dbDetail.getPurchaseNum().compareTo(ComputeUtil.safeAdd(dbDetail.getAcceptedNum(), nums.get(dbDetail.getId()))) >= 0) continue;
            return "\u7f16\u7801\u4e3a\u3010" + dbDetail.getMaterialCode() + "\u3011\uff0c\u540d\u79f0\u4e3a\u3010" + dbDetail.getMaterialName() + "\u3011\u7684\u6750\u6599\u672c\u6b21\u53ef\u9a8c\u6536\u91cf\u4e3a\u3010" + ComputeUtil.safeSub(dbDetail.getPurchaseNum(), dbDetail.getAcceptedNum()).stripTrailingZeros().toPlainString() + "\u3011\uff0c\u5c0f\u4e8e\u672c\u6b21\u9a8c\u6536\u91cf\u3010" + nums.get(dbDetail.getId()).stripTrailingZeros().toPlainString() + "\u3011";
        }
        return null;
    }

    private List<ExpenseAccountDetailEntity> getAllByIds(List<Long> detailIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", detailIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

