/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.SubContractDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.erp.vo.SubContractDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="subContractDetailService")
public class SubContractDetailServiceImpl
extends BaseServiceImpl<SubContractDetailMapper, SubContractDetailEntity>
implements ISubContractDetailService {
    @Override
    public List<SubContractDetailEntity> getAllBySourceIds(List<String> sourceIds) {
        if (CollectionUtils.isEmpty(sourceIds)) {
            return null;
        }
        QueryWrapper queryDetail = new QueryWrapper();
        queryDetail.in((Object)"source_detail_id", sourceIds);
        queryDetail.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List detailList = super.list((Wrapper)queryDetail);
        return detailList;
    }

    @Override
    public Map<Long, SubContractDetailEntity> getAllByIds(List<Long> contractDetailIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", contractDetailIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            return dbList.stream().collect(Collectors.toMap(item -> item.getId(), Function.identity()));
        }
        return new HashMap<Long, SubContractDetailEntity>();
    }

    @Override
    public void cancelByContractIds(List<Long> delContractIds) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"contract_id", delContractIds);
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        update.set((Object)"dr", (Object)1);
        update.set((Object)"update_time", (Object)new Date());
        super.update((Wrapper)update);
    }

    @Override
    public List<SubContractDetailVO> getByContractId(Long contactId) {
        QueryWrapper queryDetail = new QueryWrapper();
        queryDetail.in((Object)"contract_id", new Object[]{contactId});
        queryDetail.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryDetail.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List detailList = super.list((Wrapper)queryDetail);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return new ArrayList<SubContractDetailVO>();
        }
        return BeanMapper.mapList((Iterable)detailList, SubContractDetailVO.class);
    }

    @Override
    public List<SubContractDetailVO> getBySubContractId(Long contactId) {
        QueryWrapper queryDetail = new QueryWrapper();
        queryDetail.eq((Object)"sub_contract_id", (Object)contactId.toString());
        queryDetail.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryDetail.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        ((QueryWrapper)((QueryWrapper)queryDetail.orderByAsc((Object)"source_type")).orderByAsc((Object)"contract_id")).orderByAsc((Object)"sort_id");
        List detailList = super.list((Wrapper)queryDetail);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return new ArrayList<SubContractDetailVO>();
        }
        return BeanMapper.mapList((Iterable)detailList, SubContractDetailVO.class);
    }

    @Override
    public Map<Long, List<SubContractDetailEntity>> getAllByConIds(List<Long> conIds, List<String> conDetailCodes) {
        QueryWrapper queryDetail = new QueryWrapper();
        queryDetail.in((Object)"sub_contract_id", conIds);
        queryDetail.in((Object)"detail_code", conDetailCodes);
        queryDetail.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryDetail.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List detailList = super.list((Wrapper)queryDetail);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            return detailList.stream().collect(Collectors.groupingBy(SubContractDetailEntity::getContractId));
        }
        return new HashMap<Long, List<SubContractDetailEntity>>();
    }
}

