/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialPropertyRelationService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialAiVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialRelationAiVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ai"})
public class AiMaterialController {
    private final Integer MAX_PAGE_SIZE = 500;
    private final Integer DEFAULT_PAGE_SIZE = 10;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IMaterialCategoryPropertySubItemService itemService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialPropertyRelationService relationService;

    @PostMapping(value={"category/pageList"})
    public CommonResponse<IPage<JSONObject>> pageMaterialCategory(@RequestBody QueryParam queryParam) {
        Page resp = new Page();
        if (queryParam.getPageSize() > this.MAX_PAGE_SIZE) {
            queryParam.setPageSize(this.MAX_PAGE_SIZE.intValue());
        }
        if (queryParam.getPageSize() < 0) {
            queryParam.setPageSize(this.DEFAULT_PAGE_SIZE.intValue());
        }
        queryParam.getOrderMap().put("id", "asc");
        queryParam.getParams().put("propertyFlag", Parameter.getEqInstance((Object)1));
        queryParam.getParams().put("enabled", Parameter.getEqInstance((Object)1));
        IPage pageData = this.categoryService.queryPage(queryParam);
        resp.setPages(pageData.getPages());
        resp.setCurrent(pageData.getCurrent());
        resp.setSize(pageData.getSize());
        resp.setTotal(pageData.getTotal());
        ArrayList<JSONObject> categoryList = new ArrayList<JSONObject>();
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        JSONObject tmpJson = null;
        for (MaterialCategoryEntity category : pageData.getRecords()) {
            tmpJson = new JSONObject();
            tmpJson.put("id", (Object)category.getId());
            tmpJson.put("code", (Object)category.getCode());
            tmpJson.put("name", (Object)category.getName());
            tmpJson.put("sequence", (Object)category.getSequence());
            tmpJson.put("enabled", (Object)category.getEnabled());
            tmpJson.put("updateTime", null != category.getUpdateTime() ? Long.valueOf(category.getUpdateTime().getTime()) : null);
            tmpJson.put("defaultUnitName", (Object)category.getMainUnitName());
            tmpJson.put("defaultUnitId", (Object)category.getMainUnitId());
            categoryIds.add(category.getId());
            categoryList.add(tmpJson);
        }
        Map<Long, List<MaterialCategoryPropertyVO>> propertyMap = this.propertyService.getAllByCategoryIds(categoryIds, 1);
        Map<Long, List<MaterialCategoryPropertySubItemVO>> itemMap = this.itemService.getAllByCategoryIds(categoryIds, 1);
        List<MaterialCategoryPropertyVO> tmpPropertyList = null;
        List<MaterialCategoryPropertySubItemVO> tmpItemList = null;
        JSONArray tmpPropertyArr = null;
        JSONArray tmpItemArr = null;
        JSONObject tmpProperty = null;
        JSONObject tmpItem = null;
        for (JSONObject categoryJson : categoryList) {
            tmpPropertyList = propertyMap.get(categoryJson.getLong("id"));
            tmpPropertyArr = new JSONArray();
            if (CollectionUtils.isNotEmpty(tmpPropertyList)) {
                for (MaterialCategoryPropertyVO property : tmpPropertyList) {
                    tmpProperty = new JSONObject();
                    tmpItemArr = new JSONArray();
                    tmpProperty.put("id", (Object)property.getId());
                    tmpProperty.put("name", (Object)property.getName());
                    tmpProperty.put("sequence", (Object)property.getSequence());
                    tmpProperty.put("enabled", (Object)property.getEnabled());
                    tmpProperty.put("requiredFlag", (Object)property.getRequiredFlag());
                    tmpProperty.put("keyPropertyFlag", (Object)property.getKeyPropertyFlag());
                    tmpItemList = itemMap.get(property.getId());
                    if (CollectionUtils.isNotEmpty(tmpItemList)) {
                        for (MaterialCategoryPropertySubItemVO item : tmpItemList) {
                            if (null == item.getValidFlag() || 1 != item.getValidFlag()) continue;
                            tmpItem = new JSONObject();
                            tmpItem.put("id", (Object)item.getId());
                            tmpItem.put("name", (Object)item.getName());
                            tmpItem.put("sequence", (Object)item.getSequence());
                            tmpItem.put("enabled", (Object)item.getEnabled());
                            tmpItem.put("productCode", (Object)item.getProductCode());
                            tmpItemArr.add((Object)tmpItem);
                        }
                    }
                    tmpProperty.put("itemList", (Object)tmpItemArr);
                    tmpPropertyArr.add((Object)tmpProperty);
                }
            }
            categoryJson.put("propertyList", (Object)tmpPropertyArr);
        }
        resp.setRecords(categoryList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resp);
    }

    @PostMapping(value={"category/jsonList"})
    public CommonResponse<List<JSONObject>> jsonList() {
        QueryParam queryParam = new QueryParam();
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        queryParam.setPageIndex(-1);
        queryParam.setPageIndex(1);
        queryParam.getOrderMap().put("id", "asc");
        queryParam.getParams().put("propertyFlag", Parameter.getEqInstance((Object)1));
        List pageData = this.categoryService.queryList(queryParam);
        ArrayList<JSONObject> categoryList = new ArrayList<JSONObject>();
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        JSONObject tmpJson = null;
        for (MaterialCategoryEntity category : pageData) {
            tmpJson = new JSONObject();
            tmpJson.put("\u5206\u7c7bID", (Object)category.getId());
            tmpJson.put("\u5206\u7c7b\u540d\u79f0", (Object)category.getName());
            tmpJson.put("\u9ed8\u8ba4\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0", (Object)category.getMainUnitName());
            tmpJson.put("\u9ed8\u8ba4\u8ba1\u91cf\u5355\u4f4dID", (Object)category.getMainUnitId());
            categoryIds.add(category.getId());
            categoryList.add(tmpJson);
        }
        Map<Long, List<MaterialCategoryPropertyVO>> propertyMap = this.propertyService.getAllByCategoryIds(categoryIds, 1);
        Map<Long, List<MaterialCategoryPropertySubItemVO>> itemMap = this.itemService.getAllByCategoryIds(categoryIds, 1);
        List<MaterialCategoryPropertyVO> tmpPropertyList = null;
        List<MaterialCategoryPropertySubItemVO> tmpItemList = null;
        JSONArray tmpPropertyArr = null;
        JSONObject tmpCategory = null;
        JSONObject tmpProperty = null;
        Object tmpItem = null;
        for (JSONObject categoryJson : categoryList) {
            tmpPropertyList = propertyMap.get(categoryJson.getLong("\u5206\u7c7bID"));
            tmpPropertyArr = new JSONArray();
            tmpCategory = new JSONObject();
            if (CollectionUtils.isNotEmpty(tmpPropertyList)) {
                for (MaterialCategoryPropertyVO property : tmpPropertyList) {
                    tmpItemList = itemMap.get(property.getId());
                    if (CollectionUtils.isNotEmpty(tmpItemList)) {
                        for (MaterialCategoryPropertySubItemVO item : tmpItemList) {
                            if (null == item.getValidFlag() || 1 != item.getValidFlag()) continue;
                            tmpProperty = new JSONObject();
                            tmpProperty.put("\u5c5e\u6027ID", (Object)property.getId());
                            tmpProperty.put("\u5c5e\u6027\u540d\u79f0", (Object)property.getName());
                            tmpProperty.put("\u5c5e\u6027\u503cID", (Object)item.getId());
                            tmpProperty.put("\u5c5e\u6027\u503c", (Object)item.getName());
                            tmpPropertyArr.add((Object)tmpProperty);
                        }
                        continue;
                    }
                    tmpProperty = new JSONObject();
                    tmpProperty.put("\u5c5e\u6027ID", (Object)property.getId());
                    tmpProperty.put("\u5c5e\u6027\u540d\u79f0", (Object)property.getName());
                    tmpProperty.put("\u5c5e\u6027\u503cID", null);
                    tmpProperty.put("\u5c5e\u6027\u503c", null);
                    tmpPropertyArr.add((Object)tmpProperty);
                }
            }
            tmpCategory.put("\u5206\u7c7b\u4fe1\u606f", (Object)categoryJson);
            tmpCategory.put("\u5339\u914d\u5c5e\u6027", (Object)tmpPropertyArr);
            resp.add(tmpCategory);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", resp);
    }

    @RequestMapping(value={"material/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        HashMap<String, Object> pageParams = new HashMap<String, Object>();
        pageParams.put("orderType", "desc");
        pageParams.put("pageSize", param.getPageSize());
        pageParams.put("startLine", (param.getPageIndex() - 1 < 0 ? 0 : param.getPageIndex() - 1) * param.getPageSize());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");
        pageParams.put("tenantId", InvocationInfoProxy.getTenantid());
        Map params = param.getParams();
        if (null != params.get("enabled") && "-1".equals(((Parameter)params.get("enabled")).getValue().toString())) {
            pageParams.remove("enabled");
        }
        if (null != params.get("blockedFlag") && "-1".equals(((Parameter)params.get("blockedFlag")).getValue().toString())) {
            pageParams.remove("blockedFlag");
        }
        pageParams.put("enabled", ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        pageParams.put("blockedFlag", ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode());
        Long count = this.materialService.pageCount(pageParams);
        if (count > 0L) {
            List<MaterialVO> vos = this.materialService.queryPage(pageParams);
            List records = BeanMapper.mapList(vos, MaterialAiVO.class);
            List<Long> materialIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            List<MaterialRelationAiVO> relations = this.relationService.getAiRelationsByMaterialIds(materialIds);
            Map<Long, List<MaterialRelationAiVO>> materialRaltionMap = relations.stream().collect(Collectors.groupingBy(MaterialRelationAiVO::getMaterialId));
            for (MaterialAiVO m : records) {
                m.setRelationList(materialRaltionMap.get(m.getId()));
            }
            resp.put("records", (Object)records);
        } else {
            resp.put("records", new ArrayList());
        }
        resp.put("total", (Object)count);
        resp.put("pageIndex", (Object)param.getPageIndex());
        resp.put("pageSize", (Object)param.getPageSize());
        resp.put("pages", (Object)(count / (long)param.getPageSize() + (long)(count % (long)param.getPageSize() == 0L ? 0 : 1)));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }
}

