/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyService;
import com.ejianc.business.zdsmaterial.material.vo.MatFeeApplyVO;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matFeeApply"})
public class MatFeeApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMatFeeApplyService service;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatFeeApplyVO> queryDetail(Long id) {
        MatFeeApplyEntity entity = (MatFeeApplyEntity)((Object)this.service.selectById(id));
        MatFeeApplyVO vo = (MatFeeApplyVO)BeanMapper.map((Object)((Object)entity), MatFeeApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatFeeApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatFeeApplyVO vo : vos) {
                MatFeeApplyEntity matFeeApplyEntity = (MatFeeApplyEntity)((Object)this.service.selectById(vo.getId()));
                if (matFeeApplyEntity.getReceiveStatus().equals(InstructionStatusEnum.\u5df2\u9a73\u56de.getStatus())) continue;
                throw new BusinessException("\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u9a73\u56de\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatFeeApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("purchaseWorkerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("supplierManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List matFeeApplyVOS = BeanMapper.mapList((Iterable)page.getRecords(), MatFeeApplyVO.class);
        matFeeApplyVOS.stream().forEach(matFeeApplyVO -> {
            switch (matFeeApplyVO.getPaymentMethodId()) {
                case 1: {
                    matFeeApplyVO.setPaymentMethodName("\u7535\u6c47");
                    break;
                }
                case 2: {
                    matFeeApplyVO.setPaymentMethodName("\u94f6\u884c\u627f\u5151");
                    break;
                }
                case 3: {
                    matFeeApplyVO.setPaymentMethodName("\u4f9b\u5e94\u94fe\u91d1\u878d");
                    break;
                }
            }
            switch (matFeeApplyVO.getReceiveStatus()) {
                case 0: {
                    matFeeApplyVO.setReceiveStatusName("\u5f85\u63d0\u4ea4");
                    break;
                }
                case 1: {
                    matFeeApplyVO.setReceiveStatusName("\u5f85\u5ba1\u6838");
                    break;
                }
                case 2: {
                    matFeeApplyVO.setReceiveStatusName("\u5df2\u5ba1\u6838");
                    break;
                }
                case 3: {
                    matFeeApplyVO.setReceiveStatusName("\u5df2\u9a73\u56de");
                    break;
                }
                case 4: {
                    matFeeApplyVO.setReceiveStatusName("\u5ba1\u6838\u4e2d");
                    break;
                }
                default: {
                    matFeeApplyVO.setReceiveStatusName("\u5f85\u63d0\u4ea4");
                }
            }
        });
        pageData.setRecords(matFeeApplyVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<MatFeeApplyVO>> iPageCommonResponse = this.queryList(param);
        List records = new ArrayList();
        if (iPageCommonResponse.isSuccess()) {
            IPage pageData = (IPage)iPageCommonResponse.getData();
            records = pageData.getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("MatFeeApply-export.xlsx", beans, response);
    }

    @PostMapping(value={"syncBill"})
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        return this.service.syncBill(request);
    }

    @RequestMapping(value={"/pushStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatFeeApplyVO> pushStatus(Long id) {
        return this.service.pushStatus(id);
    }
}

