/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.bean.MatCheckerSettingEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatOrgSettingEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatCheckerSettingService;
import com.ejianc.business.zdsmaterial.material.service.IMatOrgSettingService;
import com.ejianc.business.zdsmaterial.material.vo.MatOrgSettingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matOrgSetting"})
public class MatOrgSettingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMatOrgSettingService service;
    @Autowired
    private IMatCheckerSettingService matCheckerSettingService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatOrgSettingVO> saveOrUpdate(@RequestBody MatOrgSettingVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MatOrgSettingEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        if (this.service.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u5df2\u6dfb\u52a0\u8fc7\u6267\u884c\u90e8\u95e8,\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0!");
        }
        MatOrgSettingEntity entity = (MatOrgSettingEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MatOrgSettingEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        MatOrgSettingVO vo = (MatOrgSettingVO)BeanMapper.map((Object)((Object)entity), MatOrgSettingVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatOrgSettingVO> queryDetail(Long id) {
        MatOrgSettingEntity entity = (MatOrgSettingEntity)((Object)this.service.selectById(id));
        MatOrgSettingVO vo = (MatOrgSettingVO)BeanMapper.map((Object)((Object)entity), MatOrgSettingVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatOrgSettingVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatOrgSettingVO vo : vos) {
                MatOrgSettingEntity entity = (MatOrgSettingEntity)((Object)this.service.selectById(vo.getId()));
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(MatCheckerSettingEntity::getOrgId, (Object)entity.getOrgId());
                if (this.matCheckerSettingService.count((Wrapper)queryWrapper) <= 0) continue;
                CommonResponse response = this.iOrgApi.getOneById(entity.getOrgId());
                throw new BusinessException("\u7ec4\u7ec7\u540d\u79f0[" + ((OrgVO)response.getData()).getName() + "]\u4e0b\u5b58\u5728\u5ba1\u6838\u4eba\u5458\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatOrgSettingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatOrgSettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MatOrgSetting-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMatOrgSettingData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MatOrgSettingVO>> refMatOrgSettingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatOrgSettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

