/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pick.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubContractorEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubRangeEntity;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubContractorService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubRangeService;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pickset/"})
public class ZdsPicksetApi {
    @Autowired
    private IProPickSettingService settingService;
    @Autowired
    private IProSubContractorService contractorService;
    @Autowired
    private IProSubPickerService pickerService;
    @Autowired
    private IProSubRangeService rangeService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IStoreFlowApi flowApi;

    @GetMapping(value={"filterMaterialTypeIds"})
    public CommonResponse<List<Long>> filterMaterialTypeIds(@RequestParam(value="projectId") Long projectId, @RequestParam(value="contractId") Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.settingService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List rangeList = this.rangeService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)rangeList)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
        }
        List typeIds = rangeList.stream().map(ProSubRangeEntity::getMaterialTypeId).collect(Collectors.toList());
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", typeIds);
        query.orderByDesc((Object)"inner_code");
        List categorys = this.categoryService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)categorys)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList());
        }
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.select(new String[]{"id"});
        listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        listQuery.eq((Object)"enabled", (Object)1);
        listQuery.eq((Object)"property_flag", (Object)1);
        listQuery.and(q -> {
            for (MaterialCategoryEntity m : categorys) {
                q.or(iq -> (QueryWrapper)iq.likeRight((Object)"inner_code", (Object)m.getInnerCode()));
            }
            return q;
        });
        List idList = this.categoryService.listObjs((Wrapper)listQuery);
        List ids = idList.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", ids);
    }

    @GetMapping(value={"scanOutStore"})
    public CommonResponse<JSONObject> scanOutStore(@RequestParam(value="projectId") Long projectId, @RequestParam(value="storeId") Long storeId, @RequestParam(value="employeeId") Long employeeId) {
        List contIds;
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.settingService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u672a\u8bbe\u7f6e\u5206\u5305\u9886\u6599\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u540e\u64cd\u4f5c\uff01");
        }
        ProPickSettingEntity entity = (ProPickSettingEntity)((Object)this.settingService.selectById(((ProPickSettingEntity)((Object)list.get(0))).getId()));
        List contList = entity.getProSubContractorList().stream().filter(x -> new Integer(1).equals(x.getEnabled())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contList)) {
            return CommonResponse.error((String)"\u8be5\u9886\u6599\u8bbe\u7f6e\u672a\u8bbe\u7f6e\u542f\u7528\u7684\u5206\u5305\u5408\u540c\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u540e\u64cd\u4f5c\uff01");
        }
        List finalContIds = contIds = contList.stream().map(ProSubContractorEntity::getContractId).collect(Collectors.toList());
        List pickerList = entity.getProSubPickerList().stream().filter(x -> finalContIds.contains(x.getContractId()) && employeeId.equals(x.getSupUserId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pickerList)) {
            return CommonResponse.error((String)"\u8be5\u9886\u6599\u4eba\u6ca1\u6709\u9886\u6599\u6743\u9650\uff0c\u8bf7\u5148\u8bbe\u7f6e\u540e\u64cd\u4f5c\uff01");
        }
        ProSubPickerEntity picker = (ProSubPickerEntity)((Object)pickerList.get(0));
        List finalContIds1 = contIds = pickerList.stream().map(ProSubPickerEntity::getContractId).collect(Collectors.toList());
        contList = contList.stream().filter(x -> finalContIds1.contains(x.getContractId())).collect(Collectors.toList());
        List finalContIds2 = contIds;
        List rangeList = entity.getProSubRangeList().stream().filter(x -> finalContIds2.contains(x.getContractId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rangeList)) {
            return CommonResponse.error((String)"\u8be5\u9886\u6599\u4eba\u672a\u8bbe\u7f6e\u9886\u6599\u8303\u56f4\uff0c\u8bf7\u5148\u8bbe\u7f6e\u540e\u64cd\u4f5c\uff01");
        }
        JSONArray contractList = JSONArray.parseArray((String)JSON.toJSONString(contList));
        for (Object vo : contractList) {
            JSONObject obj = (JSONObject)vo;
            List<Long> typeIds = rangeList.stream().filter(x -> obj.getLong("contractId").equals(x.getContractId())).map(ProSubRangeEntity::getMaterialTypeId).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(typeIds)) continue;
            List<SurplusVO> surplusList = this.querySurplusList(typeIds, storeId);
            obj.put("surplusList", surplusList);
        }
        JSONObject result = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)entity)));
        result.put("supplierEmpId", (Object)picker.getSupUserId());
        result.put("supplierEmpName", (Object)picker.getSupplierEmpName());
        result.put("supplierEmpCode", (Object)picker.getSupplierEmpCode());
        result.put("supplierEmpPhone", (Object)picker.getSupplierEmpPhone());
        result.put("contractList", (Object)contractList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    private List<SurplusVO> querySurplusList(List<Long> typeIds, Long storeId) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", typeIds);
        query.orderByDesc((Object)"inner_code");
        List categorys = this.categoryService.list((Wrapper)query);
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.select(new String[]{"id"});
        listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        listQuery.eq((Object)"enabled", (Object)1);
        listQuery.eq((Object)"property_flag", (Object)1);
        listQuery.and(q -> {
            for (MaterialCategoryEntity m : categorys) {
                q.or(iq -> (QueryWrapper)iq.likeRight((Object)"inner_code", (Object)m.getInnerCode()));
            }
            return q;
        });
        List idList = this.categoryService.listObjs((Wrapper)listQuery);
        List ids = idList.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
        CommonResponse resp = this.flowApi.refSurplusData(storeId);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List<SurplusVO> result = ((List)resp.getData()).stream().filter(x -> ids.contains(x.getMaterialCategoryId())).collect(Collectors.toList());
        return result;
    }
}

