/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.conjecture.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.service.ICommonSNService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.IMaterialConjectureHandler;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component(value="cJYTHandler")
public class CJYTHandler
implements IMaterialConjectureHandler {
    private final String propertySeparator = "\uff1b";
    private final String propertyNameValueSep = "\uff1a";
    private static final String BILL_TYPE_CODE = "EJCBT202311000003";
    @Autowired
    private ICommonSNService commonSNService;
    private final String CONJECTURE_SINGLE_MATERIAL_URL = "/extract_item_attr";
    private final String SEARCH_MATERIAL_URL = "/similar_item_search";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${material.ai.host:http://192.168.202.44:17041}")
    private String reqHost;
    @Value(value="${material.ai.similarLimit:3000}")
    private Integer similarLimit;
    @Value(value="${material.ai.similarThreshold:0}")
    private BigDecimal similarThreshold;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IMaterialConjectureService conjectureService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    private final String SYS_PARAM_CONFIG = "P-Fw47U70005";
    public static final int connTimeout = 60000;
    public static final int readTimeout = 60000;
    private final String ADD_PROPERTY_ITEM_KEY_PREFIX = "AI_CONJECTURE_ADD_ITEM::";
    private final String PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX = "AI_CONJECTURE_ITEM_MAX_SEQ::";
    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async(value="materialConjectureTaskPool")
    public Future<MaterialConjectureVO> conjectureSingle(MaterialConjectureVO source, String authority) {
        this.setContextInfo(authority);
        Jedis jedis = null;
        boolean saveNewPropertyItem = false;
        long startTimeThr = System.nanoTime();
        String url = this.reqHost + "/extract_item_attr";
        JSONObject param = new JSONObject();
        HashMap<String, String> headers = new HashMap<String, String>();
        String reqResult = null;
        MaterialConjectureEntity saveEntity = null;
        try {
            MaterialCategoryEntity secCateogry;
            headers.put("Content-Type", "application/json;charset=UTF-8");
            param.put("item_name", (Object)source.getSourceMaterialName());
            param.put("item_desc", (Object)source.getSourceMaterialSpec());
            param.put("item_id", (Object)source.getId());
            reqResult = HttpTookit.postByJson(url, param.toJSONString(), headers, 60000, 60000);
            long endTimeThr = System.nanoTime();
            long durationThr = endTimeThr - startTimeThr;
            long secondsThr = TimeUnit.NANOSECONDS.toSeconds(durationThr);
            this.logger.info("\u7269\u6599\u8bc6\u522b\u3010\u957f\u6c5f\u4e91\u901a\u3011,\u8017\u65f6\uff1a{} \u79d2, \u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}\uff0c\u7269\u6599\u8bc6\u522b\u7ed3\u679c\uff1a{}", new Object[]{secondsThr, url, JSONObject.toJSONString((Object)param), reqResult});
            JSONObject resJson = JSONObject.parseObject((String)reqResult);
            ArrayList addItemList = new ArrayList();
            MaterialCategoryPropertySubItemEntity tmpAddItem = null;
            if (!"success".equals(resJson.getString("msg"))) {
                source.setMateType("3");
                source.setConjectureMateType("3");
                saveEntity = (MaterialConjectureEntity)((Object)BeanMapper.map((Object)source, MaterialConjectureEntity.class));
                this.conjectureService.saveOrUpdate((Object)saveEntity, false);
                AsyncResult asyncResult = new AsyncResult(BeanMapper.map((Object)((Object)saveEntity), MaterialConjectureVO.class));
                return asyncResult;
            }
            if ("\u65e0\u6cd5\u8bc6\u522b\u51fa\u7269\u6599".equals(resJson.getString("pred_class"))) {
                source.setMateType("0");
                source.setConjectureMateType("0");
                saveEntity = (MaterialConjectureEntity)((Object)BeanMapper.map((Object)source, MaterialConjectureEntity.class));
                this.conjectureService.saveOrUpdate((Object)saveEntity, false);
                AsyncResult asyncResult = new AsyncResult(BeanMapper.map((Object)((Object)saveEntity), MaterialConjectureVO.class));
                return asyncResult;
            }
            source.setConjectureCategoryId(resJson.getLong("pred_class_id"));
            source.setConjectureCategoryName(resJson.getString("pred_class"));
            source.setConjectureMaterialName(resJson.getString("pred_class"));
            source.setActualCategoryId(resJson.getLong("pred_class_id"));
            source.setActualCategoryName(resJson.getString("pred_class"));
            source.setActualMaterialName(resJson.getString("pred_class"));
            MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.categoryService.selectById(source.getActualCategoryId()));
            source.setActualSecCategoryId(category.getParentId());
            List<MaterialCategoryPropertyVO> propertyList = this.propertyService.getAllPropertiesAndValue(source.getConjectureCategoryId(), null, saveNewPropertyItem ? Boolean.valueOf(true) : null);
            Map propertyVOMap = propertyList.parallelStream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            Map itemMap = propertyList.stream().flatMap(item -> item.getItemList().stream()).collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            Map<Long, List<MaterialCategoryPropertySubItemVO>> propertyItemMap = propertyList.stream().flatMap(item -> item.getItemList().stream()).collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId));
            JSONObject propertyJson = resJson.getJSONObject("result");
            source.setConjectureMaterialSpecs(JSONObject.toJSONString((Object)propertyJson));
            JSONArray propertyJsonArr = null;
            ArrayList relationList = new ArrayList();
            MaterialCategoryPropertyVO tmpProperty = null;
            MaterialCategoryPropertySubItemVO tmpItem = null;
            for (String propertyName : propertyJson.keySet()) {
                tmpAddItem = null;
                propertyJsonArr = propertyJson.getJSONArray(propertyName);
                tmpItem = new MaterialCategoryPropertySubItemVO();
                tmpItem.setCategoryId(category.getId());
                tmpItem.setHasNewPropertyVal(Integer.valueOf(0));
                tmpItem.setPropertyName(propertyName);
                tmpItem.setName(propertyJsonArr.getString(0));
                if (StringUtils.isBlank((CharSequence)propertyJsonArr.getString(1))) {
                    source.setMateType("1");
                    source.setConjectureMateType("1");
                } else {
                    tmpItem.setPropertyId(Long.valueOf(propertyJsonArr.get(1).toString()));
                    if (propertyVOMap.containsKey(tmpItem.getPropertyId())) {
                        tmpProperty = (MaterialCategoryPropertyVO)propertyVOMap.get(tmpItem.getPropertyId());
                        tmpItem.setPropertySeq(((MaterialCategoryPropertyVO)propertyVOMap.get(tmpItem.getPropertyId())).getSequence());
                        tmpItem.setProductCodeFlag(((MaterialCategoryPropertyVO)propertyVOMap.get(tmpItem.getPropertyId())).getProductCodeFlag());
                        tmpItem.setRequiredFlag(((MaterialCategoryPropertyVO)propertyVOMap.get(tmpItem.getPropertyId())).getRequiredFlag());
                        tmpItem.setKeyPropertyFlag(((MaterialCategoryPropertyVO)propertyVOMap.get(tmpItem.getPropertyId())).getKeyPropertyFlag());
                        propertyVOMap.remove(tmpItem.getPropertyId());
                    }
                }
                if (StringUtils.isBlank((CharSequence)propertyJsonArr.getString(2))) {
                    if (saveNewPropertyItem && null != tmpItem.getPropertyId() && StringUtils.isNotBlank((CharSequence)tmpItem.getName())) {
                        if (null == jedis) {
                            jedis = this.jedisPool.getResource();
                        }
                        if (null != (tmpAddItem = this.generateItem(tmpItem, propertyItemMap.get(tmpItem.getPropertyId()), jedis)) && null != tmpItem.getId()) {
                            source.getSpecList().add(tmpItem);
                            continue;
                        }
                        source.setMateType("1");
                        source.setConjectureMateType("1");
                        continue;
                    }
                    if (null == tmpProperty || null == tmpProperty.getRequiredFlag() || !Integer.valueOf(1).equals(tmpProperty.getRequiredFlag())) continue;
                    source.setMateType("1");
                    source.setConjectureMateType("1");
                    continue;
                }
                tmpItem.setId(Long.valueOf(propertyJsonArr.get(2).toString()));
                if (itemMap.containsKey(tmpItem.getId())) {
                    tmpItem.setSequence(((MaterialCategoryPropertySubItemVO)itemMap.get(tmpItem.getId())).getSequence());
                    tmpItem.setProductCode(((MaterialCategoryPropertySubItemVO)itemMap.get(tmpItem.getId())).getProductCode());
                    source.getSpecList().add(tmpItem);
                    continue;
                }
                source.setMateType("1");
                source.setConjectureMateType("1");
            }
            if ("4".equals(source.getMateType()) || StringUtils.isBlank((CharSequence)source.getMateType())) {
                if (propertyVOMap.values().stream().filter(item -> null != item.getRequiredFlag() && Integer.valueOf(1).equals(item.getRequiredFlag())).count() > 0L) {
                    source.setMateType("1");
                    source.setConjectureMateType("1");
                } else {
                    source.setMateType("2");
                    source.setConjectureMateType("2");
                    MaterialVO checkVo = new MaterialVO();
                    checkVo.setUnitId(source.getActualUnitId());
                    checkVo.setPropertyShowName(source.getActualMaterialSpec());
                    checkVo.setCategoryId(source.getActualCategoryId());
                    List<MaterialVO> checkList = this.materialService.checkUnitAndProperty(Collections.singletonList(checkVo), false);
                    if (CollectionUtils.isNotEmpty(checkList)) {
                        source.setActualMaterialCode(checkList.get(0).getCode());
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)source.getSpecList())) {
                source.setConjectureMaterialSpec(source.getSpecList().stream().filter(item -> null != item.getId()).sorted((v1, v2) -> (null != v1.getPropertySeq() ? v1.getPropertySeq() : 0) - (null != v2.getPropertySeq() ? v2.getPropertySeq() : 0)).map(item -> item.getPropertyName() + "\uff1a" + item.getName()).collect(Collectors.joining("\uff1b")));
                source.setActualMaterialSpec(source.getConjectureMaterialSpec());
            }
            if (CollectionUtils.isNotEmpty((Collection)source.getSpecList())) {
                JSONArray specArr = new JSONArray();
                JSONObject json = null;
                for (MaterialCategoryPropertySubItemVO s : source.getSpecList()) {
                    json = (JSONObject)BeanMapper.map((Object)s, JSONObject.class);
                    json.put("id", (Object)s.getId().toString());
                    json.put("propertyItemId", (Object)s.getId().toString());
                    json.put("categoryId", (Object)s.getCategoryId().toString());
                    json.put("propertyId", (Object)s.getPropertyId().toString());
                    specArr.add((Object)json);
                }
                source.setActualMaterialSpecs(specArr.toJSONString());
            }
            if (StringUtils.isBlank((CharSequence)source.getActualMaterialCode()) && ("1".equals(source.getMateType()) || "2".equals(source.getMateType()))) {
                MaterialVO tmp = this.generateMaterial(source);
                this.materialService.generateMaterialCodeBatchNew(Collections.singletonList(tmp));
                source.setActualMaterialCode(tmp.getCode());
            }
            if (CollectionUtils.isNotEmpty(addItemList)) {
                this.propertySubItemService.saveOrUpdateBatch(addItemList, addItemList.size(), false);
            }
            if (null != source.getActualSecCategoryId() && null != (secCateogry = (MaterialCategoryEntity)((Object)this.categoryService.selectById(source.getActualSecCategoryId())))) {
                source.setActualSecCategoryCode(secCateogry.getCode());
                source.setActualSecCategoryName(secCateogry.getName());
            }
            saveEntity = (MaterialConjectureEntity)((Object)BeanMapper.map((Object)source, MaterialConjectureEntity.class));
            this.conjectureService.saveOrUpdate((Object)saveEntity, false);
            AsyncResult asyncResult = new AsyncResult(BeanMapper.map((Object)((Object)saveEntity), MaterialConjectureVO.class));
            return asyncResult;
        }
        catch (Exception e) {
            this.logger.error("*****************\u7269\u6599\u8bc6\u522b\u5f02\u5e38*******CJYTHandler ERROR*************", (Throwable)e);
            source.setMateType("3");
            source.setConjectureMateType("3");
            saveEntity = (MaterialConjectureEntity)((Object)BeanMapper.map((Object)source, MaterialConjectureEntity.class));
            this.conjectureService.saveOrUpdate((Object)saveEntity, false);
            AsyncResult asyncResult = new AsyncResult(BeanMapper.map((Object)((Object)saveEntity), MaterialConjectureVO.class));
            return asyncResult;
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    private MaterialCategoryPropertySubItemEntity generateItem(MaterialCategoryPropertySubItemVO source, List<MaterialCategoryPropertySubItemVO> materialCategoryPropertySubItemVOS, Jedis jedis) {
        MaterialCategoryPropertySubItemEntity addItem = null;
        try {
            String itemStr = jedis.get("AI_CONJECTURE_ADD_ITEM::" + source.getPropertyId().toString() + source.getName());
            if (StringUtils.isNotBlank((CharSequence)itemStr)) {
                addItem = (MaterialCategoryPropertySubItemEntity)((Object)JSONObject.parseObject((String)itemStr, MaterialCategoryPropertySubItemEntity.class));
            } else {
                Long setRs;
                addItem = (MaterialCategoryPropertySubItemEntity)((Object)BeanMapper.map((Object)source, MaterialCategoryPropertySubItemEntity.class));
                if (null != addItem) {
                    String maxSeqStr = jedis.get("AI_CONJECTURE_ITEM_MAX_SEQ::" + source.getPropertyId().toString());
                    Integer maxSeq = 0;
                    if (StringUtils.isBlank((CharSequence)maxSeqStr)) {
                        if (null != materialCategoryPropertySubItemVOS) {
                            maxSeq = materialCategoryPropertySubItemVOS.stream().max(Comparator.comparingInt(MaterialCategoryPropertySubItemVO::getSequence)).get().getSequence();
                        }
                    } else {
                        maxSeq = Integer.valueOf(maxSeqStr);
                    }
                    maxSeq = maxSeq + 1;
                    Long setRs2 = jedis.setnx("AI_CONJECTURE_ITEM_MAX_SEQ::" + source.getPropertyId().toString(), maxSeq.toString());
                    if (!"1".equals(setRs2.toString())) {
                        maxSeqStr = jedis.get("AI_CONJECTURE_ITEM_MAX_SEQ::" + source.getPropertyId().toString());
                        if (StringUtils.isBlank((CharSequence)maxSeqStr)) {
                            this.logger.error("AI\u7269\u6599\u8bc6\u522b\uff0c\u5c5e\u6027\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)addItem)));
                            return null;
                        }
                        maxSeq = Integer.valueOf(maxSeqStr);
                        maxSeq = maxSeq + 1;
                    }
                    addItem.setSequence(maxSeq);
                    addItem.setId(IdWorker.getId());
                    addItem.setEnabled(1);
                    addItem.setValidFlag(1);
                    this.propertySubItemService.saveOrUpdate((Object)addItem, false);
                }
                if (!"1".equals((setRs = jedis.setnx("AI_CONJECTURE_ADD_ITEM::" + addItem.getPropertyId().toString() + addItem.getName(), JSONObject.toJSONString((Object)((Object)addItem)))).toString())) {
                    itemStr = jedis.get("AI_CONJECTURE_ADD_ITEM::" + addItem.getPropertyId().toString() + addItem.getName());
                    if (StringUtils.isNotBlank((CharSequence)itemStr)) {
                        addItem = (MaterialCategoryPropertySubItemEntity)((Object)JSONObject.parseObject((String)itemStr, MaterialCategoryPropertySubItemEntity.class));
                    } else {
                        setRs = jedis.setnx("AI_CONJECTURE_ADD_ITEM::" + addItem.getPropertyId().toString() + addItem.getName(), JSONObject.toJSONString((Object)((Object)addItem)));
                        if (!"1".equals(setRs.toString())) {
                            this.logger.error("\u7269\u6599AI\u8bc6\u522b\uff0c\u5c5e\u6027\u503c\u6dfb\u52a0\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)source));
                            addItem = null;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("AI\u8bc6\u522b\u7269\u6599\uff0c\u65b0\u589e\u5c5e\u6027\u5f02\u5e38, {}", (Object)JSONObject.toJSONString((Object)source));
            this.logger.error("AI\u8bc6\u522b\u7269\u6599\uff0c\u65b0\u589e\u5c5e\u6027\u5f02\u5e38", (Throwable)e);
        }
        return addItem;
    }

    private MaterialVO generateMaterial(MaterialConjectureVO source) {
        MaterialVO resp = new MaterialVO();
        resp.setName(source.getActualMaterialName());
        resp.setCategoryId(source.getActualCategoryId());
        resp.setCategoryName(source.getActualCategoryName());
        resp.setUnitId(source.getActualUnitId());
        resp.setUnitName(source.getActualUnitName());
        resp.setUnitId(source.getActualUnitId());
        resp.setRelationList(JSONObject.parseArray((String)source.getActualMaterialSpecs(), MaterialPropertyRelationVO.class));
        resp.setPropertyShowName(source.getActualMaterialSpec());
        return resp;
    }

    private void setContextInfo(String authority) {
        String[] authArr;
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        InvocationInfoProxy.setParameter((String)"authority", (String)authority);
        block14: for (String item : authArr = authority.split(";")) {
            String[] authItem = item.split("=");
            switch (authItem[0]) {
                case "tenantid": {
                    InvocationInfoProxy.setTenantid((Long)Long.valueOf(authItem[1]));
                    continue block14;
                }
                case "orgId": {
                    InvocationInfoProxy.setOrgId((Long)Long.valueOf(authItem[1]));
                    continue block14;
                }
                case "userId": {
                    InvocationInfoProxy.setUserid((Long)Long.valueOf(authItem[1]));
                    continue block14;
                }
                case "userType": {
                    InvocationInfoProxy.setUserType((String)authItem[1]);
                    continue block14;
                }
                case "userCode": {
                    InvocationInfoProxy.setUsercode((String)authItem[1]);
                    continue block14;
                }
            }
        }
    }

    @Override
    public Map<Long, MaterialConjectureVO> similarSearch(String searchText, Integer topLimit, String[] queryRange) {
        return this.similarSearch(searchText, topLimit, queryRange, null);
    }

    @Override
    public Map<Long, MaterialConjectureVO> similarSearch(String searchText, Integer topLimit, String[] queryRange, Integer exactMatch) {
        HashMap<Long, MaterialConjectureVO> resp = new HashMap<Long, MaterialConjectureVO>();
        String url = this.reqHost + "/similar_item_search";
        JSONObject param = new JSONObject();
        HashMap<String, String> headers = new HashMap<String, String>();
        String reqResult = null;
        try {
            headers.put("Content-Type", "application/json;charset=UTF-8");
            param.put("user_query", (Object)searchText);
            param.put("query_limit", (Object)(null != topLimit ? topLimit : this.similarLimit));
            param.put("query_rang", (Object)queryRange);
            param.put("exact_match", (Object)(null != exactMatch ? exactMatch : 0));
            reqResult = HttpTookit.postByJson(url, param.toJSONString(), headers, 60000, 60000);
            this.logger.info("\u7269\u6599AI\u5339\u914d\u3010\u957f\u6c5f\u4e91\u901a\u3011, \u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}\uff0c\u7269\u6599\u8bc6\u522b\u7ed3\u679c\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)param), reqResult});
            JSONObject resultJson = JSONObject.parseObject((String)reqResult);
            JSONArray matchArr = resultJson.getJSONArray("result");
            MaterialConjectureVO tmpVo = null;
            if (matchArr.size() > 0) {
                JSONObject tmpJson = null;
                HashMap materialIds = new HashMap();
                for (Object obj : matchArr) {
                    tmpJson = (JSONObject)obj;
                    if (this.similarThreshold.compareTo(tmpJson.getBigDecimal("distance")) > 0) continue;
                    tmpVo = new MaterialConjectureVO();
                    tmpVo.setActualMaterialId(tmpJson.getLong("id"));
                    tmpVo.setSimilarCoefficient(ComputeUtil.safeMultiply((BigDecimal)tmpJson.getBigDecimal("distance"), (BigDecimal)new BigDecimal("100")).setScale(16, 1));
                    resp.put(tmpVo.getActualMaterialId(), tmpVo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u7269\u6599AI\u5339\u914d\u5f02\u5e38,", (Throwable)e);
        }
        return resp;
    }
}

