/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.api.IBudgetPorjectDetailApi;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanImportService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanDetailVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"controlPlanDetail"})
public class ControlPlanDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IControlPlanService planService;
    @Autowired
    private IControlPlanDetailService service;
    @Autowired
    private IBudgetPorjectDetailApi budgetPorjectDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IControlPlanImportService importService;
    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IUnitApi unitApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ControlPlanDetailVO> saveOrUpdate(@RequestBody ControlPlanDetailVO saveOrUpdateVO) {
        ControlPlanDetailEntity entity = (ControlPlanDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlPlanDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ControlPlanDetailVO vo = (ControlPlanDetailVO)BeanMapper.map((Object)((Object)entity), ControlPlanDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ControlPlanDetailVO> queryDetail(Long id) {
        ControlPlanDetailEntity entity = (ControlPlanDetailEntity)((Object)this.service.selectById(id));
        ControlPlanDetailVO vo = (ControlPlanDetailVO)BeanMapper.map((Object)((Object)entity), ControlPlanDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ControlPlanDetailVO controlPlanDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ControlPlanDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refControlPlanDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanDetailVO>> refControlPlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ControlPlan-material-import.xlsx", (String)"\u603b\u63a7\u8ba1\u5212\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadBudgetDate"})
    @ResponseBody
    public void downloadBudgetDate(Long projectId, String materialPackIds, String materialPackCodes, HttpServletRequest request, HttpServletResponse response) {
        if (projectId == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BudgetProjectDetailQueryVO queryVO = new BudgetProjectDetailQueryVO();
        queryVO.setProjectId(projectId);
        queryVO.setMaterialPackCodes(materialPackCodes);
        queryVO.setPageIndex(Integer.valueOf(1));
        queryVO.setPageSize(Integer.valueOf(-1));
        List list = new ArrayList();
        CommonResponse commonResponse = this.budgetPorjectDetailApi.queryList(queryVO);
        if (commonResponse.isSuccess()) {
            list = ((Page)commonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("material-budget-import.xlsx", beans, response);
    }

    @PostMapping(value={"/saveImport"})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        this.materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);
        this.materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f,\u7269\u6599\u8bc6\u522b\u4e2d\uff01");
    }

    @GetMapping(value={"/getConjectureProgress"})
    @ResponseBody
    public CommonResponse<JSONObject> saveImport(@RequestParam String identificationId, @RequestParam(required=false) String mateType, @RequestParam(required=false) String actualCategoryName, @RequestParam(required=false) String actualMaterialCode, @RequestParam(required=false) String actualMaterialName, @RequestParam(required=false) String actualMaterialSpec, @RequestParam(required=false) String actualUnitName, @RequestParam(required=false) BigDecimal actualNum) {
        JSONObject resp = new JSONObject();
        List<MaterialConjectureEntity> identifyList = this.materialConjectureService.getAllByIdentifyId(identificationId, null, actualCategoryName, actualMaterialCode, actualMaterialName, actualMaterialSpec, actualUnitName, actualNum);
        resp.put("total", (Object)identifyList.size());
        Integer completeMatch = 0;
        Integer partialMatch = 0;
        Integer misMatch = 0;
        resp.put("conjecturedNum", (Object)identifyList.stream().filter(item -> !"3".equals(item.getMateType()) && !"4".equals(item.getMateType())).count());
        ArrayList<MaterialConjectureEntity> respList = new ArrayList<MaterialConjectureEntity>();
        for (MaterialConjectureEntity m : identifyList) {
            switch (m.getMateType()) {
                case "0": {
                    Integer n = misMatch;
                    Integer n2 = misMatch = Integer.valueOf(misMatch + 1);
                    break;
                }
                case "1": {
                    Integer n = partialMatch;
                    Integer n2 = partialMatch = Integer.valueOf(partialMatch + 1);
                    break;
                }
                case "2": {
                    Integer n = completeMatch;
                    Integer n2 = completeMatch = Integer.valueOf(completeMatch + 1);
                    break;
                }
            }
            if (!StringUtils.isBlank((CharSequence)mateType) && !"-1".equals(mateType) && !m.getMateType().equals(mateType)) continue;
            respList.add(m);
        }
        resp.put("completeMatch", (Object)completeMatch);
        resp.put("partialMatch", (Object)partialMatch);
        resp.put("misMatch", (Object)misMatch);
        resp.put("identifyList", CollectionUtils.isNotEmpty(respList) ? BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList());
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/delConjectureDetail"})
    @ResponseBody
    public CommonResponse<String> delConjectureByIds(@RequestBody List<Long> detailIds) {
        this.materialConjectureService.delConjectureByIds(detailIds);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId");
        String mode = request.getParameter("mode");
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "CJYT";
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<MaterialConjectureVO> successList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> processList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> errorList = new ArrayList<MaterialConjectureVO>();
        HashSet<String> unitNames = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            MaterialConjectureVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4");
                vo.setConjectureMateType("4");
                vo.setDelFlag("0");
                vo.setIgnoreFlag("0");
                vo.setLoadState("0");
                vo.setIdentificationDate(new Date());
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setImportSeq((String)datas.get(0));
                vo.setSourceMaterialName((String)datas.get(1));
                vo.setSourceUnitName((String)datas.get(3));
                vo.setSourceMaterialSpec((String)datas.get(2));
                vo.setSourceNum(ComputeUtil.toBigDecimal((String)datas.get(4)));
                vo.setActualNum(ComputeUtil.toBigDecimal((String)datas.get(4)));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setErrorMsg("\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMsg("\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());
                vo.setRowState("add");
                processList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(processList)) {
            CommonResponse unitListResp = this.unitApi.findAllEnabledList(new ArrayList(unitNames));
            if (!unitListResp.isSuccess()) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25,names:{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(unitNames), (Object)JSONObject.toJSONString((Object)unitListResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)unitListResp.getData()))) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a, names:{}", (Object)JSONObject.toJSONString(unitNames));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashMap<String, Long> unitNameIdMap = new HashMap<String, Long>();
            HashMap<String, Long> unitAliasNameIdMap = new HashMap<String, Long>();
            unitNameIdMap.putAll(((List)unitListResp.getData()).stream().collect(Collectors.toMap(UnitShareVO::getUnitName, BaseVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(((List)unitListResp.getData()).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), BaseVO::getId, (k1, k2) -> k1)));
            for (MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());
                if (unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId((Long)unitNameIdMap.get(m.getSourceUnitName()));
                }
                for (String key : unitAliasNameIdMap.keySet()) {
                    if (!key.contains("," + m.getSourceUnitName() + ",")) continue;
                    m.setActualUnitId((Long)unitAliasNameIdMap.get(key));
                }
                if (null == m.getActualUnitId()) {
                    m.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                successList.add(m);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/excelImportBudgetDate"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportBudgetDate(Long projectId, String materialPackIds, String materialPackCodes, HttpServletRequest request) {
        if (projectId == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId");
        String mode = request.getParameter("mode");
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "CJYT";
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<MaterialConjectureVO> successList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> processList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> errorList = new ArrayList<MaterialConjectureVO>();
        HashSet<String> unitNames = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            MaterialConjectureVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4");
                vo.setConjectureMateType("4");
                vo.setDelFlag("0");
                vo.setIgnoreFlag("0");
                vo.setLoadState("0");
                vo.setIdentificationDate(new Date());
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setImportSeq((String)datas.get(0));
                vo.setMaterialPackName((String)datas.get(1));
                vo.setItemCode((String)datas.get(2));
                vo.setSourceMaterialName((String)datas.get(3));
                vo.setSourceUnitName((String)datas.get(5));
                vo.setSourceMaterialSpec((String)datas.get(4));
                vo.setSourceNum(ComputeUtil.toBigDecimal((String)datas.get(6)));
                vo.setActualNum(ComputeUtil.toBigDecimal((String)datas.get(6)));
                vo.setBudgetType("1");
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setErrorMsg("\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());
                vo.setRowState("add");
                processList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(processList)) {
            CommonResponse unitListResp = this.unitApi.findAllEnabledList(new ArrayList(unitNames));
            if (!unitListResp.isSuccess()) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25,names:{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(unitNames), (Object)JSONObject.toJSONString((Object)unitListResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)unitListResp.getData()))) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a, names:{}", (Object)JSONObject.toJSONString(unitNames));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BudgetProjectDetailQueryVO queryVO = new BudgetProjectDetailQueryVO();
            queryVO.setProjectId(projectId);
            queryVO.setMaterialPackCodes(materialPackCodes);
            queryVO.setPageIndex(Integer.valueOf(1));
            queryVO.setPageSize(Integer.valueOf(-1));
            CommonResponse commonResponse = this.budgetPorjectDetailApi.queryList(queryVO);
            if (!commonResponse.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5207\u5305\u6e05\u5355\u5931\u8d25\u5931\u8d25\uff0c\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)commonResponse));
            }
            HashMap<String, Long> unitNameIdMap = new HashMap<String, Long>();
            HashMap<String, Long> unitAliasNameIdMap = new HashMap<String, Long>();
            HashMap budegetMap = new HashMap();
            unitNameIdMap.putAll(((List)unitListResp.getData()).stream().collect(Collectors.toMap(UnitShareVO::getUnitName, BaseVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(((List)unitListResp.getData()).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), BaseVO::getId, (k1, k2) -> k1)));
            if (null != commonResponse.getData()) {
                budegetMap.putAll(((Page)commonResponse.getData()).getRecords().stream().collect(Collectors.toMap(item -> item.getMaterialPackName() + item.getItemCode(), Function.identity(), (v1, v2) -> v2)));
            }
            for (MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());
                if (unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId((Long)unitNameIdMap.get(m.getSourceUnitName()));
                }
                for (String key : unitAliasNameIdMap.keySet()) {
                    if (!key.contains("," + m.getSourceUnitName() + ",")) continue;
                    m.setActualUnitId((Long)unitAliasNameIdMap.get(key));
                }
                if (null == m.getActualUnitId()) {
                    m.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                BudgetProjectDetailVO budgetProjectDetailVO = (BudgetProjectDetailVO)budegetMap.get(m.getMaterialPackName() + m.getItemCode());
                if (null != budgetProjectDetailVO) {
                    m.setItemName(budgetProjectDetailVO.getItemName());
                    m.setMaterialPackId(budgetProjectDetailVO.getMaterialPackId());
                    m.setMaterialPackCode(budgetProjectDetailVO.getMaterialPackCode());
                    m.setBudgetDetailId(budgetProjectDetailVO.getId());
                }
                successList.add(m);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<ControlPlanDetailVO> getMatchSameList(ControlPlanDetailVO vo) {
        ArrayList<ControlPlanDetailVO> matchList = new ArrayList<ControlPlanDetailVO>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"enabled", (Object)1);
        ew.eq((Object)"category_name", (Object)vo.getMaterialTypeName());
        ew.and(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"product_code", (Object)vo.getDescription())).or()).eq((Object)"property_show_name", (Object)vo.getDescription()));
        List list = this.materialService.list((Wrapper)ew);
        List<Long> materialTypeIds = list.stream().map(x -> x.getCategoryId()).distinct().collect(Collectors.toList());
        Map<Long, MaterialCategoryEntity> parentMap = this.planService.getParentMaterialTypeMap(materialTypeIds);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setMatchState(PlanConstant.MATCH_SAME);
            for (MaterialEntity material : list) {
                ControlPlanDetailVO match = new ControlPlanDetailVO();
                match.setId(material.getId());
                match.setMaterialTypeId(material.getCategoryId());
                match.setMaterialTypeName(material.getCategoryName());
                match.setMaterialTypeCode(material.getCategoryCode());
                match.setMaterialId(material.getId());
                match.setMaterialCode(material.getCode());
                match.setMaterialName(material.getName());
                match.setUnitId(material.getUnitId());
                match.setUnitName(material.getUnitName());
                match.setProductCode(material.getProductCode());
                match.setPropertyValue(material.getPropertyShowName());
                MaterialCategoryEntity parent = new MaterialCategoryEntity();
                if (parentMap.containsKey(material.getCategoryId())) {
                    parent = parentMap.get(material.getCategoryId());
                }
                match.setParentMaterialTypeId(parent.getId());
                match.setParentMaterialTypeCode(parent.getCode());
                match.setParentMaterialTypeName(parent.getName());
                match.setRowState("add");
                matchList.add(match);
            }
        }
        return matchList;
    }

    private List<ControlPlanDetailVO> getMatchHistoryList(ControlPlanDetailVO vo) {
        List<Object> matchList = new ArrayList<ControlPlanDetailVO>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"material_type_name", (Object)vo.getMaterialTypeName());
        ew.eq((Object)"description", (Object)vo.getDescription());
        List list = this.importService.list((Wrapper)ew);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setMatchState(PlanConstant.MATCH_HISTORY);
            matchList = BeanMapper.mapList((Iterable)list, ControlPlanDetailVO.class);
            for (ControlPlanDetailVO controlPlanDetailVO : matchList) {
                controlPlanDetailVO.setRowState("add");
            }
        }
        return matchList;
    }

    private List<ControlPlanDetailVO> getMatchLikeList(ControlPlanDetailVO vo) {
        ArrayList<ControlPlanDetailVO> matchList = new ArrayList<ControlPlanDetailVO>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"enabled", (Object)1);
        ew.eq((Object)"category_name", (Object)vo.getMaterialTypeName());
        ew.and(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.like((Object)"product_code", (Object)vo.getDescription())).or()).like((Object)"property_show_name", (Object)vo.getDescription()));
        List list = this.materialService.list((Wrapper)ew);
        List<Long> materialTypeIds = list.stream().map(x -> x.getCategoryId()).distinct().collect(Collectors.toList());
        Map<Long, MaterialCategoryEntity> parentMap = this.planService.getParentMaterialTypeMap(materialTypeIds);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setMatchState(PlanConstant.MATCH_LIKE);
            for (MaterialEntity material : list) {
                ControlPlanDetailVO match = new ControlPlanDetailVO();
                match.setId(material.getId());
                match.setMaterialTypeId(material.getCategoryId());
                match.setMaterialTypeName(material.getCategoryName());
                match.setMaterialTypeCode(material.getCategoryCode());
                match.setMaterialId(material.getId());
                match.setMaterialCode(material.getCode());
                match.setMaterialName(material.getName());
                match.setUnitId(material.getUnitId());
                match.setUnitName(material.getUnitName());
                match.setProductCode(material.getProductCode());
                match.setPropertyValue(material.getPropertyShowName());
                MaterialCategoryEntity parent = new MaterialCategoryEntity();
                if (parentMap.containsKey(material.getCategoryId())) {
                    parent = parentMap.get(material.getCategoryId());
                }
                match.setParentMaterialTypeId(parent.getId());
                match.setParentMaterialTypeCode(parent.getCode());
                match.setParentMaterialTypeName(parent.getName());
                match.setRowState("add");
                matchList.add(match);
            }
        }
        return matchList;
    }
}

