/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.purchase.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.api.IBudgetPorjectDetailApi;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/purchasePlanDetail/"})
public class PurchasePlanDetailController {
    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IBudgetPorjectDetailApi budgetPorjectDetailApi;
    @Autowired
    private IUnitApi unitApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    private final String QUE_BUDGET_DETAIL_REQ_URL = "/cefoc/yql/getContractLimitedSubBList";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ControlPlan-material-import.xlsx", (String)"\u91c7\u8d2d\u8ba1\u5212\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadBudgetDate"})
    @ResponseBody
    public void downloadBudgetDate(Long projectId, String materialPackIds, String materialPackCodes, HttpServletRequest request, HttpServletResponse response) {
        if (projectId == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6 \u5f00\u59cb*********************");
        CommonResponse projectVoResp = this.projectSetApi.getProjectId(projectId);
        if (!projectVoResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getContractLimitedSubBList" + "?ProjectOID=" + ((ProjectPoolSetVO)projectVoResp.getData()).getSourceId();
        if (StringUtils.isNotBlank((CharSequence)materialPackCodes)) {
            reqUrl = reqUrl + "&PackageCode=" + materialPackCodes;
        }
        JSONObject reqJson = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 1);
        String startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ", (Date)calendar.getTime());
        String endDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ", (Date)new Date());
        param.put("BeginDateTime", startDateStr);
        param.put("EndDateTime", endDateStr);
        param.put("PageSize", -1);
        param.put("PageNum", 1);
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                JSONArray pageData = reqJson.getJSONArray("data");
                this.logger.info("\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6\u6570\u636e\uff1a{}\u6761", (Object)pageData.size());
                ArrayList<JSONObject> list = new ArrayList<JSONObject>();
                HashMap<String, ArrayList<JSONObject>> beans = new HashMap<String, ArrayList<JSONObject>>();
                if (pageData.size() == 0) {
                    this.logger.info("\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
                } else {
                    JSONObject tmpJson = null;
                    for (Object obj : pageData) {
                        tmpJson = (JSONObject)obj;
                        JSONObject detailVO = new JSONObject();
                        detailVO.put("materialPackName", (Object)tmpJson.getString("MaterialPackageName"));
                        detailVO.put("id", (Object)tmpJson.getString("YQL_ID"));
                        detailVO.put("itemName", (Object)tmpJson.getString("DownProjectName"));
                        detailVO.put("itemFeature", (Object)tmpJson.getString("DownProjectFeature"));
                        detailVO.put("itemUnit", (Object)tmpJson.getString("DownUnit"));
                        detailVO.put("itemNum", (Object)tmpJson.getBigDecimal("ApproachNum").setScale(2, 4));
                        list.add(detailVO);
                    }
                }
                beans.put("records", list);
                ExcelExport.getInstance().export("material-budget-nocode-import.xlsx", beans, response);
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u5207\u5305\u6e05\u5355\u660e\u7ec6\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
        }
    }

    @PostMapping(value={"/saveImport"})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        this.materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);
        this.materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f,\u7269\u6599\u8bc6\u522b\u4e2d\uff01");
    }

    @GetMapping(value={"/getConjectureProgress"})
    @ResponseBody
    public CommonResponse<JSONObject> saveImport(@RequestParam String identificationId, @RequestParam(required=false) String mateType, @RequestParam(required=false) String actualCategoryName, @RequestParam(required=false) String actualMaterialCode, @RequestParam(required=false) String actualMaterialName, @RequestParam(required=false) String actualMaterialSpec, @RequestParam(required=false) String actualUnitName, @RequestParam(required=false) BigDecimal actualNum) {
        JSONObject resp = new JSONObject();
        List<MaterialConjectureEntity> identifyList = this.materialConjectureService.getAllByIdentifyId(identificationId, null, actualCategoryName, actualMaterialCode, actualMaterialName, actualMaterialSpec, actualUnitName, actualNum);
        resp.put("total", (Object)identifyList.size());
        Integer completeMatch = 0;
        Integer partialMatch = 0;
        Integer misMatch = 0;
        resp.put("conjecturedNum", (Object)identifyList.stream().filter(item -> !"3".equals(item.getMateType()) && !"4".equals(item.getMateType())).count());
        ArrayList<MaterialConjectureEntity> respList = new ArrayList<MaterialConjectureEntity>();
        for (MaterialConjectureEntity m : identifyList) {
            switch (m.getMateType()) {
                case "0": {
                    Integer n = misMatch;
                    Integer n2 = misMatch = Integer.valueOf(misMatch + 1);
                    break;
                }
                case "1": {
                    Integer n = partialMatch;
                    Integer n2 = partialMatch = Integer.valueOf(partialMatch + 1);
                    break;
                }
                case "2": {
                    Integer n = completeMatch;
                    Integer n2 = completeMatch = Integer.valueOf(completeMatch + 1);
                    break;
                }
            }
            if (!StringUtils.isBlank((CharSequence)mateType) && !"-1".equals(mateType) && !m.getMateType().equals(mateType)) continue;
            respList.add(m);
        }
        resp.put("completeMatch", (Object)completeMatch);
        resp.put("partialMatch", (Object)partialMatch);
        resp.put("misMatch", (Object)misMatch);
        resp.put("identifyList", CollectionUtils.isNotEmpty(respList) ? BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList());
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/delConjectureDetail"})
    @ResponseBody
    public CommonResponse<String> delConjectureByIds(@RequestBody List<Long> detailIds) {
        this.materialConjectureService.delConjectureByIds(detailIds);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId");
        String mode = request.getParameter("mode");
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "CJYT";
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<MaterialConjectureVO> successList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> processList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> errorList = new ArrayList<MaterialConjectureVO>();
        HashSet<String> unitNames = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            MaterialConjectureVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4");
                vo.setConjectureMateType("4");
                vo.setDelFlag("0");
                vo.setIgnoreFlag("0");
                vo.setLoadState("0");
                vo.setIdentificationDate(new Date());
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setImportSeq((String)datas.get(0));
                vo.setSourceMaterialName((String)datas.get(1));
                vo.setSourceUnitName((String)datas.get(3));
                vo.setSourceMaterialSpec((String)datas.get(2));
                vo.setSourceNum(ComputeUtil.toBigDecimal((String)datas.get(4)));
                vo.setActualNum(ComputeUtil.toBigDecimal((String)datas.get(4)));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setErrorMsg("\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMsg("\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());
                vo.setRowState("add");
                processList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(processList)) {
            CommonResponse unitListResp = this.unitApi.findAllEnabledList(new ArrayList(unitNames));
            if (!unitListResp.isSuccess()) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25,names:{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(unitNames), (Object)JSONObject.toJSONString((Object)unitListResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)unitListResp.getData()))) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a, names:{}", (Object)JSONObject.toJSONString(unitNames));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashMap<String, Long> unitNameIdMap = new HashMap<String, Long>();
            HashMap<String, Long> unitAliasNameIdMap = new HashMap<String, Long>();
            unitNameIdMap.putAll(((List)unitListResp.getData()).stream().collect(Collectors.toMap(UnitShareVO::getUnitName, BaseVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(((List)unitListResp.getData()).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), BaseVO::getId, (k1, k2) -> k1)));
            for (MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());
                if (unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId((Long)unitNameIdMap.get(m.getSourceUnitName()));
                }
                for (String key : unitAliasNameIdMap.keySet()) {
                    if (!key.contains("," + m.getSourceUnitName() + ",")) continue;
                    m.setActualUnitId((Long)unitAliasNameIdMap.get(key));
                }
                if (null == m.getActualUnitId()) {
                    m.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                successList.add(m);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/excelImportBudgetDate"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportBudgetDate(Long projectId, String materialPackIds, HttpServletRequest request) {
        if (projectId == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId");
        String mode = request.getParameter("mode");
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "CJYT";
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<MaterialConjectureVO> successList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> processList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> errorList = new ArrayList<MaterialConjectureVO>();
        HashSet<String> unitNames = new HashSet<String>();
        ArrayList<Long> budgetDetailIds = new ArrayList<Long>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            MaterialConjectureVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4");
                vo.setConjectureMateType("4");
                vo.setDelFlag("0");
                vo.setIgnoreFlag("0");
                vo.setLoadState("0");
                vo.setIdentificationDate(new Date());
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setImportSeq((String)datas.get(0));
                vo.setMaterialPackName((String)datas.get(1));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setBudgetDetailId(Long.valueOf((String)datas.get(2)));
                    budgetDetailIds.add(Long.valueOf((String)datas.get(2)));
                }
                vo.setSourceMaterialName((String)datas.get(3));
                vo.setSourceUnitName((String)datas.get(5));
                vo.setSourceMaterialSpec((String)datas.get(4));
                vo.setSourceNum(ComputeUtil.toBigDecimal((String)datas.get(6)));
                vo.setActualNum(ComputeUtil.toBigDecimal((String)datas.get(6)));
                vo.setBudgetType("1");
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setErrorMsg("\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());
                vo.setRowState("add");
                processList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(processList)) {
            CommonResponse unitListResp = this.unitApi.findAllEnabledList(new ArrayList(unitNames));
            if (!unitListResp.isSuccess()) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25,names:{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(unitNames), (Object)JSONObject.toJSONString((Object)unitListResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)unitListResp.getData()))) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a, names:{}", (Object)JSONObject.toJSONString(unitNames));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashMap<String, Long> unitNameIdMap = new HashMap<String, Long>();
            HashMap<String, Long> unitAliasNameIdMap = new HashMap<String, Long>();
            HashMap budegetMap = new HashMap();
            unitNameIdMap.putAll(((List)unitListResp.getData()).stream().collect(Collectors.toMap(UnitShareVO::getUnitName, BaseVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(((List)unitListResp.getData()).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), BaseVO::getId, (k1, k2) -> k1)));
            if (CollectionUtils.isNotEmpty(budgetDetailIds)) {
                BudgetProjectDetailQueryVO queryVO = new BudgetProjectDetailQueryVO();
                queryVO.setProjectId(projectId);
                queryVO.setBudgetDetailIds(StringUtils.join(budgetDetailIds, (String)","));
                queryVO.setPageIndex(Integer.valueOf(1));
                queryVO.setPageSize(Integer.valueOf(-1));
                CommonResponse commonResponse = this.budgetPorjectDetailApi.queryList(queryVO);
                if (!commonResponse.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u5207\u5305\u6e05\u5355\u5931\u8d25\u5931\u8d25\uff0c\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)commonResponse));
                }
                if (null != commonResponse.getData()) {
                    budegetMap.putAll(((Page)commonResponse.getData()).getRecords().stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (v1, v2) -> v2)));
                }
            }
            for (MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());
                if (unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId((Long)unitNameIdMap.get(m.getSourceUnitName()));
                }
                for (String key : unitAliasNameIdMap.keySet()) {
                    if (!key.contains("," + m.getSourceUnitName() + ",")) continue;
                    m.setActualUnitId((Long)unitAliasNameIdMap.get(key));
                }
                if (null == m.getActualUnitId()) {
                    m.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                BudgetProjectDetailVO budgetProjectDetailVO = (BudgetProjectDetailVO)budegetMap.get(m.getBudgetDetailId());
                if (null != budgetProjectDetailVO) {
                    m.setItemCode(budgetProjectDetailVO.getItemCode());
                    m.setItemName(budgetProjectDetailVO.getItemName());
                    m.setMaterialPackId(budgetProjectDetailVO.getMaterialPackId());
                    m.setMaterialPackCode(budgetProjectDetailVO.getMaterialPackCode());
                }
                successList.add(m);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/refERPBudgetProjectDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> refERPBudgetProjectDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Page iPage = new Page();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map _con = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (_con.get("projectId") == null) {
                throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String projectId = _con.get("projectId").toString();
            this.logger.info("*********************\u4e2d\u7535\u56db-\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6 \u5f00\u59cb*********************");
            CommonResponse projectVoResp = this.projectSetApi.getProjectId(Long.valueOf(projectId));
            if (!projectVoResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getContractLimitedSubBList" + "?ProjectOID=" + ((ProjectPoolSetVO)projectVoResp.getData()).getSourceId();
            JSONObject reqJson = null;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1900, 0, 1);
            String startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ", (Date)calendar.getTime());
            String endDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ", (Date)new Date());
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
            param.put("PageSize", -1);
            param.put("PageNum", 1);
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            try {
                Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
                String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
                reqJson = JSONObject.parseObject((String)reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                    JSONArray pageData = reqJson.getJSONArray("data");
                    this.logger.info("\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6\u6570\u636e\uff1a{}\u6761", (Object)pageData.size());
                    JSONObject tmpJson = null;
                    HashSet<String> hashSet = new HashSet<String>();
                    for (Object obj : pageData) {
                        JSONObject detailVO;
                        tmpJson = (JSONObject)obj;
                        if (StringUtils.isBlank((CharSequence)tmpJson.getString("MaterialPackageCode")) || hashSet.contains(tmpJson.getString("MaterialPackageCode"))) continue;
                        if (null != searchText) {
                            if (!tmpJson.getString("MaterialPackageCode").contains(searchText) && !tmpJson.getString("MaterialPackageName").contains(searchText)) continue;
                            detailVO = new JSONObject();
                            detailVO.put("id", (Object)tmpJson.getString("YQL_ID"));
                            detailVO.put("materialPackName", (Object)tmpJson.getString("MaterialPackageName"));
                            detailVO.put("materialPackCode", (Object)tmpJson.getString("MaterialPackageCode"));
                            detailVO.put("materialPackId", null);
                            detailVO.put("type", (Object)"\u6750\u6599\u5305");
                            hashSet.add(tmpJson.getString("MaterialPackageCode"));
                            list.add(detailVO);
                            continue;
                        }
                        detailVO = new JSONObject();
                        detailVO.put("id", (Object)tmpJson.getString("YQL_ID"));
                        detailVO.put("materialPackName", (Object)tmpJson.getString("MaterialPackageName"));
                        detailVO.put("materialPackCode", (Object)tmpJson.getString("MaterialPackageCode"));
                        detailVO.put("materialPackId", null);
                        detailVO.put("type", (Object)"\u6750\u6599\u5305");
                        hashSet.add(tmpJson.getString("MaterialPackageCode"));
                        list.add(detailVO);
                    }
                    iPage.setRecords(list.subList((pageNumber - 1) * pageSize, Math.min(pageNumber * pageSize, list.size())));
                    iPage.setPages((long)((int)Math.ceil((double)list.size() / (double)pageSize.intValue())));
                    iPage.setTotal((long)list.size());
                    iPage.setSize((long)pageSize.intValue());
                    iPage.setCurrent((long)pageNumber.intValue());
                    return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)iPage);
                }
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u5207\u5305\u6e05\u5355\u660e\u7ec6\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u5207\u5305\u6e05\u5355\u660e\u7ec6\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            }
        } else {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)iPage);
    }
}

