/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.processor;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.pricelib.processor.BaseCalcProcessor;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import java.math.BigDecimal;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class D2001DoublePriceProcessor
implements BaseCalcProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean calcBeforeCheck(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        MaterialCategoryVO categoryVO = priceLibVO.getCategoryVO();
        String categoryName = "";
        if (null != categoryVO) {
            categoryName = categoryVO.getName();
        }
        if (null == priceLibVO.getBaseMaterialNetPrice()) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u539f\u6750\u6599\u7f51\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialUnitPrice()) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u539f\u6750\u6599\u57fa\u7840\u4ef7\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)calcFormula.getCalcParams())) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        JSONObject calcParamJson = JSONObject.parseObject((String)calcFormula.getCalcParams());
        if (null == calcParamJson.get((Object)"\u53c2\u65701")) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u3010\u53c2\u65701\u3011\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u3010\u53c2\u65701\u3011\u4e3a\u7a7a");
            return false;
        }
        if (null == calcParamJson.get((Object)"\u53c2\u65702")) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u3010\u53c2\u65702\u3011\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8f85\u52a9\u8ba1\u7b97\u53c2\u6570\u3010\u53c2\u65702\u3011\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)priceLibVO.getCalcFields())) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8ddd\u79bb\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u8ddd\u79bb]\u4e3a\u7a7a");
            return false;
        }
        JSONObject paramJson = JSONObject.parseObject((String)priceLibVO.getCalcFields());
        if (null == paramJson.get((Object)"distance") && StringUtil.isBlank((CharSequence)priceLibVO.getCalcFields())) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u8ddd\u79bb\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u8ddd\u79bb]\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseMaterialPrice()) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u69fd\u5355\u4ef7\u57fa\u51c6\u4ef7\u683c\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u69fd\u5355\u4ef7\u57fa\u51c6\u4ef7\u683c\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)priceLibVO.getExtParam1())) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u69fd\u91cd\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u69fd\u91cd]\u4e3a\u7a7a");
            return false;
        }
        if (null == priceLibVO.getBaseTwoMaterialPrice()) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c\u76d6\u5355\u4ef7\u57fa\u51c6\u4ef7\u683c\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u76d6\u5355\u4ef7\u57fa\u51c6\u4ef7\u683c\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isBlank((CharSequence)priceLibVO.getExtParam2())) {
            this.logger.error("\u3010{}\u3011\u516c\u5f0f\uff1aD2001DoublePriceProcessor \u8ba1\u7b97\u7ec8\u6b62\uff0c \u76d6\u91cd\u4e3a\u7a7a, {}", (Object)categoryName, (Object)JSONObject.toJSONString((Object)priceLibVO));
            priceLibVO.setCalcContent("\u672a\u8ba1\u7b97\uff1a\u8ba1\u7b97\u56e0\u7d20[\u76d6\u91cd]\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    @Override
    public BigDecimal calc(PriceLibVO priceLibVO, MaterialPriceCalcSubConditionVO calcFormula) {
        if (!this.calcBeforeCheck(priceLibVO, calcFormula)) {
            return BigDecimal.ZERO;
        }
        priceLibVO.setCalcContent(calcFormula.getCalcDisplayContent());
        MaterialPriceSubConditionDetailVO calcElem = (MaterialPriceSubConditionDetailVO)calcFormula.getDetailList().get(0);
        JSONObject calcParams = JSONObject.parseObject((String)calcFormula.getCalcParams());
        JSONObject calcFields = JSONObject.parseObject((String)priceLibVO.getCalcFields());
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal resultTwo = BigDecimal.ZERO;
        result = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeDiv(priceLibVO.getBaseMaterialPrice(), new BigDecimal(calcParams.getString("\u53c2\u65701"))), new BigDecimal(priceLibVO.getExtParam1())), new BigDecimal("1000"));
        result = ComputeUtil.safeAdd(result, ComputeUtil.safeSub(ComputeUtil.safeMultiply(priceLibVO.getBaseMaterialNetPrice(), new BigDecimal(calcParams.getString("\u53c2\u65702"))), ComputeUtil.safeMultiply(new BigDecimal("4250"), new BigDecimal(calcParams.getString("\u53c2\u65702")))));
        result = ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(result, new BigDecimal(calcParams.getString("\u53c2\u65701"))), new BigDecimal("0.001")), new BigDecimal(priceLibVO.getExtParam1()));
        priceLibVO.setAdjustedFirstPrice(result);
        resultTwo = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeDiv(priceLibVO.getBaseTwoMaterialPrice(), new BigDecimal(calcParams.getString("\u53c2\u65701"))), new BigDecimal(priceLibVO.getExtParam1())), new BigDecimal("1000"));
        resultTwo = ComputeUtil.safeAdd(resultTwo, ComputeUtil.safeSub(ComputeUtil.safeMultiply(priceLibVO.getBaseMaterialNetPrice(), new BigDecimal(calcParams.getString("\u53c2\u65702"))), ComputeUtil.safeMultiply(new BigDecimal("4250"), new BigDecimal(calcParams.getString("\u53c2\u65702")))));
        resultTwo = ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(resultTwo, new BigDecimal(calcParams.getString("\u53c2\u65701"))), new BigDecimal("0.001")), new BigDecimal(priceLibVO.getExtParam1()));
        resultTwo = ComputeUtil.safeAdd(resultTwo, ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(ComputeUtil.safeMultiply(new BigDecimal(calcFields.getString("distance")), new BigDecimal("0.36")), new BigDecimal(priceLibVO.getExtParam2())), new BigDecimal("0.001")));
        priceLibVO.setAdjustedSecPrice(resultTwo);
        priceLibVO.setAdjustedPrice(ComputeUtil.safeAdd(result, resultTwo));
        priceLibVO.setCalcMny(ComputeUtil.safeMultiply(priceLibVO.getAdjustedPrice(), priceLibVO.getSourceNum()));
        return priceLibVO.getAdjustedPrice();
    }
}

