/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorContractDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorSetEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorUserDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorSetService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subFeeApply")
public class SubFeeApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubFeeApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAuditorSetService auditorService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SubFeeApplyEntity entity = (SubFeeApplyEntity)((Object)this.service.selectById(billId));
        SubFeeApplyVO vo = (SubFeeApplyVO)BeanMapper.map((Object)((Object)entity), SubFeeApplyVO.class);
        this.service.validateApplying(vo);
        this.service.validateApplyMny(vo);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SubFeeApplyEntity entity = (SubFeeApplyEntity)((Object)this.service.selectById(billId));
        if (PlanConstant.SOURCE_TYPE_SUPPLIER.equals(entity.getSourceType())) {
            SubFeeApplyVO vo = (SubFeeApplyVO)BeanMapper.map((Object)((Object)entity), SubFeeApplyVO.class);
            vo.setApplyType(PlanConstant.APPLY_TYPE_COMMIT.toString());
            String msg = this.service.updateApplyType(vo);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return CommonResponse.error((String)msg);
            }
        } else {
            entity.setApplyType(PlanConstant.APPLY_TYPE_COMMIT.toString());
            this.service.saveOrUpdate((Object)entity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SubFeeApplyEntity entity = (SubFeeApplyEntity)((Object)this.service.selectById(billId));
        SubFeeApplyVO vo = (SubFeeApplyVO)BeanMapper.map((Object)((Object)entity), SubFeeApplyVO.class);
        this.service.validateApplying(vo);
        this.service.validateApplyMny(vo);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SubFeeApplyEntity entity = (SubFeeApplyEntity)((Object)this.service.selectById(billId));
        UserContext user = this.sessionManager.getUserContext();
        entity.setSupOperateTime(new Date());
        entity.setSupOperatorPhone(user.getUserMobile());
        entity.setSupOperatorName(user.getUserName());
        entity.setSupOperatorUserCode(user.getUserCode());
        entity.setApplyType(PlanConstant.APPLY_TYPE_APPROVE.toString());
        Long sourceId = this.service.pushBillToSupCenter(entity);
        if (sourceId == null) {
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        }
        entity.setSourceId(sourceId);
        this.service.updateById((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u7684\u5ba1\u6279\u4ebaapi\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "\uff0csign:" + sign);
        JSONArray array = new JSONArray();
        SubFeeApplyEntity entity = (SubFeeApplyEntity)((Object)this.service.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        List list = this.auditorService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((Object)array);
        }
        AuditorSetEntity auditor = (AuditorSetEntity)((Object)this.auditorService.selectById(((AuditorSetEntity)((Object)list.get(0))).getId()));
        List<AuditorContractDetailEntity> contList = auditor.getContractDetailList();
        List<AuditorUserDetailEntity> userList = auditor.getUserDetailList();
        List userDetailIds = contList.stream().filter(x -> x.getContractId().equals(entity.getContractId())).map(x -> x.getUserDetailId()).collect(Collectors.toList());
        List result = userList.stream().filter(x -> userDetailIds.contains(x.getRelationId()) && x.getStationName().equals(sign)).collect(Collectors.toList());
        for (AuditorUserDetailEntity user : result) {
            JSONObject obj = new JSONObject();
            obj.put("userId", (Object)user.getUserId());
            obj.put("userName", (Object)user.getUserName());
            array.add((Object)obj);
        }
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u7684\u5ba1\u6279\u4eba\u7ed3\u679c\uff1a{}", (Object)array.toString());
        return CommonResponse.success((Object)array);
    }
}

