/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.subvisa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeSetDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.mapper.SignatureChangeMapper;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeService;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.SignatureChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="signatureChangeService")
public class SignatureChangeServiceImpl
extends BaseServiceImpl<SignatureChangeMapper, SignatureChangeEntity>
implements ISignatureChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE_CODE = "EJCBT202402000002";
    private static final String BILL_CODE = "SIGNCH-CODE";
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/signatureChange/syncBill";
    private final String OPERATE = "InstructionSetBill";
    @Autowired
    private IInstructionSetService instructionSetService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private SignatureChangeMapper mapper;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private ISubContractService subContractService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        Object empResp;
        List attachmentVOS;
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u5206\u5305\u7b7e\u7ae0\u5355\u636e: {}, \u5f53\u524d\u4e0a\u4e0b\u6587: {}", (Object)transData, (Object)authority);
        if (StringUtils.isBlank((CharSequence)transData)) {
            return CommonResponse.error((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        SignatureChangeEntity entity = (SignatureChangeEntity)((Object)JSONObject.parseObject((String)transData, SignatureChangeEntity.class));
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u5206\u5305\u7b7e\u7ae0\u8f6c\u6362\u5355\u636e: {}", (Object)entity);
        long id = IdWorker.getId();
        Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE_CODE, authority, String.valueOf(id));
        this.logger.info("\u4fdd\u5b58\u5355\u636e\u4e2d\u9644\u4ef6\u5e76\u83b7\u53d6\u5230\u4e0a\u4f20\u540e\u9644\u4ef6\u7684Id: {}", (Object)JSONObject.toJSONString((Object)attachIdsMap));
        this.logger.info("\u4fdd\u5b58\u5355\u636e\u4e2d\u9644\u4ef6\u5e76\u83b7\u53d6\u5230\u4e0a\u4f20\u540e\u9644\u4ef6\u7684nameSourceTypeMapping: {}", (Object)nameSourceTypeMapping);
        ArrayList attchIdsList = new ArrayList();
        for (List attachIds : attachIdsMap.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
            attchIdsList.addAll(attachIds);
        }
        entity.setSourceId(entity.getId());
        entity.setId(id);
        Map<Object, Object> collect = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(attachmentVOS = (List)listCommonResponse.getData()))) {
            collect = attachmentVOS.stream().collect(Collectors.toMap(e -> e.getFileName(), e -> e.getId()));
        }
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveStatus(InstructionStatusEnum.\u5f85\u5ba1\u6838.getStatus());
        EmployeeVO creator = null;
        if (entity.getSetId() != null) {
            entity.setSourceType(InstructionStatusEnum.\u6765\u6e90\u6307\u4ee4\u5355.getStatus());
            this.instructionSetService.changeInstructionSetStatus(entity.getSetId(), InstructionStatusEnum.\u5df2\u5f15\u7528.getStatus());
            InstructionSetEntity instruct = (InstructionSetEntity)((Object)this.instructionSetService.selectById(entity.getSetId()));
            if (null == instruct) {
                this.logger.error("\u4f9b\u65b9\u53d8\u66f4\u7b7e\u8bc1\u5355\u4fddid-{}\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u6307\u4ee4\u5355\u4fe1\u606fid-{}\u4e3a\u7a7a\uff01", (Object)entity.getSourceId(), (Object)entity.getSetId());
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u6307\u4ee4\u5355\u4fe1\u606f\u5931\u8d25\uff01");
            }
            empResp = this.employeeApi.getByEmpmloyeeCode(instruct.getCreateUserCode());
            if (empResp.isSuccess() || null == empResp.getData()) {
                this.logger.error("\u4f9b\u65b9\u53d8\u66f4\u7b7e\u8bc1\u5355\u4fddid-{}\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u6307\u4ee4\u5355\u521b\u5efa\u4eba\u4fe1\u606f[userCode-{}]\u4e3a\u7a7a\uff01", (Object)entity.getSourceId(), (Object)(null != instruct ? instruct.getCreateUserCode() : "\u6307\u4ee4\u5355\u4fe1\u606f\u4e3a\u7a7a"));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u6307\u4ee4\u5355\u521b\u5efa\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
            }
            creator = (EmployeeVO)empResp.getData();
        } else {
            entity.setSourceType(InstructionStatusEnum.\u76f4\u63a5\u65b0\u589e.getStatus());
            SubContractEntity contract = (SubContractEntity)((Object)this.subContractService.selectById(entity.getSubContractId()));
            empResp = this.employeeApi.getOneBySourceId(contract.getSourceCompileId());
            if (empResp.isSuccess() || null == empResp.getData()) {
                this.logger.error("\u4f9b\u65b9\u53d8\u66f4\u7b7e\u8bc1\u5355\u4fddid-{}\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5206\u5305\u5408\u540c[id-{}]\u5f55\u5165\u4eba\u4fe1\u606f[sourceId-{}]\u4e3a\u7a7a\uff01", new Object[]{entity.getSourceId(), null != contract ? contract.getId() : "\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a", null != contract ? contract.getSourceCompileId() : "\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a"});
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5408\u540c\u5f55\u5165\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
            }
            creator = (EmployeeVO)empResp.getData();
        }
        entity.setAttachIds(attchIdsList);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setVersion(null);
        entity.setCreateUserCode(creator.getCode());
        entity.setUpdateUserCode(null);
        Map<Object, Object> finalCollect = collect;
        for (SignatureChangeDetailEntity signatureChangeDetailEntity : entity.getDetailList()) {
            if (finalCollect.containsKey(signatureChangeDetailEntity.getAttachmentName())) {
                signatureChangeDetailEntity.setAttachmentId((Long)finalCollect.get(signatureChangeDetailEntity.getAttachmentName()));
            }
            signatureChangeDetailEntity.setId(IdWorker.getId());
            signatureChangeDetailEntity.setSignatureId(entity.getId());
            signatureChangeDetailEntity.setSourceId(signatureChangeDetailEntity.getId());
            signatureChangeDetailEntity.setCreateTime(null);
            signatureChangeDetailEntity.setUpdateTime(null);
            signatureChangeDetailEntity.setTenantId(InvocationInfoProxy.getTenantid());
            signatureChangeDetailEntity.setUpdateUserCode(null);
            signatureChangeDetailEntity.setCreateUserCode(creator.getCode());
            signatureChangeDetailEntity.setVersion(null);
        }
        for (SignatureChangeSetDetailEntity signatureChangeSetDetailEntity : entity.getSetDetailList()) {
            signatureChangeSetDetailEntity.setId(IdWorker.getId());
            signatureChangeSetDetailEntity.setSignatureId(entity.getId());
            signatureChangeSetDetailEntity.setSourceId(signatureChangeSetDetailEntity.getId());
            signatureChangeSetDetailEntity.setCreateTime(null);
            signatureChangeSetDetailEntity.setUpdateTime(null);
            signatureChangeSetDetailEntity.setTenantId(InvocationInfoProxy.getTenantid());
            signatureChangeSetDetailEntity.setUpdateUserCode(null);
            signatureChangeSetDetailEntity.setCreateUserCode(creator.getCode());
            signatureChangeSetDetailEntity.setVersion(null);
        }
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u5206\u5305\u7b7e\u7ae0\u8f6c\u6362\u4fdd\u5b58\u5355\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        super.saveOrUpdate((Object)entity, false);
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setContent("\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + entity.getProjectName() + "\u3011\uff0c\u3010" + entity.getSubContractName() + "\u3011\uff0c\u3010" + entity.getSupplierName() + "\u63d0\u4ea4\u4e86\u53d8\u66f4\u7533\u8bf7\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
        parameter.setSubject("\u3010\u7b7e\u8bc1\u53d8\u66f4\u3011\uff0c\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01");
        parameter.setReceivers(new String[]{entity.getEmployeeId().toString()});
        parameter.setPcUrl(this.baseHost + "ejc-zdsmaterial-frontend/#/signatureChange/card?id=" + entity.getId().toString());
        this.sendMsg(parameter, entity.getId(), "\u4f9b\u65b9\u63d0\u4ea4\u53d8\u66f4\u7b7e\u8bc1 \u5411\u6307\u4ee4\u53d1\u5e03\u4eba\u53d1\u9001\u6d88\u606f");
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("\u63d0\u9192");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("\u53d8\u66f4\u7b7e\u8bc1id-{}\u4f9b\u65b9\u63d0\u4ea4\u5ba1\u6838\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", new Object[]{billId, oprMsg, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("\u53d8\u66f4\u7b7e\u8bc1id-{}\u4f9b\u65b9\u63d0\u4ea4\u5ba1\u6838\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)billId, (Object)oprMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushBill(SignatureChangeEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "InstructionSetBill::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"InstructionSetBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "InstructionSetBill");
                String string = "\u5206\u5305\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u5206\u5305\u53d8\u66f4-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u5206\u5305\u53d8\u66f4\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
            this.logger.info("\u5206\u5305\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u5206\u5305\u53d8\u66f4\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/signatureChange/syncBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/signatureChange/syncBill", params, entity.getSupplierId().toString(), null);
            this.logger.error("\u5206\u5305\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "InstructionSetBill");
                this.logger.error("\u5206\u5305\u53d8\u66f4id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u5206\u5305\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u53d8\u66f4id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "InstructionSetBill");
                String string = "\u5206\u5305\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5206\u5305\u53d8\u66f4id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5305\u53d8\u66f4\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "InstructionSetBill");
        }
        return msg;
    }

    @Override
    public CommonResponse<SignatureChangeVO> pushStatus(SignatureChangeVO saveOrUpdateVO) {
        SignatureChangeEntity entity = (SignatureChangeEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        entity.setReceiveStatus(InstructionStatusEnum.\u5df2\u9a73\u56de.getStatus());
        String s = this.pushBill(entity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new BusinessException(s);
        }
        if (entity.getSetId() != null) {
            this.instructionSetService.changeInstructionSetStatus(entity.getSetId(), InstructionStatusEnum.\u672a\u5f15\u7528.getStatus());
        }
        super.saveOrUpdate((Object)entity, false);
        SignatureChangeVO instructionSetVO = (SignatureChangeVO)BeanMapper.map((Object)((Object)entity), SignatureChangeVO.class);
        return CommonResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01", (Object)instructionSetVO);
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return this.mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return this.mapper.pageList(queryParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

