/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.util;

import com.ejianc.framework.core.util.JsonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(DataJsonUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String object2JsonStr(Object pojo) {
        if (pojo == null) {
            return null;
        }
        String json = null;
        JsonGenerator jsonGenerator = null;
        try {
            StringWriter sw = new StringWriter();
            jsonGenerator = MAPPER.getFactory().createGenerator((Writer)sw);
            jsonGenerator.writeObject(pojo);
            json = sw.toString();
        }
        catch (IOException e) {
            log.error("Convert to json failure.", (Throwable)e);
        }
        finally {
            if (jsonGenerator != null) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
        return json;
    }

    public static <T> T jsonStr2Object(String json, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object obj = null;
        try {
            obj = MAPPER.readValue(json, cls);
        }
        catch (Exception e) {
            if (!JsonUtils.isJson((String)json)) {
                log.error("content is not json: " + json + " --> " + e.getMessage());
            }
            log.error("Convert to object failure: " + json, (Throwable)e);
        }
        return (T)obj;
    }

    public static <T> T jsonStr2Object(String json, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object obj = null;
        try {
            obj = MAPPER.readValue(json, typeReference);
        }
        catch (Exception e) {
            if (!JsonUtils.isJson((String)json)) {
                log.error("content is not json: " + json + " --> " + e.getMessage());
            }
            log.error("Convert to object failure: " + json, (Throwable)e);
        }
        return (T)obj;
    }

    public static <T> List<T> json2List(String json, Class<T[]> cls) {
        Object[] objArr = (Object[])JsonUtils.jsonStr2Object((String)json, cls);
        return Arrays.asList(objArr);
    }

    public static JsonNode json2Tree(String json) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        if (!JsonUtils.isJson((String)json)) {
            log.error("content is not json: " + json);
            return null;
        }
        JsonNode jsonTree = null;
        try {
            jsonTree = MAPPER.readTree(json);
        }
        catch (Exception e) {
            log.error("Convert to JsonNode failure: " + json, (Throwable)e);
        }
        return jsonTree;
    }

    public static boolean isJson(String json) {
        return json.trim().startsWith("{") || json.trim().startsWith("[");
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

