package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountDetailEntity;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountDetailService;
import com.ejianc.business.zdsmaterial.erp.vo.ExpenseAccountDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/24 10:50
 */
@RestController
@RequestMapping(value = "/expenseAccountDetail")
public class ExpenseAccountDetailController {

    @Autowired
    private IExpenseAccountDetailService service;

    /**
     * @Description 参照
     * @Return void
     */
    @GetMapping(value = "refExpenseAccountDetailList")
    public CommonResponse<IPage<ExpenseAccountDetailVO>> refExpenseAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("brandName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialSerialNo");
        fuzzyFields.add("propertyValue");
        fuzzyFields.add("productCode");
        fuzzyFields.add("detailUnitName");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        Map<String, Parameter> params = param.getParams();
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(condition)) {
            JSONObject paramJson = JSONObject.parseObject(condition);
            if(paramJson.containsKey("pid")) {
                params.put("pid", new Parameter(QueryParam.EQ, paramJson.get("pid")));
            }
        }

        param.getOrderMap().put("createTime", "desc");

        IPage<ExpenseAccountDetailEntity> page = service.queryPage(param,false);
        IPage<ExpenseAccountDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpenseAccountDetailVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

}
